<?php

/**
 * 领取地图挑战赛大奖
 */

namespace Game\Controller\Activity\MapChallenge;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\MapChallengeLogic;
use Game\Protobuf\CGMapChallengeReward;
use Game\Protobuf\GCMapChallengeReward;
use Game\Protobuf\PacketId;

class CG_MapChallengeReward extends ControllerBase
{
    use MapChallengeLogic;

    private GCMapChallengeReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGMapChallengeReward();
        $this->sendMessage = new GCMapChallengeReward();
    }

    public function run(): int
    {
        [$code, $status] = $this->getMapChallengeReward();
        $this->sendMessage->setCode($code);
        $this->sendMessage->setActivityRewardStatus($status);
        SendMessage::getInstance()->sendClient(PacketId::GC_MapChallengeReward, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
