<?php

/**
 * 地图挑战赛地图奖励
 */

namespace Game\Controller\Activity\MapChallenge;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\MapChallengeLogic;
use Game\Protobuf\CGMapChallengeMapReward;
use Game\Protobuf\GCMapChallengeMapReward;
use Game\Protobuf\PacketId;

class CG_MapChallengeMapReward extends ControllerBase
{
    use MapChallengeLogic;

    private GCMapChallengeMapReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGMapChallengeMapReward();
        $this->sendMessage = new GCMapChallengeMapReward();
    }

    public function run(): int
    {
        [$code, $mapInfo] = $this->getMapChallengeMapReward($this->message->getMapId());
        $this->sendMessage->setCode($code);
        $this->sendMessage->setMapInfo($mapInfo);
        SendMessage::getInstance()->sendClient(PacketId::GC_MapChallengeMapReward, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
