<?php

/**
 * 获取地图挑战赛信息
 */

namespace Game\Controller\Activity\MapChallenge;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ActivityDefine;
use Game\Constant\ClientErrorCode;
use Game\Logic\Activity\MapChallengeLogic;
use Game\Protobuf\CGMapChallengeInfo;
use Game\Protobuf\GCMapChallengeInfo;
use Game\Protobuf\PacketId;

class CG_MapChallengeInfo extends ControllerBase
{
    use MapChallengeLogic;

    private GCMapChallengeInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGMapChallengeInfo();
        $this->sendMessage = new GCMapChallengeInfo();
    }

    public function run(): int
    {
        //检查活动是否开启
        $status = $this->getMapChallengeStatus();
        if ($status == ActivityDefine::ACTIVITY_STATUS_UNOPENED) {
            return $this->sendFailMessage(ClientErrorCode::MAP_CHALLENGE_NOT_OPEN);
        }
        if ($status == ActivityDefine::ACTIVITY_STATUS_CLOSE) {
            return $this->sendFailMessage(ClientErrorCode::MAP_CHALLENGE_CLOSED);
        }
        //活动已开启,返回活动信息
        [$activityId, $mapList, $rewardStatus] = $this->getMapChallengeInfo();
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setActivityId($activityId);
        $this->sendMessage->setMapInfo($mapList);
        $this->sendMessage->setActivityRewardStatus($rewardStatus);
        SendMessage::getInstance()->sendClient(PacketId::GC_MapChallengeInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }

    private function sendFailMessage(int $code): int
    {
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_MapChallengeInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
