<?php

/**
 * 地图挑战赛关卡结算
 */

namespace Game\Controller\Activity\MapChallenge;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateCompetitionMode;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\AccountLogic;
use Game\Logic\Activity\MapChallengeLogic;
use Game\Logic\Pvp\PvpSettlementLogic;
use Game\Method\Player\AddPlayerExp;
use Game\Protobuf\CGFinishMapChallenge;
use Game\Protobuf\GCFinishMapChallenge;
use Game\Protobuf\PacketId;

class CG_FinishMapChallenge extends ControllerBase
{
    use MapChallengeLogic;
    use AccountLogic;
    use AddPlayerExp;
    use PvpSettlementLogic;

    private GCFinishMapChallenge $sendMessage;

    public function __construct()
    {
        $this->message = new CGFinishMapChallenge();
        $this->sendMessage = new GCFinishMapChallenge();
    }

    public function run(): int
    {
        $code = $this->checkMapChallengeCanEnter($this->message->getMapId());
        //比赛结束,更新玩家状态
        $this->upRoleStatus(GameConstantDefine::PLAYER_STATUS_ONLINE, $this->playerId);
        $this->sendMessage->setCode($code);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            SendMessage::getInstance()->sendClient(PacketId::GC_FinishMapChallenge, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //获取配置
        $this->constConfigData = $this->getTable(TemplateDefine::TYPE_CONST);
        // 增加经验
        $exp = $this->getAccountLvExp(true, GameConstantDefine::MATCH_MODE_MPA_CHALLENGE);
        $this->addPlayerExp($exp, GameConstantDefine::MATCH_MODE_MPA_CHALLENGE);
        //结算
        $this->sendMessage->setMapInfo(
            $this->mapChallengeSettlement(
                $this->message->getMapId(),
                $this->message->getPlayerList(),
                $this->message->getTarget(),
                $this->message->getMatchOperation()
            )
        );
        $this->sendMessage->setAddExp($exp);
        SendMessage::getInstance()->sendClient(PacketId::GC_FinishMapChallenge, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
