<?php

/**
 * 进入地图挑战赛场景
 */

namespace Game\Controller\Activity\MapChallenge;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\MapChallengeLogic;
use Game\Protobuf\CGEnterMapChallengeScene;
use Game\Protobuf\GCEnterMapChallengeScene;
use Game\Protobuf\PacketId;

class CG_EnterMapChallengeScene extends ControllerBase
{
    use MapChallengeLogic;

    private GCEnterMapChallengeScene $sendMessage;

    public function __construct()
    {
        $this->message = new CGEnterMapChallengeScene();
        $this->sendMessage = new GCEnterMapChallengeScene();
    }

    public function run(): int
    {
        $this->sendMessage->setCode($this->enterMapChallengeCheck($this->message->getMapId()));
        SendMessage::getInstance()->sendClient(PacketId::GC_EnterMapChallengeScene, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
