<?php

/**
 * 领取累签奖励
 */

namespace Game\Controller\Activity\LimitTime;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Game\Constant\ConstTemplate\TemplateTaskLogin;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\Activity\ActivityLogic;
use Game\Logic\ItemLogic;
use Game\Model\Activity\TaskExchangeLoginModel;
use Game\Protobuf\CGRewardTaskLogin;
use Game\Protobuf\GCRewardTaskLogin;
use Game\Protobuf\PacketId;

class RewardLogin extends ControllerBase
{
    use ActivityLogic;
    use TemplateHelp;
    use ItemLogic;

    private GCRewardTaskLogin $sendMessage;

    public function __construct()
    {
        $this->message = new CGRewardTaskLogin();
        $this->sendMessage = new GCRewardTaskLogin();
    }

    public function run(): int
    {
        $activeID = $this->message->getActiveID();
        $loginID = $this->message->getLoginID();
        $moduleID = $this->message->getModuleID();

        switch ($moduleID) {
            case 1:
                $exchange = $this->getTitle(TemplateDefine::TYPE_TASK_EXCHANGE, $activeID);
                break;
            case 2:
                $exchange = $this->getTitle(TemplateDefine::TYPE_TASK_TARGET, $activeID);
                break;
        }
        /**
         * @var TaskExchangeLoginModel $taskExchangeModel
         */
        $taskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_EXCHANGE_LOGIN);
        $taskExchangeModel->data->searchDB($activeID);
        $taskLogin = $this->getTitle(TemplateDefine::TYPE_TASK_LOGIN, $loginID);
        $time = Utils::getServerTimestamp();
        // 时间校验
        if($time < $exchange[TemplateTaskExchange::StartTime] || $time > $exchange[TemplateTaskExchange::EndTime]) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_ACTIVE_TIME_FAILED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_RewardTaskLogin, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        if($taskLogin[TemplateTaskLogin::Vitality] > count($taskExchangeModel->data->loginRecord)) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_NOT_LOGIN);
            SendMessage::getInstance()->sendClient(PacketId::GC_RewardTaskLogin, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        if(in_array($taskLogin[TemplateTaskLogin::Id], $taskExchangeModel->data->rewardRecord)) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_LOGIN_REWARD_REPEATED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_RewardTaskLogin, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        $taskExchangeModel->data->rewardRecord[] = $taskLogin[TemplateTaskLogin::Id];
        // 领取道具
        $this->gainItemArr($taskLogin[TemplateTaskLogin::Reward]);
        // 保存领取
        $taskExchangeModel->data->updateDB($activeID);

        $this->sendMessage->setModuleID($moduleID);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_RewardTaskLogin, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
