<?php

/**
 * 领取节日奖励
 */

namespace Game\Controller\Activity\LimitTime;

use Framework\Define\ErrorDefine;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateDailyReward;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\Activity\ActivityLogic;
use Game\Logic\ItemLogic;
use Game\Model\Activity\FestivalRewardModel;
use Game\Protobuf\CGRewardFestival;
use Game\Protobuf\GCGetFestivalRewardInfo;
use Game\Protobuf\PacketId;

class RewardFestival extends ControllerBase
{
    use ActivityLogic;
    use TemplateHelp;
    use ItemLogic;

    private GCGetFestivalRewardInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGRewardFestival();
        $this->sendMessage = new GCGetFestivalRewardInfo();
    }

    public function run(): int
    {
        $rewardID = $this->message->getRewardID();
        $activityID = $this->message->getRewardID();
        $reward = $this->getTitle(TemplateDefine::TYPE_DAILY_TASK_REWARD, $rewardID);
        // 道具是否够
        $haveNum = $this->getItemNumByTplID($reward[TemplateDailyReward::Item]);
        if($haveNum < $reward[TemplateDailyReward::Vitality]) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_SUB_ITEM_NUM_FAILED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetFestivalRewardInfo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        // 是否已经领取
        /**
         * @var FestivalRewardModel $festivalRewardModel
         */
        $festivalRewardModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FESTIVAL_REWARD);
        $festivalRewardModel->data->searchDB($reward[TemplateDailyReward::TaskType]);
        if(in_array($rewardID, $festivalRewardModel->data->rewardRecord)) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_REWARD_REPEATED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetFestivalRewardInfo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        // 发放奖励
        if(!$this->gainItemArr($reward[TemplateDailyReward::ItemReward])) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_REWARD_FAILED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_GetFestivalRewardInfo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        // 领取
        $festivalRewardModel->data->rewardRecord[] = $rewardID;
        $festivalRewardModel->data->updateDB($reward[TemplateDailyReward::TaskType]);

        $this->sendMessage->setID($festivalRewardModel->data->rewardRecord);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setActiveID($activityID);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetFestivalRewardInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
