<?php

/**
 * 获取节日领取记录
 */

namespace Game\Controller\Activity\LimitTime;

use Framework\Define\ErrorDefine;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateDailyReward;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\Activity\ActivityLogic;
use Game\Logic\ItemLogic;
use Game\Model\Activity\FestivalRewardModel;
use Game\Protobuf\CGGetFestivalRewardInfo;
use Game\Protobuf\GCGetFestivalRewardInfo;
use Game\Protobuf\PacketId;

class GetFestivalReward extends ControllerBase
{
    use ActivityLogic;
    use TemplateHelp;
    use ItemLogic;

    private GCGetFestivalRewardInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetFestivalRewardInfo();
        $this->sendMessage = new GCGetFestivalRewardInfo();
    }

    public function run(): int
    {
        $rewardID = $this->message->getRewardID();
        $activeID = $this->message->getActiveID();

        $reward = $this->getTitle(TemplateDefine::TYPE_DAILY_TASK_REWARD, $rewardID);
        /**
         * @var FestivalRewardModel $festivalRewardModel
         */
        $festivalRewardModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_FESTIVAL_REWARD);
        $festivalRewardModel->data->searchDB($reward[TemplateDailyReward::TaskType]);

        $this->sendMessage->setID($festivalRewardModel->data->rewardRecord);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setActiveID($activeID);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetFestivalRewardInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
