<?php

/**
 * 获取不同类型活动数据
 */

namespace Game\Controller\Activity\LimitTime;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\TaskData;
use Game\Model\Activity\TaskExchangeLoginModel;
use Game\Model\Shop\ShopTaskExchangeModel;
use Game\Protobuf\CGGetActivityLimitTimeInfo;
use Game\Protobuf\GCActivityLogin;
use Game\Protobuf\GCExchangeShop;
use Game\Protobuf\GCExchangeTask;
use Game\Protobuf\PacketId;
use Framework\Logic\TemplateHelp;
use Game\Protobuf\ShopItem;
use Game\Protobuf\Task;

class GetActivityInfo extends ControllerBase
{
    use TemplateHelp;

    private GCExchangeShop $sendShopMessage;
    private GCActivityLogin $sendLoginMessage;
    private GCExchangeTask $sendTaskMessage;

    public function __construct()
    {
        $this->message = new CGGetActivityLimitTimeInfo();
        $this->sendShopMessage = new GCExchangeShop();
        $this->sendLoginMessage = new GCActivityLogin();
        $this->sendTaskMessage = new GCExchangeTask();
    }

    public function run(): int
    {
        $activeID = $this->message->getActiveID();
        $moduleID = $this->message->getModuleID();
        switch ($moduleID) {
            case 1:
                $taskExchangeCfg = $this->getTitle(TemplateDefine::TYPE_TASK_EXCHANGE, $activeID);
                break;
            case 2:
                $taskExchangeCfg = $this->getTitle(TemplateDefine::TYPE_TASK_TARGET, $activeID);
                break;
            case 3:
                $taskExchangeCfg = $this->getTitle(TemplateDefine::TYPE_TASK_FESTIVAL, $activeID);
                break;
        }

        if(is_null($taskExchangeCfg)) {
            LogMark::getInstance()->markError(GameErrorCode::DATA_SEARCH_ERROR, 'get activity task 
            info cfg error!');
        }
        switch($taskExchangeCfg[TemplateTaskExchange::TaskType]) {
            case TemplateTaskExchange::TASK_TYPE_SHOP:
                $this->sendShopMsg($activeID, $moduleID);
                break;
            case TemplateTaskExchange::TASK_TYPE_LOGIN_NUM:
                $this->sendLoginMsg($activeID, $moduleID);
                break;
            default:
                $this->sendTaskMsg($activeID, $taskExchangeCfg[TemplateTaskExchange::TaskId], $moduleID);
                break;
        }
        return ErrorDefine::SUCCESS;
    }

    public function sendShopMsg($activeID, $module) {
        /**
         * @var ShopTaskExchangeModel $shopTaskExchangeModel
         */
        $shopTaskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_TASK_EXCHANGE);
        $items = $shopTaskExchangeModel->getShopItem($activeID);
        $sendItem = [];
        foreach ($items as $id => $num) {
            $item = new ShopItem();
            $item->setId($id);
            $item->setBuyNum($num);
            $sendItem[] = $item;
        }
        $this->sendShopMessage->setModuleID($module);
        $this->sendShopMessage->setItem($sendItem);
        $this->sendShopMessage->setActiveID($activeID);
        SendMessage::getInstance()->sendClient(PacketId::GC_ExchangeShop, $this->sendShopMessage);
    }

    public function sendLoginMsg($activeID, $module) {
        /**
         * @var TaskExchangeLoginModel $taskExchangeModel
         */
        $taskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_EXCHANGE_LOGIN);
        $taskExchangeModel->data->searchDB($activeID);
        $this->sendLoginMessage->setLogin($taskExchangeModel->data->loginRecord);
        $this->sendLoginMessage->setRewardRecord($taskExchangeModel->data->rewardRecord);
        $this->sendLoginMessage->setModuleID($module);
        $this->sendLoginMessage->setActiveID($activeID);
        SendMessage::getInstance()->sendClient(PacketId::GC_ActivityLogin, $this->sendLoginMessage);
    }

    public function sendTaskMsg($activeID, $tasks, $module) {
        /**
         * @var TaskExchangeLoginModel $taskExchangeModel
         */
        $taskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_EXCHANGE_LOGIN);
        $taskExchangeModel->setPlayerId($this->playerId);
        $taskList = [];
        [$taskArr, $completeTasks] = $taskExchangeModel->getExchangeTask($tasks);
        /**
         * @var TaskData $task
         */
        foreach ($taskArr as $task) {
            $taskMsg = new Task();
            $taskMsg->setStatus($task->status);
            $taskMsg->setSchedule($task->schedule);
            $taskMsg->setTaskId($task->taskId);
            $taskList[] = $taskMsg;
        }
        $this->sendTaskMessage->setTaskList($taskList);
        $this->sendTaskMessage->setCompleteTaskList($completeTasks);
        $this->sendTaskMessage->setActiveID($activeID);
        $this->sendTaskMessage->setModuleID($module);
        SendMessage::getInstance()->sendClient(PacketId::GC_ExchangeTask, $this->sendTaskMessage);
    }
}
