<?php

/**
 * 购买兑换商城道具
 */

namespace Game\Controller\Activity\LimitTime;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateShopExchange;
use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\Activity\ActivityLogic;
use Game\Logic\ItemLogic;
use Game\Logic\MoneyLogic;
use Game\Model\Shop\ShopTaskExchangeModel;
use Game\Protobuf\CGBuyExchangeShop;
use Game\Protobuf\GCBuyExchangeShop;
use Game\Protobuf\PacketId;

class BuyExchangeShop extends ControllerBase
{
    use ActivityLogic;
    use TemplateHelp;
    use MoneyLogic;
    use ItemLogic;

    private GCBuyExchangeShop $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyExchangeShop();
        $this->sendMessage = new GCBuyExchangeShop();
    }

    public function run(): int
    {
        $activeID = $this->message->getActiveID();
        $shopID = $this->message->getShopID();
        $num = $this->message->getNum();
        $sex = $this->message->getSex();

        $shopCfg = $this->getTitle(TemplateDefine::TYPE_SHOP_EXCHANGE, $shopID);

        // 兑换活动是否开启
        $exchange = $this->getTitle(TemplateDefine::TYPE_TASK_EXCHANGE, $activeID);
        $time = Utils::getServerTimestamp();
        if($time < $exchange[TemplateTaskExchange::StartTime] || $time > $exchange[TemplateTaskExchange::EndTime]) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_ACTIVE_TIME_FAILED_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_BuyExchangeShop, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        // 判断是否限购 或者超出上限
        $exchange = $shopCfg[TemplateShopExchange::Exchange];
        /**
         * @var ShopTaskExchangeModel $shopTaskExchangeModel
         */
        $shopTaskExchangeModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_TASK_EXCHANGE);
        $items = $shopTaskExchangeModel->getShopItem($activeID);
        $haveNum = 0;
        if($exchange != 0) {
            $haveNum = 0;
            foreach ($items as $id => $n) {
                if($id === $shopID) {
                    $haveNum = $n;
                    break;
                }
            }
            $haveNum += $num;
            if($haveNum > $exchange) {
                $this->sendMessage->setCode(ClientErrorCode::TASK_ACTIVE_EXCHANGE_OUT);
                SendMessage::getInstance()->sendClient(PacketId::GC_BuyExchangeShop, $this->sendMessage);
                return ErrorDefine::SUCCESS;
            }
        }

        // 扣除道具是否足够
        $moneyNum = $this->getItemNumByTplID($shopCfg[TemplateShopExchange::Item]);
        if($moneyNum < $shopCfg[TemplateShopExchange::ItemNum]) {
            $this->sendMessage->setCode(ClientErrorCode::TASK_MONEY_IS_FAILED);
            SendMessage::getInstance()->sendClient(PacketId::GC_BuyExchangeShop, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        $this->subItemByTID($shopCfg[TemplateShopExchange::Item], $shopCfg[TemplateShopExchange::ItemNum]);
        // 获得道具

        switch ($shopCfg[TemplateShopExchange::ItemType]) {
            // 普通
            case 0:
                $this->gainItem($shopCfg[TemplateShopExchange::RewardItem][0],
                    $shopCfg[TemplateShopExchange::RewardItemNum]);
                break;
            // 衣服
            case 1:
                if($sex === 0) {
                    $this->gainItem($shopCfg[TemplateShopExchange::RewardItem][1],
                        $shopCfg[TemplateShopExchange::RewardItemNum]);
                }
                $this->gainItem($shopCfg[TemplateShopExchange::RewardItem][0],
                    $shopCfg[TemplateShopExchange::RewardItemNum]);
                break;
        }

        $data = [$shopID => $haveNum];
        // 保存购买
        $shopTaskExchangeModel->updateBuyNum($activeID, $data);

        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyExchangeShop, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
