<?php

/**
 * 获取全部活动信息
 */

namespace Game\Controller\Activity;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Activity\ActivityLogic;
use Game\Protobuf\CGGetActivityInfo;
use Game\Protobuf\GCGetActivityInfo;
use Game\Protobuf\PacketId;

class CG_GetActivityInfo extends ControllerBase
{
    use ActivityLogic;

    private GCGetActivityInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetActivityInfo();
        $this->sendMessage = new GCGetActivityInfo();
    }

    public function run(): int
    {
        $this->sendMessage->setInfo($this->getAllActivityInfo());
        SendMessage::getInstance()->sendClient(PacketId::GC_GetActivityInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
