<?php

namespace Game\Controller\Account;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Logic\AccountLogic;
use Game\Logic\CarLogic;
use Game\Logic\Friend\FriendRandomLogic;
use Game\Logic\ItemLogic;
use Game\Method\Player\InitPlayerDataLogic;
use Game\Model\ItemModel;
use Game\Model\Task\Manager\BranchTaskManager;
use Game\Protobuf\CGSelectCar;
use Game\Protobuf\GCSelectCar;
use Game\Protobuf\PacketId;
use Game\Logic\RankLogic;
use Game\Data\AccountData;

class SelectCar extends ControllerBase
{
    use CarLogic;
    use RankLogic;
    use AccountLogic;
    use FriendRandomLogic;
    use ItemLogic;
    use InitPlayerDataLogic;

    public GCSelectCar $sendMessage;

    public function __construct()
    {
        $this->message = new CGSelectCar();
        $this->sendMessage = new GCSelectCar();
    }

    public function run(): int
    {
        $carId = $this->message->getCarTplID();
        $step = $this->message->getStep();
        $itemID = $this->message->getItemID();
        $roleModel = $this->getAccountAttribute(AccountData::DB_ROLE_MODEL_ID);
        if ($roleModel == 0) {
            LogMark::getInstance()->markError(
                GameErrorCode::SEARCH_ROLE_ERROR,
                "[SelectCar] search roleModel id is 0"
            );
            $this->sendMsg(ClientErrorCode::ACCOUNT_SELECT_CAR_ERROR);
            return ErrorDefine::SUCCESS;
        }
        /**
         * @var BranchTaskManager $branchTaskManager
         */
        $branchTaskManager = ModelManager::getInstance()->getModel(ModelTypeDefine::TASK_BRANCH);
        $branchTaskManager->setIsRegister();
        $carUid = $this->createSystemCar($carId, $itemID);
        if ($carUid == false) {
            $this->sendMsg(ClientErrorCode::ACCOUNT_SELECT_CAR_ERROR);
            return ErrorDefine::SUCCESS;
        }
        $data = [
            AccountData::DB_STEP => $step,
            AccountData::DB_DEFAULT_CAR => $carUid,
            AccountData::DB_DEFAULT_CAT_TPL => $carId
        ];

        if (!$this->saveAccountData($data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::UPDATE_ROLE_ERROR,
                '[SelectCar] update account data error!');
            $this->sendMsg(ClientErrorCode::ACCOUNT_SELECT_CAR_ERROR);
            return ErrorDefine::SUCCESS;
        }
        $this->sendMsg(ClientErrorCode::CLIENT_SUCCESS);
        // 选车车辆排行榜更新
        $this->addCarRefitRank(0, $itemID, TemplateItem::TYPE_CAR);
        // 注册角色完成 初始化信息--初始任务
        $this->initPlayerData3($this->playerId);
        //更新好友分
        $this->updateRandomScore();
        // 发送货币 衣服 车
        /**
         * @var ItemModel $itemModel
         */
        $itemModel = ModelManager::getInstance()->getModel(ModelTypeDefine::ITEM);
        $itemModel->initPlayerItemData($roleModel);

        return ErrorDefine::SUCCESS;
    }

    private function sendMsg(int $code)
    {
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_SelectCar, $this->sendMessage);
    }
}