<?php
namespace Game\Controller\Account;
use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\GameErrorCode;
use Game\Logic\AccountLogic;
use Game\Protobuf\CGSearchStep;
use Game\Protobuf\GCSearchStep;
use Game\Protobuf\PacketId;

class SearchStep extends ControllerBase
{
    use AccountLogic;
    private GCSearchStep $sendMsg;
    public function __construct()
    {
        $this->message = new CGSearchStep();
        $this->sendMsg = new GCSearchStep();
    }

    public function run(): int
    {
        $step = $this->getStep();
        $modelID = $this->getModelID();
        $this->sendMsg->setStep($step);
        $this->sendMsg->setModelID($modelID);
        SendMessage::getInstance()->sendClient(PacketId::GC_SearchStep, $this->sendMsg);
        return ErrorDefine::SUCCESS;
    }
}