<?php

namespace Game\Controller\Account;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Data\AccountData;
use Game\Logic\AccountLogic;
use Game\Logic\ShieldWordsLogic;
use Game\Method\Player\InitPlayerDataLogic;
use Game\Operation\EventLog\EventLog_Manager;
use Game\Operation\EventLog\EventLogType;
use Game\Protobuf\CGInputName;
use Game\Protobuf\GCInputName;
use Game\Protobuf\PacketId;

class InputName extends ControllerBase
{
    use AccountLogic;
    use ShieldWordsLogic;
    use InitPlayerDataLogic;

    private GCInputName $sendMessage;

    public function __construct()
    {
        $this->message = new CGInputName();
        $this->sendMessage = new GCInputName();
    }

    public function run(): int
    {
        $step = $this->message->getStep();
        $nickName = $this->message->getNickName();

        //检查敏感词
        if ($this->checkFuckWord($nickName)) {
            $this->sendMessage->setCode(ClientErrorCode::NICKNAME_HAS_SHIELD_WORD);
            $this->sendMessage->setNickName($nickName);
            SendMessage::getInstance()->sendClient(PacketId::GC_InputName, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //检查昵称长度
        $code = $this->checkNicknameLen($nickName);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setCode($code);
            $this->sendMessage->setNickName($nickName);
            SendMessage::getInstance()->sendClient(PacketId::GC_InputName, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //检查是否已有名字
        $playerInfo = $this->searchPlayerInfo($this->playerId);
        if (strlen($playerInfo[AccountData::DB_NICK_NAME]) != 0) {
            $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
            $this->sendMessage->setNickName($playerInfo[AccountData::DB_NICK_NAME]);
            SendMessage::getInstance()->sendClient(PacketId::GC_InputName, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //检测RoleName是否可用
        if (!$this->checkRoleName($nickName)) {
            $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
            $this->sendMessage->setNickName($nickName);
            SendMessage::getInstance()->sendClient(PacketId::GC_InputName, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        if (!$this->saveAccountName($step, $nickName)) {
            LogMark::getInstance()->markError(
                GameErrorCode::CREATE_ROLE_ERROR,
                '[InputName] save name error!');
            $this->sendMessage->setCode(ClientErrorCode::ACCOUNT_CREATE_NAME_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_CreateAccount, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        EventLog_Manager::getInstance()->updateUserAttr(array(EventLogType::LOG_KEY_ROLE_NAME => $nickName));
        // 注册角色完成 初始化信息
        $this->initPlayerData2($this->playerId);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setNickName($nickName);
        SendMessage::getInstance()->sendClient(PacketId::GC_CreateAccount, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}

