<?php

namespace Game\Controller\Account;


use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameErrorCode;
use Game\Logic\AccountLogic;
use Game\Method\Player\InitPlayerDataLogic;
use Game\Protobuf\CGCreateAccount;
use Game\Protobuf\GCCreateAccount;
use Game\Protobuf\PacketId;

class CreateData extends ControllerBase
{
    use AccountLogic;
    use InitPlayerDataLogic;

    private GCCreateAccount $sendMessage;

    public function __construct()
    {
        $this->message = new CGCreateAccount();
        $this->sendMessage = new GCCreateAccount();
    }

    public function run(): int
    {
        $step = $this->message->getStep();
        $modelID = $this->message->getModelID();

        if ($this->getStep() != 0) {
            //步骤错误
            $this->sendMessage->setCode(ClientErrorCode::ACCOUNT_CREATE_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_CreateAccount, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        if (!$this->saveAccountModel($step, $modelID)) {
            LogMark::getInstance()->markError(GameErrorCode::CREATE_ROLE_ERROR,
                                              '[CreateData] select role model error!');
            $this->sendMessage->setCode(ClientErrorCode::ACCOUNT_CREATE_ERROR);
            SendMessage::getInstance()->sendClient(PacketId::GC_CreateAccount, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        // 注册角色完成 初始化信息
        $this->initPlayerData1($this->playerId);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_CreateAccount, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}