<?php

namespace Game\Constant;

use Framework\Log\LogMark;
use Tool\MakeLocustRequestFile\Config\Config;

class TestParams
{
    // desc
    // 消息号 packet id
    // 记录 playerID
    // 内存使用信息
    // 操作数据库次数 (查询和写入) RedisColony
    // 写日志的次数（磁盘io） error log
    // 整体开始时间 结束时间（单位 ms） 整体消耗时间
    // 其他参数（ 整体返回包大小 byte）

    public $LogPath = "testLog";
    public $LogExcel = "/data/log/game/testExcelLog/info-20230911.csv";



    public static $packetID = [];
    public static $playerID = 0;
    public static $dbRNum = 0;
    public static $dbWNum = 0;
    public static $logNum = 0;
    public static $startTime = 0;
    public static $endTime = 0;
    public static $packetSize = 0;
    public static $stack = [];

    function formatBytes($bytes, $precision = 2) {
        $units = array("b", "kb", "mb", "gb", "tb");

        $bytes = max($bytes, 0);
        $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
        $pow = min($pow, count($units) - 1);

        $bytes /= (1 << (10 * $pow));

        return round($bytes, $precision) . " " . $units[$pow];
    }

    public function getMemory() {
        $a = memory_get_peak_usage();
        $a = $this->formatBytes($a);

        $b = memory_get_peak_usage(true);
        $b = $this->formatBytes($b);

        $c = memory_get_usage();
        $c = $this->formatBytes($c);

        $d = memory_get_usage(true);
        $d = $this->formatBytes($d);

        error_log("peakMemory_f:".$a . "   peakMemory_t:".$b."   memory_f:".$c."    memory_t:".$d."\n");
    }

    public function writeLogInfo() {

        $a = memory_get_peak_usage();
        $af = $this->formatBytes($a);

        $b = memory_get_peak_usage(true);
        $bf = $this->formatBytes($b);

        $c = memory_get_usage();
        $cf = $this->formatBytes($c);

        $d = memory_get_usage(true);
        $df = $this->formatBytes($d);

        LogMark::getInstance()->init($this->LogPath);
        $data = [
            'playerID' => self::$playerID,
            'packetID' => self::$packetID,
            'peakF' => $af,
            'peakT' => $bf,
            'memoryF' => $cf,
            'memoryT' => $df,
            'dbRead' => self::$dbRNum,
            'dbWrite' => self::$dbWNum,
            'ioNum' => self::$logNum,
            'useTime' => round(self::$endTime - self::$startTime , 4) ,
            'packetSize' => $this->formatBytes(self::$packetSize),
        ];

        $csvData = [
            'playerID' => "id: ".self::$playerID,
            'packetID' => implode('|', self::$packetID),
            'peakF' => $a,
            'peakT' => $b,
            'memoryF' => $c,
            'memoryT' => $d,
            'dbRead' => self::$dbRNum,
            'dbWrite' => self::$dbWNum,
            'ioNum' => self::$logNum,
            'useTime' => round((self::$endTime - self::$startTime) * 1000 , 2) ,
            'packetSize' => self::$packetSize,
            'time' => date('Y-m-d H:i:s'),
            'stack' => json_encode(self::$stack),
        ];

//        LogMark::getInstance()->markInfo(
//            self::$playerID,
//            $data
//        );
//        playerID , packetID, pf , pt , mf , mt , dbr, dbw, ion, ut, ps

        file_put_contents($this->LogExcel, implode(",", $csvData).PHP_EOL, FILE_APPEND);

    }
}
