<?php

namespace Game\Constant;

class TaskLogicDefine
{
    //任务条件类型
    public const TASK_CONDITION_SIDE_TASK_MAIN = 30000;     //支线任务主任务
    public const TASK_CONDITION_WORLD_CHAT = 70000;     //世界频道聊天
    public const TASK_CONDITION_FRIEND_LIKE = 70001;    //好友列表点赞
    public const TASK_CONDITION_MATCH_LIKE = 70002;    //对局结束点赞
    public const TASK_CONDITION_COUNT_LIKE = 70003;    //总计点赞
    public const TASK_CONDITION_MATCH_INTIMACY_FRIEND_LIKE = 70104; //比赛后,亲密好友点赞
    public const TASK_CONDITION_FRIEND_SEND_GIFT = 70004;   //好友送礼
    public const TASK_CONDITION_MATCH_SEND_GIFT = 70005;   //对局送礼
    public const TASK_CONDITION_COUNT_SEND_GIFT = 70006;   //总计送礼
    public const TASK_CONDITION_FRIEND_NUM = 70007;     //好友数量
    public const TASK_CONDITION_SHARE_NUM = 70009;      //分享次数
    public const TASK_CONDITION_EVERYDAY_ONLINE_TIME = 70010;    //每日在线时长
    public const TASK_CONDITION_DAY_ONLINE_TIME = 70012;    //每日在线天数任务(任务条件70012),在线时间
    public const TASK_CONDITION_CAR_GARDE = 70070;      //车辆升级到指定等级
    public const TASK_CONDITION_CAR_UPGRADE_NUM = 70041;    //车辆升级次数,次数从接到后开始累计
    public const TASK_CONDITION_CAR_REFIT = 70071;      //车辆改造,初始检查已改造次数
    public const TASK_CONDITION_CAR_REFIT2 = 70042;     //车辆改造,从接任务开始计数
    public const TASK_CONDITION_CAR_EXTERIOR_REFIT = 70072; //车辆外观改造
    public const TASK_CONDITION_LOGIN_DAY = 70073;      //登录天数
    public const TASK_CONDITION_CONTINUE_LOGIN_DAY = 70074; //连续登录天数
    public const TASK_CONDITION_COMP_TASK_NUM = 70011;      //完成任务类型次数
    public const TASK_CONDITION_SHOP_BUY_ITEM = 70083;      //商城购买道具
    public const TASK_CONDITION_TOTAL_PROFICIENCY = 70084;      //总熟练度等级
    public const TASK_CONDITION_CAR_PROFICIENCY = 70085;      //车熟练度等级
    public const TASK_CONDITION_CAREER_LEVEL_STAR = 70100;    //完成生涯指定关卡获得星数
    public const TASK_CONDITION_COMPLETE_LICENSE_LEVEL = 70101; //完成指定驾照关卡
    public const TASK_CONDITION_PAI_WEI_LEVEL = 70102;  //排位赛达到指定段位
    public const TASK_CONDITION_PLAYER_LEVEL = 70105;  //角色达到指定等级
    public const TASK_CONDITION_COST_MONEY = 70106;     //消耗货币
    public const TASK_CONDITION_SUPPLY = 70108;     //领取补给(每日登陆和周末登陆)
    public const TASK_CONDITION_DRIVING_LICENSE_LEVEL = 70126;  //获取驾照等级

    // pvp比赛类任务条件类型
    public const TASK_CONDITION_MATCH_INVITATION_FRIEND = 70008;    //邀请好友完成比赛
    public const TASK_CONDITION_MATCH_COMPLETE_WITH_TYPE_MAP = 70013;   //指定地图进行指定模式对局冲过终点的次数
    public const TASK_CONDITION_MATCH_JOIN_WITH_TYPE_MAP = 70017;   //指定地图指定模式进行比赛的次数
    public const TASK_CONDITION_MATCH_JOIN_WITH_TYPE_REALTIME = 70018;  //指定模式指定时间(真实时间)完成比赛的次数
    public const TASK_CONDITION_MATCH_COMPLETE_TIME_WITH_TYPE_MAP = 70020;  //指定地图指定模式冲线时间
    public const TASK_CONDITION_MATCH_COMPLETE_TIME = 70021;        //指定完成时间
    public const TASK_CONDITION_MATCH_SPRAY_1_NUM = 70023;          //小喷次数
    public const TASK_CONDITION_MATCH_SPRAY_2_NUM = 70027;          //双喷次数
    public const TASK_CONDITION_MATCH_N2_NUM = 70031;               //氮气次数
    public const TASK_CONDITION_MATCH_DRIFT_NUM = 70035;            //漂移次数
    public const TASK_CONDITION_MATCH_OVER_TAKE_NUM = 70039;        //超车次数
    public const TASK_CONDITION_MATCH_SKILL_NUM = 70043;            //技能次数
    public const TASK_CONDITION_MATCH_JAM_SKILL_NUM = 70047;        //干扰技能次数
    public const TASK_CONDITION_MATCH_HELP_SKILL_NUM = 70051;       //辅助技能次数
    public const TASK_CONDITION_MATCH_DRIFT_RANGE = 70055;          //漂移距离
    public const TASK_CONDITION_MATCH_DRIVING_RANGE = 70059;        //行驶距离
    public const TASK_CONDITION_MATCH_RANK_TOP_3 = 70064;           //前三名次数
    public const TASK_CONDITION_MATCH_RANK_TOP_1 = 70068;           //第一次数
    public const TASK_CONDITION_MATCH_PAI_WEI_SCORE = 70061;        //获得排位分数
    public const TASK_CONDITION_MATCH_WITH_FRIEND = 70091;          //与有亲密关系的好友共同游戏
    public const TASK_CONDITION_MATCH_MVP = 70089;      // 获得一次mvp
    public const TASK_CONDITION_MATCH_ICON = 70107;     //获得徽章(称号)
    public const TASK_CONDITION_MATCH_PVP_DRIFT_1_NUM = 70109;      //刹车漂移次数
    public const TASK_CONDITION_MATCH_PVP_DRIFT_1_RANGE = 70110;      //刹车漂移距离
    public const TASK_CONDITION_MATCH_PVP_DRIFT_2_NUM = 70111;      //直线漂移次数
    public const TASK_CONDITION_MATCH_PVP_DRIFT_2_RANGE = 70112;      //直线漂移距离
    public const TASK_CONDITION_MATCH_PVP_DRIFT_3_NUM = 70113;      //惯性漂移次数
    public const TASK_CONDITION_MATCH_PVP_DRIFT_3_RANGE = 70114;      //惯性漂移距离
    public const TASK_CONDITION_MATCH_PVP_QUICK_CURVE_NUM = 70115;    //快速出弯次数
    public const TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_NUM = 70116;         //叠喷次数
    public const TASK_CONDITION_MATCH_PVP_DRIFT_DOUBLE_SPRAY_NUM = 70117;         //小飘双喷次数
    public const TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_NUM = 70118;         //进阶叠喷次数
    public const TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_LAST_NUM = 70119;         //叠喷延续次数
    public const TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_LAST_NUM = 70120;         //进阶叠喷延续次数
    public const TASK_CONDITION_MATCH_PVP_RESET_NUM = 70121;         //被动重置次数
    public const TASK_CONDITION_MATCH_PVP_HIT_NUM = 70122;      //碰撞次数
    public const TASK_CONDITION_MATCH_PVP_DRIFT_4_NUM = 70123;      //反向漂移次数

    // 比赛 包含pvp和pve
    public const TASK_CONDITION_MATCH_COMPLETE_NUM = 70014;         //完成比赛次数(冲过终点)
    public const TASK_CONDITION_MATCH_WIN_NUM = 70015;              //指定模式地图胜利次数(个人赛胜利为前3名,团队赛胜利为队伍胜利)
    public const TASK_CONDITION_MATCH_SPRAY_1_NUM_COMMON = 70024;           //小喷次数
    public const TASK_CONDITION_MATCH_SPRAY_2_NUM_COMMON = 70028;           //双喷次数
    public const TASK_CONDITION_MATCH_N2_NUM_COMMON = 70032;                //氮气次数
    public const TASK_CONDITION_MATCH_DRIFT_NUM_COMMON = 70036;             //漂移次数
    public const TASK_CONDITION_MATCH_OVER_TAKE_NUM_COMMON = 70040;         //超车次数
    public const TASK_CONDITION_MATCH_SKILL_NUM_COMMON = 70044;             //技能次数
    public const TASK_CONDITION_MATCH_JAM_SKILL_NUM_COMMON = 70048;         //干扰技能次数
    public const TASK_CONDITION_MATCH_HELP_SKILL_NUM_COMMON = 70052;        //辅助技能次数
    public const TASK_CONDITION_MATCH_DRIFT_RANGE_COMMON = 70056;           //漂移距离
    public const TASK_CONDITION_MATCH_DRIVING_RANGE_COMMON = 70060;         //行驶距离
    public const TASK_CONDITION_MATCH_RANK_TOP_3_COMMON = 70065;            //前三名次数
    public const TASK_CONDITION_MATCH_RANK_TOP_2_COMMON = 70086;            //前两名次数
    public const TASK_CONDITION_MATCH_RANK_TOP_1_COMMON = 70069;            //第一次数
    // pve
    public const TASK_CONDITION_MATCH_DRIFT_1_NUM = 70075;      //刹车漂移次数
    public const TASK_CONDITION_MATCH_DRIFT_1_RANGE = 70076;      //刹车漂移距离
    public const TASK_CONDITION_MATCH_DRIFT_2_NUM = 70077;      //直线漂移次数
    public const TASK_CONDITION_MATCH_DRIFT_2_RANGE = 70078;      //直线漂移距离
    public const TASK_CONDITION_MATCH_DRIFT_3_NUM = 70079;      //惯性漂移次数
    public const TASK_CONDITION_MATCH_DRIFT_3_RANGE = 70080;      //惯性漂移距离
    public const TASK_CONDITION_MATCH_QUICK_CURVE_NUM = 70081;    //快速出弯次数
    public const TASK_CONDITION_MATCH_AI_RANGE = 70082;         //与指定AI距离,正数为超过AI,负数为落后AI
    public const TASK_CONDITION_MATCH_LAST_TIME = 70087;         //比赛剩余时间,限计时赛和追逐赛
    public const TASK_CONDITION_MATCH_DOUBLE_SPRAY_NUM = 70092;         //叠喷次数
    public const TASK_CONDITION_MATCH_DRIFT_DOUBLE_SPRAY_NUM = 70093;         //小飘双喷次数
    public const TASK_CONDITION_MATCH_ADVANCE_DOUBLE_SPRAY_NUM = 70094;         //进阶叠喷次数
    public const TASK_CONDITION_MATCH_DOUBLE_SPRAY_LAST_NUM = 70095;         //叠喷延续次数
    public const TASK_CONDITION_MATCH_ADVANCE_DOUBLE_SPRAY_LAST_NUM = 70096;         //进阶叠喷延续次数
    public const TASK_CONDITION_MATCH_RESET_NUM = 70097;         //被动重置次数
    public const TASK_CONDITION_MATCH_HIT_NUM = 70098;      //碰撞次数
    public const TASK_CONDITION_MATCH_DRIFT_4_NUM = 70099;      //反向漂移次数
    public const TASK_CONDITION_MATCH_AIR_JET_NUM = 70124;      //空喷次数
    public const TASK_CONDITION_MATCH_GROUND_JET_NUM = 70125;   //落地喷次数

    //观看教学视频
    public const TASK_CONDITION_WATCH_VIDEO = 70103;

    public const TASK_CONDITION_WEEK_LOGIN = 70088; // 周任务登录

    public const TASK_CONDITION_DAY_LOGIN = 70090; // 当天登录

    //任务条件对应事件id
    public const TaskCondition2EventId = array(
        // 支线任务主任务
        self::TASK_CONDITION_SIDE_TASK_MAIN => EventTypeDefine::EVENT_TYPE_TASK_BRANCH_MAIN,
        // 任务
        self::TASK_CONDITION_WORLD_CHAT => EventTypeDefine::EVENT_TYPE_TASK_WORD_CHAT,
        self::TASK_CONDITION_FRIEND_LIKE => EventTypeDefine::EVENT_TYPE_TASK_GIVE_LIKE,
        self::TASK_CONDITION_MATCH_LIKE => EventTypeDefine::EVENT_TYPE_TASK_GIVE_LIKE,
        self::TASK_CONDITION_COUNT_LIKE => EventTypeDefine::EVENT_TYPE_TASK_GIVE_LIKE,
        self::TASK_CONDITION_MATCH_INTIMACY_FRIEND_LIKE => EventTypeDefine::EVENT_TYPE_TASK_GIVE_LIKE,
        self::TASK_CONDITION_FRIEND_SEND_GIFT => EventTypeDefine::EVENT_TYPE_TASK_SEND_GIFT,
        self::TASK_CONDITION_MATCH_SEND_GIFT => EventTypeDefine::EVENT_TYPE_TASK_SEND_GIFT,
        self::TASK_CONDITION_COUNT_SEND_GIFT => EventTypeDefine::EVENT_TYPE_TASK_SEND_GIFT,
        self::TASK_CONDITION_FRIEND_NUM => EventTypeDefine::EVENT_TYPE_TASK_ADD_FRIEND,
        self::TASK_CONDITION_MATCH_INVITATION_FRIEND => EventTypeDefine::EVENT_TYPE_TASK_INVITATION_FRIEND,
        self::TASK_CONDITION_SHARE_NUM => EventTypeDefine::EVENT_TYPE_TASK_SHARE,
        self::TASK_CONDITION_EVERYDAY_ONLINE_TIME => EventTypeDefine::EVENT_TYPE_TASK_ONLINE_TIME,
        self::TASK_CONDITION_DAY_ONLINE_TIME => EventTypeDefine::EVENT_TYPE_TASK_ONLINE_TIME,
        self::TASK_CONDITION_PLAYER_LEVEL => EventTypeDefine::EVENT_TYPE_TASK_PLAYER_LEVEL,
        self::TASK_CONDITION_COST_MONEY => EventTypeDefine::EVENT_TYPE_TASK_COST_MONEY,
        self::TASK_CONDITION_SUPPLY => EventTypeDefine::EVENT_TYPE_TASK_SUPPLY,
        self::TASK_CONDITION_DRIVING_LICENSE_LEVEL => EventTypeDefine::EVENT_TYPE_TASK_DRIVING_LICENSE_LEVEL,
        // 比赛相关
        self::TASK_CONDITION_MATCH_COMPLETE_WITH_TYPE_MAP => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_COMPLETE_NUM => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_JOIN_WITH_TYPE_MAP => EventTypeDefine::EVENT_TYPE_TASK_JOIN_MATCH,
        self::TASK_CONDITION_MATCH_JOIN_WITH_TYPE_REALTIME => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_COMPLETE_TIME_WITH_TYPE_MAP => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_COMPLETE_TIME => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_PAI_WEI_SCORE => EventTypeDefine::EVENT_TYPE_TASK_PAI_WEI_SCORE,
        self::TASK_CONDITION_PAI_WEI_LEVEL => EventTypeDefine::EVENT_TYPE_TASK_PAI_WEI_SCORE,
        self::TASK_CONDITION_MATCH_RANK_TOP_3 => EventTypeDefine::EVENT_TYPE_TASK_MATCH_RANK,
        self::TASK_CONDITION_MATCH_RANK_TOP_3_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_RANK,
        self::TASK_CONDITION_MATCH_RANK_TOP_2_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_RANK,
        self::TASK_CONDITION_MATCH_RANK_TOP_1 => EventTypeDefine::EVENT_TYPE_TASK_MATCH_RANK,
        self::TASK_CONDITION_MATCH_RANK_TOP_1_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_RANK,
        self::TASK_CONDITION_MATCH_WIN_NUM => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_WITH_FRIEND => EventTypeDefine::EVENT_TYPE_TASK_PLAY_WITH_FRIEND,
        self::TASK_CONDITION_CAREER_LEVEL_STAR => EventTypeDefine::EVENT_TYPE_TASK_CAREER_LEVEL_STAR,
        self::TASK_CONDITION_COMPLETE_LICENSE_LEVEL => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_PVE_LEVEL,
        self::TASK_CONDITION_MATCH_MVP => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        self::TASK_CONDITION_MATCH_ICON => EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH,
        // 比赛操作相关
        self::TASK_CONDITION_MATCH_SPRAY_1_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_SPRAY_1_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_SPRAY_2_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_SPRAY_2_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_N2_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_N2_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_DRIFT_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_DRIFT_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_OVER_TAKE_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_OVER_TAKE_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_SKILL_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_SKILL_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_JAM_SKILL_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_JAM_SKILL_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_HELP_SKILL_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_HELP_SKILL_NUM_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_DRIFT_RANGE => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_DRIFT_RANGE_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_DRIVING_RANGE => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_DRIVING_RANGE_COMMON => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_1_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_1_RANGE => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_2_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_2_RANGE => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_3_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_3_RANGE => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_QUICK_CURVE_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_DOUBLE_SPRAY_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_LAST_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_LAST_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_RESET_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_HIT_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_4_NUM => EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION,
        // 赛车相关
        self::TASK_CONDITION_CAR_GARDE => EventTypeDefine::EVENT_TYPE_TASK_CAR_GARDE,
        self::TASK_CONDITION_CAR_UPGRADE_NUM => EventTypeDefine::EVENT_TYPE_TASK_CAR_GARDE,
        self::TASK_CONDITION_CAR_REFIT => EventTypeDefine::EVENT_TYPE_TASK_CAR_REFIT,
        self::TASK_CONDITION_CAR_REFIT2 => EventTypeDefine::EVENT_TYPE_TASK_CAR_REFIT,
        self::TASK_CONDITION_CAR_EXTERIOR_REFIT => EventTypeDefine::EVENT_TYPE_TASK_CAR_EXTERIOR_REFIT,
        // 登录天数
        self::TASK_CONDITION_LOGIN_DAY => EventTypeDefine::EVENT_TYPE_TASK_LOGIN_DAY,
        self::TASK_CONDITION_CONTINUE_LOGIN_DAY => EventTypeDefine::EVENT_TYPE_TASK_LOGIN_DAY,
        //完成任务数
        self::TASK_CONDITION_COMP_TASK_NUM => EventTypeDefine::EVENT_TYPE_TASK_COMP_NUM,
        //商城购买道具
        self::TASK_CONDITION_SHOP_BUY_ITEM => EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM,
        //熟练度
        self::TASK_CONDITION_TOTAL_PROFICIENCY => EventTypeDefine::EVENT_TYPE_TASK_TOTAL_PROFICIENCY,
        self::TASK_CONDITION_CAR_PROFICIENCY => EventTypeDefine::EVENT_TYPE_TASK_CAR_PROFICIENCY,

        // 周任务
        self::TASK_CONDITION_WEEK_LOGIN => EventTypeDefine::EVENT_TYPE_TASK_WEEK_LOGIN,
        // 当天登录
        self::TASK_CONDITION_DAY_LOGIN => EventTypeDefine::EVENT_TYPE_TASK_DAY_LOGIN,

    );

    public function getEventId(int $conditionType): int
    {
        return self::TaskCondition2EventId[$conditionType] ?? 0;
    }

    //事件id对应任务处理逻辑
    public const EventId2TaskLogic = array(
        EventTypeDefine::EVENT_TYPE_TASK_WORD_CHAT => 'Game\Model\Task\Logic\TaskLogicCommon',  //通用型任务 每次触发增加进度,初始检查不依赖其他
        EventTypeDefine::EVENT_TYPE_TASK_GIVE_LIKE => 'Game\Model\Task\Logic\TaskLogicLike',    //点赞
        EventTypeDefine::EVENT_TYPE_TASK_SEND_GIFT => 'Game\Model\Task\Logic\TaskLogicSendGift',    //送礼
        EventTypeDefine::EVENT_TYPE_TASK_ADD_FRIEND => 'Game\Model\Task\Logic\TaskLogicFriendNum',
        EventTypeDefine::EVENT_TYPE_TASK_SHARE => 'Game\Model\Task\Logic\TaskLogicCommon',
        EventTypeDefine::EVENT_TYPE_TASK_CAR_GARDE => 'Game\Model\Task\Logic\TaskLogicCarGrade',    //赛车强化
        EventTypeDefine::EVENT_TYPE_TASK_CAR_REFIT => 'Game\Model\Task\Logic\TaskLogicCarRefit',    //赛车改造
        EventTypeDefine::EVENT_TYPE_TASK_CAR_EXTERIOR_REFIT => 'Game\Model\Task\Logic\TaskLogicCarRefit',    //赛车外观改造
        EventTypeDefine::EVENT_TYPE_TASK_BRANCH_MAIN => 'Game\Model\Task\Logic\TaskLogicBranchMain',    //支线任务主任务
        EventTypeDefine::EVENT_TYPE_TASK_INVITATION_FRIEND => 'Game\Model\Task\Logic\TaskLogicInvitedPlayer',
        EventTypeDefine::EVENT_TYPE_TASK_ONLINE_TIME => 'Game\Model\Task\Logic\TaskLogicOnlineTime',    //在线时间
        EventTypeDefine::EVENT_TYPE_TASK_JOIN_MATCH => 'Game\Model\Task\Logic\TaskLogicJoinMatch',     //参与比赛
        EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_MATCH => 'Game\Model\Task\Logic\TaskLogicCompleteMatch',  //完成比赛
        EventTypeDefine::EVENT_TYPE_TASK_MATCH_OPERATION => 'Game\Model\Task\Logic\TaskLogicMatchOperation',  //比赛内操作
        EventTypeDefine::EVENT_TYPE_TASK_MATCH_RANK => 'Game\Model\Task\Logic\TaskLogicMatchRank',  //比赛名次
        EventTypeDefine::EVENT_TYPE_TASK_PAI_WEI_SCORE => 'Game\Model\Task\Logic\TaskLogicPaiWei',  //排位赛积分
        EventTypeDefine::EVENT_TYPE_TASK_LOGIN_DAY => 'Game\Model\Task\Logic\TaskLogicLoginDay',            //登录天数
        EventTypeDefine::EVENT_TYPE_TASK_COMP_NUM => 'Game\Model\Task\Logic\TaskLogicCompTaskNum',
        EventTypeDefine::EVENT_TYPE_TASK_SHOP_BUY_ITEM => 'Game\Model\Task\Logic\TaskLogicBuyShopItem', //商城购买道具
        EventTypeDefine::EVENT_TYPE_TASK_TOTAL_PROFICIENCY => 'Game\Model\Task\Logic\TaskLogicTotalProficiency', //总熟练度
        EventTypeDefine::EVENT_TYPE_TASK_CAR_PROFICIENCY => 'Game\Model\Task\Logic\TaskLogicCarProficiency', //车熟练度
        EventTypeDefine::EVENT_TYPE_TASK_WEEK_LOGIN => 'Game\Model\Task\Logic\TaskLogicWeekLogin', // 周登录
        EventTypeDefine::EVENT_TYPE_TASK_DAY_LOGIN => 'Game\Model\Task\Logic\TaskLogicDayLogin', // 当天登录
        EventTypeDefine::EVENT_TYPE_TASK_PLAY_WITH_FRIEND => 'Game\Model\Task\Logic\TaskLogicPlayWithFriend',    //与好友共同游戏
        EventTypeDefine::EVENT_TYPE_TASK_CAREER_LEVEL_STAR => 'Game\Model\Task\Logic\TaskLogicCareerLevelStar', //生涯关卡星数
        EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_PVE_LEVEL => 'Game\Model\Task\Logic\TaskLogicCompletePveLevel', //生涯章节星数
        EventTypeDefine::EVENT_TYPE_TASK_PLAYER_LEVEL => 'Game\Model\Task\Logic\TaskLogicPlayerLevel', //玩家等级
        EventTypeDefine::EVENT_TYPE_TASK_COST_MONEY => 'Game\Model\Task\Logic\TaskLogicCostMoney', //消耗货币
        EventTypeDefine::EVENT_TYPE_TASK_SUPPLY => 'Game\Model\Task\Logic\TaskLogicCommon',
        EventTypeDefine::EVENT_TYPE_TASK_DRIVING_LICENSE_LEVEL =>'Game\Model\Task\Logic\TaskLogicDrivingLicenseLevel',
    );

    public function getTaskLogicName(int $eventId): string
    {
        if (!array_key_exists($eventId, self::EventId2TaskLogic)) {
            return "";
        }

        return self::EventId2TaskLogic[$eventId];
    }

    // 任务条件 比赛内操作
    public const taskConditionM2MatchOperation = array(
        self::TASK_CONDITION_MATCH_SPRAY_1_NUM => "getSpray1Num",    //小喷次数
        self::TASK_CONDITION_MATCH_SPRAY_1_NUM_COMMON => "getSpray1Num",    //小喷次数
        self::TASK_CONDITION_MATCH_SPRAY_2_NUM => "getSpray2Num",    //双喷次数
        self::TASK_CONDITION_MATCH_SPRAY_2_NUM_COMMON => "getSpray2Num",    //双喷次数
        self::TASK_CONDITION_MATCH_N2_NUM => "getN2Num",         //氮气次数
        self::TASK_CONDITION_MATCH_N2_NUM_COMMON => "getN2Num",         //氮气次数
        self::TASK_CONDITION_MATCH_DRIFT_NUM => "getDriftNum",         //漂移次数
        self::TASK_CONDITION_MATCH_DRIFT_NUM_COMMON => "getDriftNum",         //漂移次数
        self::TASK_CONDITION_MATCH_OVER_TAKE_NUM => "getOverTakeNum",         //超车次数
        self::TASK_CONDITION_MATCH_OVER_TAKE_NUM_COMMON => "getOverTakeNum",         //超车次数
        self::TASK_CONDITION_MATCH_SKILL_NUM => "getSkillNum",         //技能次数
        self::TASK_CONDITION_MATCH_SKILL_NUM_COMMON => "getSkillNum",         //技能次数
        self::TASK_CONDITION_MATCH_JAM_SKILL_NUM => "getJamSkillNum",      //干扰技能次数
        self::TASK_CONDITION_MATCH_JAM_SKILL_NUM_COMMON => "getJamSkillNum",      //干扰技能次数
        self::TASK_CONDITION_MATCH_HELP_SKILL_NUM => "getHelpSkillNum",      //辅助技能次数
        self::TASK_CONDITION_MATCH_HELP_SKILL_NUM_COMMON => "getHelpSkillNum",      //辅助技能次数
        self::TASK_CONDITION_MATCH_DRIFT_RANGE => "getDriftRange",         //漂移距离
        self::TASK_CONDITION_MATCH_DRIFT_RANGE_COMMON => "getDriftRange",         //漂移距离
        self::TASK_CONDITION_MATCH_DRIVING_RANGE => "getDrivingRange",         //行驶距离
        self::TASK_CONDITION_MATCH_DRIVING_RANGE_COMMON => "getDrivingRange",         //行驶距离
    );

    //多条件任务条件id,load表时使用
    public const MULTIPLE_CONDITIONS_TASK = array(
        self::TASK_CONDITION_MATCH_COMPLETE_WITH_TYPE_MAP,
        self::TASK_CONDITION_MATCH_WIN_NUM,
        self::TASK_CONDITION_MATCH_JOIN_WITH_TYPE_MAP,
        self::TASK_CONDITION_MATCH_JOIN_WITH_TYPE_REALTIME,
        self::TASK_CONDITION_MATCH_COMPLETE_TIME_WITH_TYPE_MAP,
        self::TASK_CONDITION_MATCH_SPRAY_1_NUM,
        self::TASK_CONDITION_MATCH_SPRAY_2_NUM,
        self::TASK_CONDITION_MATCH_N2_NUM,
        self::TASK_CONDITION_MATCH_DRIFT_NUM,
        self::TASK_CONDITION_MATCH_OVER_TAKE_NUM,
        self::TASK_CONDITION_MATCH_SKILL_NUM,
        self::TASK_CONDITION_MATCH_JAM_SKILL_NUM,
        self::TASK_CONDITION_MATCH_HELP_SKILL_NUM,
        self::TASK_CONDITION_MATCH_DRIFT_RANGE,
        self::TASK_CONDITION_MATCH_DRIVING_RANGE,
        self::TASK_CONDITION_MATCH_RANK_TOP_3,
        self::TASK_CONDITION_MATCH_RANK_TOP_1,
        self::TASK_CONDITION_CAR_REFIT,
        self::TASK_CONDITION_CAR_REFIT2,
        self::TASK_CONDITION_CAR_EXTERIOR_REFIT,
        self::TASK_CONDITION_MATCH_MVP,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_1_NUM,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_1_RANGE,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_2_NUM,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_2_RANGE,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_3_NUM,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_3_RANGE,
        self::TASK_CONDITION_MATCH_PVP_QUICK_CURVE_NUM,
        self::TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_NUM,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_DOUBLE_SPRAY_NUM,
        self::TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_NUM,
        self::TASK_CONDITION_MATCH_PVP_DOUBLE_SPRAY_LAST_NUM,
        self::TASK_CONDITION_MATCH_PVP_ADVANCE_DOUBLE_SPRAY_LAST_NUM,
        self::TASK_CONDITION_MATCH_PVP_RESET_NUM,
        self::TASK_CONDITION_MATCH_PVP_HIT_NUM,
        self::TASK_CONDITION_MATCH_PVP_DRIFT_4_NUM,
    );
}
