<?php

/**
 * 定义游戏网络消息号与控制器的映射关系
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Game\Constant;

use Framework\Define\IControllerDefine;
use Game\Protobuf\PacketId;

/**
 * 消息定义类
 */
class PacketDefineI implements IControllerDefine
{

    /**
     * packetId => controller namespace
     * @var array PACKET_MAP 消息号对应数组
     */
    public const PACKET_MAP = array(
        PacketId::CG_HeartBeat => 'Game\Controller\CGHeartBeatHandler',
        PacketId::Verify_Send => 'Game\Controller\CheckDataSign',
        PacketId::User_Login_Send => 'Game\Controller\Login\Login',
        PacketId::Use_Item_Send => 'Game\Controller\GameBag\UseItem',          // 道具使用
        PacketId::CG_UseHorn => 'Game\Controller\GameBag\CG_UseHorn',          // 道具大喇叭
        PacketId::Cloth_Save_Send => 'Game\Controller\GameBag\SaveDress',      // 服装保存
        PacketId::CG_ConvertExpireItem => 'Game\Controller\GameBag\CG_ConvertExpireItem',   //折算过期道具
        PacketId::CG_GetCloth => 'Game\Controller\GameBag\CG_GetCloth',   //获取当前服装
        PacketId::CG_PaiweiLevelInfo => 'Game\Controller\PaiweiLevelGet',
        PacketId::CG_UpdatePaiWeiPositionOrder => 'Game\Controller\CG_UpdatePaiWeiPositionOrder',
        PacketId::CG_PVPJoinMatching => 'Game\Controller\Pvp\JoinMatching',
        PacketId::CG_EnterScene => 'Game\Controller\Pvp\EnterScene',
        PacketId::CG_GameFinish => 'Game\Controller\Pvp\FinishPvp',
        PacketId::CG_PvpMatchOperation => 'Game\Controller\Pvp\CG_PvpMatchOperation',
        PacketId::CG_RecordBreakingInfo => 'Game\Controller\Pvp\CG_RecordBreakingInfo', //自己比赛破记录信息--冲线后立即发送
        PacketId::CG_GetPracticeRandMap => 'Game\Controller\Pvp\GetPracticeRandMap',  // 获取练习赛随机地图
        PacketId::CG_MailSearch => 'Game\Controller\Mail\CG_MailSearch',       //邮件获取
        PacketId::CG_MailOption => 'Game\Controller\Mail\CG_MailOption',       //邮件操作
        PacketId::CG_RefuseDemandZL => 'Game\Controller\Mail\RefuseDemandZL',  // 拒绝战令索要
        PacketId::CG_ReceiveZL => 'Game\Controller\Mail\ReceiveZL',  // 邮件领取战令
        PacketId::CG_Car_Up_Grade_Send => 'Game\Controller\Car\UpGrade',          // 赛车升级
        PacketId::CG_Car_Replace_Send =>  'Game\Controller\Car\CarReplace',       // 赛车更换
        PacketId::CG_CreateAccount => 'Game\Controller\Account\CreateData',      // 创建账号
        PacketId::CG_InputName => 'Game\Controller\Account\InputName',          // 输入昵称
        PacketId::CG_SelectCar => 'Game\Controller\Account\SelectCar',          // 选车
        PacketId::CG_SearchStep => 'Game\Controller\Account\SearchStep',        // 查询步骤
        PacketId::CG_SaveGuideStep => 'Game\Controller\Account\SaveGuideStep',  // 保存新手引导步骤
        PacketId::CG_ChangeNickName => 'Game\Controller\Account\CG_ChangeNickName',  // 修改昵称
        PacketId::CG_GuideMatching => 'Game\Controller\Guide\CG_GuideMatching',  // 新手引导匹配
        PacketId::CG_SearchRefit => 'Game\Controller\Car\SearchRefitData',     //搜索车辆改装数据
        PacketId::CG_CarRefit => 'Game\Controller\Car\CarRefit',               //改装车辆数据
        PacketId::CG_FriendApply => 'Game\Controller\Friend\apply',            //好友申请
        PacketId::CG_FriendVerify => 'Game\Controller\Friend\verify',          //好友验证
        PacketId::CG_FriendMineList => 'Game\Controller\Friend\mineList',      //我的好友列表
        PacketId::CG_FriendPreciseFilter => 'Game\Controller\Friend\preciseFilter',   //好友精确搜索
        PacketId::CG_FriendConditionFilter => 'Game\Controller\Friend\conditionFilter',    //好友条件搜索
        PacketId::CG_FriendUpRemark => 'Game\Controller\Friend\upRemark',      //好友备注修改
        PacketId::CG_FriendApplyList => 'Game\Controller\Friend\applyList',    //好友申请列表
        PacketId::CG_FriendGood => 'Game\Controller\Friend\good',              //好友点赞
        PacketId::CG_FriendBatchVerify => 'Game\Controller\Friend\batchVerify',//批量取消申请
        PacketId::CG_FriendOneClickReject => 'Game\Controller\Friend\oneClick', //一键拒绝好友申请
        PacketId::CG_FriendDelete => 'Game\Controller\Friend\del',              //删除好友
        PacketId::CG_FriendBlackList => 'Game\Controller\Friend\blackList',     //黑名单列表
        PacketId::CG_FriendBlack => 'Game\Controller\Friend\black',             //黑名单
        PacketId::CG_FriendApplyGame => 'Game\Controller\Friend\applyGame',     //邀请好友比赛
        PacketId::CG_FriendLastGame => 'Game\Controller\Friend\lastGame',       //最近比赛记录
        PacketId::CG_FriendRejectGameInvitation => 'Game\Controller\Friend\rejectInvitation',   //拒绝好友邀请
        PacketId::CG_SendOnLineNotice => 'Game\Controller\Notice\sendTips',   //玩家对玩家发送的消息 通用消息
        PacketId::CG_CloseNotice => 'Game\Controller\Notice\close',  //notice关闭交互
        PacketId::CG_IntimacyApply => 'Game\Controller\Friend\CG_IntimacyApply',       //申请亲密关系
        PacketId::CG_IntimacyApplyInfo => 'Game\Controller\Friend\CG_IntimacyApplyInfo',       //获取亲密关系申请
        PacketId::CG_IntimacyApplyOption => 'Game\Controller\Friend\CG_IntimacyApplyOption',       //申请信息操作
        PacketId::CG_RemoveIntimacyTitle => 'Game\Controller\Friend\CG_RemoveIntimacyTitle',       //解除亲密关系
        PacketId::CG_FriendIntimacyTask => 'Game\Controller\Task\CG_FriendIntimacyTask',    //获取好友亲密关系任务
        PacketId::CG_FriendIntimacyReward => 'Game\Controller\Task\CG_FriendIntimacyReward',    //领取好友亲密度奖励
        PacketId::CG_LoginCheckMsg => 'Game\Controller\Login\LoginCheck',    // 登录滞后检测
        PacketId::CG_TestLogin => 'Game\Controller\Login\LoginTest',

        // 房间
        PacketId::CG_CreateRoom => 'Game\Controller\Room\CreateRoom',              // 新建房间
        PacketId::CG_UpdateRoomMapID => 'Game\Controller\Room\ChangeMapID',        // 修改地图
        PacketId::CG_UpdateRoomModeType => 'Game\Controller\Room\ChangeModeType',  // 修改模式
        PacketId::CG_UpdateRoomState => 'Game\Controller\Room\ChangeRoomState',    // 修改房间状态（房间）
        PacketId::CG_UpdateRoomName => 'Game\Controller\Room\ChangeName',          // 修改房名
        PacketId::CG_UpdatePlayerCar => 'Game\Controller\Room\ChangePlayerCar',    // 修改车辆（玩家）
        PacketId::CG_UpdatePlayerState => 'Game\Controller\Room\ChangePlayerState',// 修改状态（玩家）
        PacketId::CG_ExitRoom => 'Game\Controller\Room\ExitRoom',                  // 退出房间
        PacketId::CG_FastJoinRoom => 'Game\Controller\Room\FastJoin',              // 快速加入
        PacketId::CG_JoinByRoomID => 'Game\Controller\Room\JoinByRoomID',          // roomID加入
        PacketId::CG_OwnerRemovePlayer => 'Game\Controller\Room\OwnerRemovePlayer',          // 房主踢人
        PacketId::CG_UpdateRoomPlayerCloth => 'Game\Controller\Room\CG_UpdateRoomPlayerCloth',  //房间内换服装
        PacketId::CG_BroadcastChat => 'Game\Controller\Room\CG_BroadcastChat',  //广播聊天消息
        PacketID::CG_CancelMatch => 'Game\Controller\Pvp\CancelMatch',
        PacketId::CG_TaskSearch => 'Game\Controller\Task\CG_TaskSearch',        //获取任务
        PacketId::CG_DailyInfo => 'Game\Controller\Task\CG_DailyInfo',          //获取日常信息
        PacketId::CG_DailyTaskOption => 'Game\Controller\Task\CG_DailyTaskOption',  //日常任务操作
        PacketId::CG_RefreshDailyChallengeTask => 'Game\Controller\Task\CG_RefreshDailyChallengeTask',  //刷新日常挑战任务
        PacketId::CG_SubmitTask => 'Game\Controller\Task\CG_SubmitTask',        //提交任务
        PacketId::CG_ZLInfo => 'Game\Controller\Task\CG_ZLInfo',                //获取战令信息
        PacketId::CG_ZLReward => 'Game\Controller\Task\CG_ZLReward',            //领取战令奖励请求
        PacketId::CG_BuyZLLevel => 'Game\Controller\Task\CG_BuyZLLevel',        //购买战令等级请求
        PacketId::CG_BuyZLExpert => 'Game\Controller\Task\CG_BuyZLExpert',      //开通高阶请求
        PacketId::CG_DrivingLicense => 'Game\Controller\DrivingLicense\CG_DrivingLicense',      //获取驾照请求
        PacketId::CG_DrivingLicenseChapter => 'Game\Controller\DrivingLicense\CG_DrivingLicenseChapter',    //获取驾照关卡请求
        PacketId::CG_EnterPve => 'Game\Controller\PVE\CG_EnterPve',     //进入pve关卡
        PacketId::CG_FinishPve => 'Game\Controller\PVE\CG_FinishPve',     //pve关卡结算
        PacketId::CG_PveWatchVideo => 'Game\Controller\PVE\CG_PveWatchVideo',     //pve关卡观看教学视频
        PacketId::CG_GameLevelData => 'Game\Controller\Career\CG_GameLevelData',      //游戏关卡数据
        PacketId::CG_GameLevelStarReward => 'Game\Controller\Career\CG_GameLevelStarReward',      //关卡星星奖励
        PacketId::CG_GameLevelChapter => 'Game\Controller\Career\CG_GameLevelChapter',      //已解锁最大关卡
        PacketId::CG_GameLevelStarData => 'Game\Controller\Career\CG_GameLevelStarData',      //获取星级宝箱
        PacketId::CG_CarExteriorRefit => 'Game\Controller\Car\CarExteriorRefit',       // 外观改装数据
        PacketId::CG_AddCarExteriorRefit => 'Game\Controller\Car\ExteriorRefitAdd',    // 车贴增加
        PacketId::CG_CarExteriorRefitDel => 'Game\Controller\Car\ExteriorRefitDel', // 外观改装数据删除
        PacketId::CG_CarExteriorRefitUpdate => 'Game\Controller\Car\ExteriorRefitUpdate', // 外观改装数据修改
        PacketId::CG_GetLicence => 'Game\Controller\Car\GetLicence', // 车牌号获取
        PacketId::CG_LicenceSave => 'Game\Controller\Car\LicenceSave', // 车牌号获取
        PacketId::CG_PaiWeiLikes => 'Game\Controller\Likes\RankLikes', // 比赛后点赞
        PacketId::CG_RankReadyState => 'Game\Controller\Room\RankUpdateState', // 排位修改状态
        PacketId::CG_RankChangeCar => 'Game\Controller\Room\RankUpdateCar',    // 排位换车
        PacketId::CG_RankJoinScene => 'Game\Controller\Room\RankEnterScene',   // 进入游戏
        PacketId::CG_RankTeamRecord => 'Game\Controller\Room\CG_RankTeamRecord',    //团队排位赛,同队内展示战绩
        PacketId::CG_FindIMRoomList => 'Game\Controller\Room\IMFindRoomList',  // 聊天查询房间列表
        PacketId::CG_SyncChatID => 'Game\Controller\Room\SyncChatID',  // 聊天查询房间列表
        PacketId::CG_SyncRoomExteriorRefit => 'Game\Controller\Room\SyncRoomExteriorRefit', // 同步房间内玩家车改装数据
        PacketId::CG_RankChangeCarExteriorRefit => 'Game\Controller\Room\RankUpdateCarExteriorRefit',    // 排位换车改装
        PacketId::CG_RefitItemBindCar => 'Game\Controller\Car\RefitItemBindCar', // 万能改装道具绑定车

        // 自定义房间
        PacketId::CG_CreateCRoom => 'Game\Controller\RoomCustomize\CreateRoom',              // 新建房间
        PacketId::CG_JoinByCRoomID => 'Game\Controller\RoomCustomize\JoinByRoomID',          // roomID加入
        PacketId::CG_ExitCRoom => 'Game\Controller\RoomCustomize\ExitRoom',                  // 退出房间
        PacketId::CG_UpdateCRoomName => 'Game\Controller\RoomCustomize\ChangeName',          // 修改房名
        PacketId::CG_UpdateCRoomModeType => 'Game\Controller\RoomCustomize\ChangeModeType',  // 修改模式
        PacketId::CG_UpdateCRoomMapID => 'Game\Controller\RoomCustomize\ChangeMapID',        // 修改地图
        PacketId::CG_ChangeCRoomPlayerState => 'Game\Controller\RoomCustomize\ChangePlayerState',// 修改状态（玩家）
        PacketId::CG_ChangeCRoomPlayerCar => 'Game\Controller\RoomCustomize\ChangePlayerCar',    // 修改车辆（玩家）
        PacketId::CG_UpdateCRoomState => 'Game\Controller\RoomCustomize\ChangeRoomState',        // 修改房间状态（房间）
        PacketId::CG_OwnerCRemovePlayer => 'Game\Controller\RoomCustomize\OwnerRemovePlayer',    // 房主踢人
        PacketId::CG_UpdatePlayerTeam => 'Game\Controller\RoomCustomize\ChangePlayerTeam',       // 修改位置
        PacketId::CG_GetCustomize => 'Game\Controller\RoomCustomize\GetCustomize',               // 获取自定义房间
        PacketId::CG_SaveMapID => 'Game\Controller\RoomCustomize\SaveMapID',                     // 收藏地图
        PacketId::CG_UpdateCRoomAI => 'Game\Controller\RoomCustomize\ChangeRoomAI',              // 收藏地图
        PacketId::CG_UpdateCRoomPWD => 'Game\Controller\RoomCustomize\ChangeRoomPassword',       // 收藏地图
        PacketId::CG_PassWordIsShow => 'Game\Controller\RoomCustomize\ChangeRoomIsShowPwd',      // 密码是否可见同步
        PacketId::CG_WatchByCRoomID => 'Game\Controller\RoomCustomize\JoinWatchByRoomID',        // 观战模式进入
        PacketId::CG_RemoveCRoomByRoomID => 'Game\Controller\RoomCustomize\RemoveRoomByRoomID',  // 删除自定义房间
        PacketId::CG_SyncCRoomLimitTime => 'Game\Controller\RoomCustomize\SyncRoomTime',         // 同步自定义房间失效时间


        PacketId::CG_ClubInfo => 'Game\Controller\Club\GetClubInfo', // 获取俱乐部信息
        PacketId::CG_CreateClub => 'Game\Controller\Club\CreateClub', // 创建俱乐部
        PacketId::CG_ChangeClub => 'Game\Controller\Club\ChangeClub', // 修改俱乐部信息
        PacketId::CG_ChangeNotice => 'Game\Controller\Club\ChangeNotice', // 修改宣言
        PacketId::CG_ChangeTag => 'Game\Controller\Club\ChangeTag', // 修改标签
        PacketId::CG_RequestJoinClub => 'Game\Controller\Club\RequestJoin', // 加入请求
        PacketId::CG_ApprovalJoin => 'Game\Controller\Club\ApprovalJoin', // 审核
        PacketId::CG_ChangePost => 'Game\Controller\Club\ChangePost', // 修改职位
        PacketId::CG_DelClubMember => 'Game\Controller\Club\DelClubMember', // 删除成员
        PacketId::CG_ExitClub => 'Game\Controller\Club\ExitClub', // 退出俱乐部
        PacketId::CG_DisbandClub => 'Game\Controller\Club\DisbandClub', // 解散俱乐部
        PacketId::CG_SearchClubFuzzy => 'Game\Controller\Club\SearchClubFuzzy', // 模糊查询俱乐部
        PacketId::CG_ApplyJoinClear => 'Game\Controller\Club\ApplyJoinClear', // 清空请求列表
        PacketId::CG_FindMyClubID => 'Game\Controller\Club\FindMyClubID', // 清空请求列表
        PacketId::CG_RandSearchClub => 'Game\Controller\Club\RandomSearch', // 随机查询俱乐部
        PacketId::CG_ClubRank => 'Game\Controller\Rank\Club', // 俱乐部全局排行榜
        PacketId::CG_ReplaceClubMaster => 'Game\Controller\Club\ReplaceMaster', // 俱乐部转让队长
        PacketId::CG_ImpeachMaster => 'Game\Controller\Club\ImpeachMaster', // 俱乐部弹劾队长
        PacketId::CG_BuyClubStoreItem => 'Game\Controller\Club\BuyStoreItem', // 购买俱乐部商品
        PacketId::CG_GetClubStoreRecord => 'Game\Controller\Club\GetStoreRecord', // 获取商店购买记录
        PacketId::CG_GetClubBattlePass => 'Game\Controller\Club\GetBattlePass', // 获取俱乐部战令数据
        PacketId::CG_GetClubBattlePassMoney => 'Game\Controller\Club\BattlePassMoney',  //战令俱乐部,活跃度转代币,领取
        PacketId::CG_DailyDonate => 'Game\Controller\Club\CG_DailyDonate',  //俱乐部每日捐献
        PacketId::CG_DrivingPermit => 'Game\Controller\DrivingPermit\CG_DrivingPermit', //行驶证-车辆使用次数
        PacketId::CG_DrivingPermitLevel => 'Game\Controller\DrivingPermit\CG_DrivingPermitLevel', //行驶证-关卡
        PacketId::CG_FindRank => 'Game\Controller\Rank\FindRank',
        PacketId::CG_RankLike => 'Game\Controller\Rank\Like',
        //技巧教学
        PacketId::CG_TeachingSkill => 'Game\Controller\TeachingSkill\CG_TeachingSkill', //获取技巧教学等级
        PacketId::CG_TeachingSkillChapter => 'Game\Controller\TeachingSkill\CG_TeachingSkillChapter', //获取技巧教学关卡信息

        PacketId::MG_SearchPlayerInfo => 'Game\Controller\Gm\Account',
        PacketId::MG_GainItem => 'Game\Controller\Gm\Item',
        PacketId::MG_GainMoney => 'Game\Controller\Gm\Money',
        PacketId::MG_SendMail => 'Game\Controller\Gm\Mail',
        PacketId::MG_RankScore => 'Game\Controller\Gm\Rank',
        PacketId::MG_ClearRank => 'Game\Controller\Gm\ClearRank',
        PacketId::MG_CarProficiency => 'Game\Controller\Gm\CarProficiency',     //GM查询/修改赛车熟练度
        PacketId::MG_SeasonScore => 'Game\Controller\Gm\SeasonScore', // 赛季分查询修改
        PacketId::MG_LampAdd => 'Game\Controller\Gm\LampAdd', // 跑马灯增加
        PacketId::MG_LampCancel => 'Game\Controller\Gm\LampCancel', // 跑马灯撤回
        PacketId::MG_OpenGameLevel => 'Game\Controller\Gm\OpenGameLevel', //一键开启关卡
        PacketId::MG_UpdateFrinedIntimacy => 'Game\Controller\Gm\UpdateFriendIntimacy', //修改好友亲密度
        PacketId::MG_ServerState => 'Game\Controller\Gm\ServerState',
        PacketId::MG_ServerModule => 'Game\Controller\Gm\ServerModule',
        PacketId::MG_OutPlayer => 'Game\Controller\Gm\OutPlayer',
        PacketId::MG_BanPlayer => 'Game\Controller\Gm\BanPlayer',
        PacketId::MG_ProhibitionPlayer => 'Game\Controller\Gm\ProhibitionPlayer',
        PacketId::MG_SvnUP => 'Game\Controller\Gm\SvnUP',
        PacketId::MG_ChangeExp => 'Game\Controller\Gm\ChangeExp',
        PacketId::MG_ChangeDevelopmentalTask => 'Game\Controller\Gm\ChangeDevelopmentalTask',
        PacketId::MG_CompleteTask => 'Game\Controller\Gm\CompleteTask',

        PacketId::CG_GetNoticeInfo => 'Game\Controller\Notice',
        //商城
        PacketId::CG_ShopItem => 'Game\Controller\Shop\ShopItem\CG_ShopItem',   //获取道具商城道具
        PacketId::CG_BuyShopItem => 'Game\Controller\Shop\ShopItem\CG_BuyShopItem',   //购买道具商城道具
        PacketId::CG_BuyShopCar => 'Game\Controller\Shop\ShopCar\CG_BuyShopCar',   //购买赛车商城道具
        PacketId::CG_BuyShopClothing => 'Game\Controller\Shop\ShopClothing\CG_BuyShopClothing',   //购买服装商城道具
        PacketId::CG_ShopSeason => 'Game\Controller\Shop\ShopSeason\CG_ShopSeason',   //获取赛季商城道具
        PacketId::CG_BuyShopSeason => 'Game\Controller\Shop\ShopSeason\CG_BuyShopSeason',   //购买赛季商城道具
        PacketId::CG_ShopZL => 'Game\Controller\Shop\ShopZL\ShopZL',         // 获取战令商城道具
        PacketId::CG_BuyShopZL => 'Game\Controller\Shop\ShopZL\BuyShopZL',   // 购买战令商城道具
        PacketId::CG_ExchangeTreasureTicket => 'Game\Controller\Shop\ShopBlindBox\CG_ExchangeTreasureTicket', //兑换抽奖券
        PacketId::CG_BlindBoxNum => 'Game\Controller\Shop\ShopBlindBox\CG_BlindBoxNum', //获取已抽奖次数
        PacketId::CG_BlindBox => 'Game\Controller\Shop\ShopBlindBox\CG_BlindBox', //抽奖
        PacketId::CG_BuyShopRecommend => 'Game\Controller\Shop\ShopRecommend\CG_BuyShopRecommend', //购买推荐商城道具
        //熟练度
        PacketId::CG_ProficiencyData => 'Game\Controller\Proficiency\CG_ProficiencyData',   //获取总活跃度信息
        PacketId::CG_GetProficiencyReward => 'Game\Controller\Proficiency\CG_GetProficiencyReward',   //领取总活跃度奖励
        PacketId::CG_GetCarProficiencyReward => 'Game\Controller\Proficiency\CG_GetCarProficiencyReward',   //领取总活跃度奖励
        PacketId::CG_BuyProficiencyFlag => 'Game\Controller\Proficiency\CG_BuyProficiencyFlag',   //开通高级--临时用
        //清空新车通知--临时用
        PacketId::CG_ClearNewCarNotice => 'Game\Controller\Car\CG_ClearNewCarNotice',
        //统计信息
        PacketId::CG_StatisticsInfo => 'Game\Controller\Statistics\CG_StatisticsInfo',  //比赛统计信息
        PacketId::CG_CarStatisticsInfo => 'Game\Controller\Statistics\CG_CarStatisticsInfo',  //赛车统计信息
        PacketId::CG_MatchRecord => 'Game\Controller\Statistics\CG_MatchRecord',  //获取比赛记录
        PacketId::CG_MatchCollectionRecord => 'Game\Controller\Statistics\CG_MatchCollectionRecord',  //获取收藏记录
        PacketId::CG_MatchRecordDetail => 'Game\Controller\Statistics\CG_MatchRecordDetail',  //获取比赛详细数据
        PacketId::CG_CollectionOption => 'Game\Controller\Statistics\CG_CollectionOption',  //添加/取消收藏
        //地图挑战赛
        PacketId::CG_MapChallengeInfo => 'Game\Controller\Activity\MapChallenge\CG_MapChallengeInfo',  //获取地图挑战赛信息
        PacketId::CG_EnterMapChallengeScene => 'Game\Controller\Activity\MapChallenge\CG_EnterMapChallengeScene',  //进入地图挑战赛场景
        PacketId::CG_FinishMapChallenge => 'Game\Controller\Activity\MapChallenge\CG_FinishMapChallenge',  //地图挑战赛结算
        PacketId::CG_MapChallengeReward => 'Game\Controller\Activity\MapChallenge\CG_MapChallengeReward',  //领取地图挑战赛大奖
        PacketId::CG_MapChallengeMapReward => 'Game\Controller\Activity\MapChallenge\CG_MapChallengeMapReward',  //领取地图挑战赛地图奖励
        PacketId::CG_MpaChallengeRank => 'Game\Controller\Activity\MapChallenge\CG_MpaChallengeRank',  //获取地图挑战赛自己排名
        //大乱斗
//        PacketId::CG_ScuffleData => 'Game\Controller\Activity\Scuffle\CG_ScuffleData',  //获取自己大乱斗积分等信息
        PacketId::CG_RollCar => 'Game\Controller\Activity\Scuffle\CG_RollCar',  //使用骰子
        PacketId::CG_ReplacePublicPoolCar => 'Game\Controller\Activity\Scuffle\CG_ReplacePublicPoolCar',  //使用骰子
        PacketId::CG_ApplyScuffleReplaceTargetCar => 'Game\Controller\Activity\Scuffle\CG_ApplyScuffleReplaceTargetCar',  //发送交换赛车请求
        PacketId::CG_DealScuffleReplaceCarApply => 'Game\Controller\Activity\Scuffle\CG_DealScuffleReplaceCarApply',  //处理换车请求
        PacketId::CG_CancelReplaceCar => 'Game\Controller\Activity\Scuffle\CG_CancelReplaceCar',  //取消换车请求
//        PacketId::CG_ScuffleTitleReward => 'Game\Controller\Activity\Scuffle\CG_ScuffleTitleReward',  //领取大乱斗称号奖励
//        PacketId::CG_BroadcastReplaceCarSkin => 'Game\Controller\Activity\Scuffle\CG_BroadcastReplaceCarSkin',  //广播通知换车皮肤
        //活动
        PacketId::CG_GetActivityInfo => 'Game\Controller\Activity\CG_GetActivityInfo',  //活动信息
        // 赛季奖励
        PacketId::CG_FindSeasonReward => 'Game\Controller\Season\FindReward',     // 获取赛季奖励信息
        PacketId::CG_ReceiveSeasonReward => 'Game\Controller\Season\Receive',     // 领取赛季奖励
        PacketId::CG_ReceiveSeasonLoop => 'Game\Controller\Season\ReceiveLoop',  // 领取赛季循环奖励

        // 福利活动
        PacketId::CG_Get7NewData => 'Game\Controller\Activity\Welfare\Get7NewData',               // 获取7日新秀数据
        PacketId::CG_Receive7NewReward => 'Game\Controller\Activity\Welfare\Receive7New',         // 领取7日奖励
        PacketId::CG_GetLoginRewardData => 'Game\Controller\Activity\Welfare\GetLoginReward',     // 获取登录奖励
        PacketId::CG_ReceiveLoginReward => 'Game\Controller\Activity\Welfare\ReceiveLoginReward', // 领取登录奖励
        PacketId::CG_AgainWeekTask => 'Game\Controller\Activity\Welfare\AgainWeekTask',           // 周签补签
        PacketID::CG_GetWeekLoginInfo => 'Game\Controller\Activity\Welfare\GetWeekLoginInfo',     // 获取周末登录信息
        PacketID::CG_RewardWeekLogin => 'Game\Controller\Activity\Welfare\RewardWeekLogin',       // 领取周末登录奖励

        // 战令 补充
        PacketId::CG_ZLFindFriends => 'Game\Controller\Task\ZLFindFriends',  // 战令 获取好友信息
        PacketId::CG_ZLOption => 'Game\Controller\Task\ZLOption',            // 战令 索要/赠送

        PacketId::CG_GetServerState => 'Game\Controller\Server\Server', // 获取服务器状态
        PacketId::CG_CheckGuestByDeviceID => 'Game\Controller\Guest\Guest', // 游客账号获取
        PacketId::CG_GuestBindAccount => 'Game\Controller\Guest\Bind',      // 游客账号绑定
        PacketId::CG_LogOut => 'Game\Controller\Login\Logout',              // 退出登录

        PacketId::CG_FindCloseModule => 'Game\Controller\Server\ModuleState',  // 查询关闭模块

        PacketId::CG_GetActivityLimitTimeInfo => 'Game\Controller\Activity\LimitTime\GetActivityInfo', // 获取限时活动
        PacketId::CG_BuyExchangeShop => 'Game\Controller\Activity\LimitTime\BuyExchangeShop', // 兑换商城兑换
        PacketId::CG_RewardTaskLogin => 'Game\Controller\Activity\LimitTime\RewardLogin', // 领取限时活动累计登录奖励
        PacketId::CG_GetFestivalRewardInfo => 'Game\Controller\Activity\LimitTime\GetFestivalReward', // 获取节日领取记录
        PacketId::CG_RewardFestival => 'Game\Controller\Activity\LimitTime\RewardFestival', //  领取节日奖励
    );

    public const GAME_LEVEL = 1;        // 生涯
    public const CLUB = 2;              // 俱乐部
    public const CAR_STRENGTHEN = 3;    // 车强化
    public const CAR_UPGRADE = 4;       // 车升级
    public const CAR_REFIT = 5;         // 车改装
    public const PVP_PRACTICE = 6;      // 练习赛
    public const PVP_RANKING = 7;       // 排位赛
    public const MAIN_START = 8;        // 主界面开始游戏
    public const SCUFFLE = 9;           // 大乱斗
    public const RANKING = 10;          // 排行榜
    public const PROFICIENCY = 11;      // 熟练度
    public const ITEM = 12;             // 背包
    public const SHOP = 13;             // 商城
    public const ZL = 14;               // 战令
    public const ACTIVITY_FL = 15;      // 福利活动
    public const TASK_DEVELOP = 16;     // 成长任务（UI）
    public const TASK = 17;             // 任务
    public const MAIL = 18;             // 邮件
    public const FRIEND = 19;           // 好友
    public const DRIVING_LICENSE = 20;  // 驾照
    public const DRIVING_PERMIT = 21;   // 行驶证
    public const TEACHING = 22;         // 技巧教学
    public const C_ROOM = 23;           // 自定义房间
    public const MAP_CHALLENGE = 24;    // 地图挑战赛
    public const SEASON = 25;           // 赛季奖励
    public const PVE = 26;              // PVE

    // 屏蔽消息
    public const PACKET_LIMIT_MAP = [
        self::GAME_LEVEL => [
            PacketId::CG_GameLevelData,
            PacketId::CG_GameLevelStarReward,
            PacketId::CG_GameLevelStarData,
            PacketId::CG_GameLevelChapter,
        ],
        self::CLUB => [
            PacketId::CG_ClubInfo,
            PacketId::CG_CreateClub,
            PacketId::CG_RandSearchClub,
            PacketId::CG_ChangeClub,
            PacketId::CG_ChangeNotice,
            PacketId::CG_ChangeTag,
            PacketId::CG_RequestJoinClub,
            PacketId::CG_ChangePost,
            PacketId::CG_DelClubMember,
            PacketId::CG_ExitClub,
            PacketId::CG_DisbandClub,
            PacketId::CG_ApprovalJoin,
            PacketId::CG_SearchClubFuzzy,
            PacketId::CG_ClubRank,
            PacketId::CG_ApplyJoinClear,
            PacketId::CG_FindMyClubID,
            PacketId::CG_ReplaceClubMaster,
            PacketId::CG_ImpeachMaster,
            PacketId::CG_GetClubStoreRecord,
            PacketId::CG_BuyClubStoreItem,
            PacketId::CG_GetClubBattlePass,
            PacketId::CG_ClubBattlePassReward,
            PacketId::CG_GetClubBattlePassMoney,
            PacketId::CG_GetCarsInfo,
            PacketId::CG_DailyDonate,
        ],
        self::CAR_STRENGTHEN => [
            PacketId::Use_Item_Send,
            PacketId::Cloth_Save_Send,
            PacketId::CG_ConvertExpireItem,
            PacketId::CG_GetCloth,
        ],
        self::CAR_UPGRADE => [
            PacketId::CG_Car_Up_Grade_Send,
            PacketId::CG_CarRefit,
            PacketId::GC_ReplySearchRefitData,
        ],
        self::CAR_REFIT => [
            PacketId::CG_CarExteriorRefit,
            PacketId::CG_CarExteriorRefitDel,
            PacketId::CG_CarExteriorRefitUpdate,
            PacketId::CG_GetLicence,
            PacketId::CG_AddCarExteriorRefit,
        ],
        self::PVP_PRACTICE => [

        ],
        self::PVP_RANKING => [
//            PacketId::CG_RankReadyState,
//            PacketId::CG_RankChangeCar,
            PacketId::CG_RankJoinScene,
            PacketId::CG_RankTeamRecord,
            PacketId::CG_PaiWeiLikes,
            PacketId::CG_PaiweiLevelInfo,
            PacketId::CG_UpdatePaiWeiPositionOrder,
        ],
        self::MAIN_START => [

        ],
        self::SCUFFLE => [
            PacketId::CG_RollCar,
            PacketId::CG_ReplacePublicPoolCar,
            PacketId::CG_ApplyScuffleReplaceTargetCar,
            PacketId::CG_DealScuffleReplaceCarApply,
            PacketId::CG_CancelReplaceCar,
        ],
        self::RANKING => [
            PacketId::CG_FindRank,
            PacketId::CG_UpdateScore,
            PacketId::CG_RankLike,
        ],
        self::PROFICIENCY => [
            PacketId::CG_ProficiencyData,
            PacketId::CG_GetProficiencyReward,
            PacketId::CG_BuyProficiencyFlag,
            PacketId::CG_GetCarProficiencyReward,
        ],
        self::ITEM => [
            PacketId::Use_Item_Send,
            PacketId::CG_ConvertExpireItem,
//            PacketId::CG_GetCloth,
        ],
        self::SHOP => [
            PacketId::CG_ShopItem,
            PacketId::CG_BuyShopItem,
            PacketId::CG_BuyShopCar,
            PacketId::CG_BuyShopClothing,
            PacketId::CG_ShopSeason,
            PacketId::CG_BuyShopSeason,
            PacketId::CG_ShopZL,
            PacketId::GC_BuyShopZL,
        ],
        self::ZL => [
            PacketId::CG_ZLInfo,
            PacketId::CG_ZLReward,
            PacketId::CG_BuyZLLevel,
            PacketId::CG_BuyZLExpert,
            PacketId::CG_ZLFindFriends,
            PacketId::CG_ZLOption,
        ],
        self::ACTIVITY_FL => [
            PacketId::CG_Get7NewData,
            PacketId::CG_Receive7NewReward,
            PacketId::CG_GetLoginRewardData,
            PacketId::CG_ReceiveLoginReward,
            PacketId::CG_AgainWeekTask,
        ],
        self::TASK_DEVELOP => [

        ],
        self::TASK => [
            PacketId::CG_TaskSearch,
            PacketId::CG_DailyInfo,
            PacketId::CG_DailyTaskOption,
            PacketId::CG_SubmitTask,
            PacketId::CG_RefreshDailyChallengeTask,
            PacketId::CG_FriendIntimacyTask,
            PacketId::CG_FriendIntimacyReward,
        ],
        self::MAIL => [
            PacketId::CG_MailSearch,
            PacketId::CG_MailOption,
            PacketId::CG_RefuseDemandZL,
            PacketId::CG_ReceiveZL,
        ],
        self::FRIEND => [
            PacketId::CG_FriendApply,
            PacketId::CG_FriendVerify,
//            PacketId::CG_FriendMineList,
            PacketId::CG_FriendPreciseFilter,
            PacketId::CG_FriendConditionFilter,
            PacketId::CG_FriendDelete,
            PacketId::CG_FriendBlack,
            PacketId::CG_FriendGood,
            PacketId::CG_FriendUpRemark,
            PacketId::CG_FriendApplyList,
            PacketId::CG_FriendBatchVerify,
            PacketId::CG_FriendOneClickReject,
            PacketId::CG_FriendBlackList,
            PacketId::CG_FriendApplyGame,
            PacketId::CG_FriendLastGame,
            PacketId::CG_FriendRejectGameInvitation,
            PacketId::CG_SendOnLineNotice,
            PacketId::CG_CloseNotice,
            PacketId::CG_IntimacyApply,
            PacketId::CG_IntimacyApplyInfo,
            PacketId::CG_IntimacyApplyOption,
            PacketId::CG_RemoveIntimacyTitle,
        ],
        self::DRIVING_LICENSE => [
            PacketId::CG_DrivingLicense,
            PacketId::CG_DrivingLicenseChapter,
        ],
        self::DRIVING_PERMIT => [
            PacketId::CG_DrivingPermit,
            PacketId::CG_DrivingPermitLevel,
        ],
        self::TEACHING => [
            PacketId::CG_TeachingSkill,
            PacketId::CG_TeachingSkillChapter,
        ],
        self::C_ROOM => [
            PacketId::CG_CreateCRoom,
            PacketId::CG_JoinByCRoomID,
            PacketId::CG_ExitCRoom,
            PacketId::CG_UpdateCRoomName,
            PacketId::CG_UpdateCRoomModeType,
            PacketId::CG_UpdateCRoomMapID,
            PacketId::CG_ChangeCRoomPlayerState,
            PacketId::CG_ChangeCRoomPlayerCar,
            PacketId::CG_UpdatePlayerTeam,
            PacketId::CG_UpdateCRoomState,
            PacketId::CG_UpdateCRoomType,
            PacketId::CG_OwnerCRemovePlayer,
            PacketId::CG_GetCustomize,
            PacketId::CG_SaveMapID,
            PacketId::CG_UpdateCRoomAI,
            PacketId::CG_UpdateCRoomPWD,
            PacketId::CG_PassWordIsShow,
            PacketId::CG_WatchByCRoomID,
            PacketId::CG_RemoveCRoomByRoomID,
            PacketId::CG_SyncCRoomLimitTime,
        ],
        self::MAP_CHALLENGE => [
            PacketId::CG_MapChallengeInfo,
            PacketId::CG_EnterMapChallengeScene,
            PacketId::CG_FinishMapChallenge,
            PacketId::CG_MapChallengeMapReward,
            PacketId::CG_MapChallengeReward,
            PacketId::CG_MpaChallengeRank,
        ],
        self::SEASON => [
            PacketId::CG_FindSeasonReward,
            PacketId::CG_ReceiveSeasonReward,
            PacketId::CG_ReceiveSeasonLoop,
        ],
        self::PVE => [
            PacketId::CG_EnterPve,
            PacketId::CG_FinishPve,
        ],
    ];

    /**
     * 通过消息id获取controller命名空间
     * @param int $id 消息id
     * @return string 对应controller的命名空间
     */
    public function getControllerName(int $id): string
    {
        if (!array_key_exists($id, self::PACKET_MAP)) {
            return "";
        }
        return self::PACKET_MAP[$id];
    }
}
