<?php

/**
 * ModelTypeDefine.php
 * 文件描述
 * Created On 2022/1/18
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Game\Constant;

use Framework\Define\IModelDefine;
use Framework\Lib\Utils;

class ModelTypeDefine implements IModelDefine
{
    public const ACCOUNT = 1;
    public const COMMON = 2;
    public const ITEM = 3;
    public const MONEY = 4;
    public const PAIWEI_LEVEL = 5;      //排位赛段位
    public const TIMER = 6;
    public const PACKET_CACHE = 8;
    public const PVP_BASE = 9;
    public const MAIL = 13;
    public const PVE = 14;  //pve 驾照考试 试驾关卡 技巧教学
    public const CAR = 15;
    public const COMMON_MAIL = 16;
    public const COMMON_TIMER = 17;
    public const COMMON_DATA = 18;
    public const SYNC = 19;
    public const SEASON_STATISTICS = 20;    //赛季信息统计
    public const MAP_STATISTICS = 21;       //地图信息统计
    public const PROFICIENCY_TOTAL = 22;    //总熟练度
    public const RECORD = 23;           //比赛记录
    public const COMMON_SEASON = 24;    //全局赛季
    public const FRIEND = 25;
    public const COMMON_FRIEND = 26;
    public const FRIEND_REQUEST = 27;
    public const FRIEND_BLACK = 28;
    public const ON_LINE = 30;
    public const ROOM = 31;             // 房间
    public const EVENT = 32;
    public const TASK_BASE = 33;    //任务
    public const TASK_DAILY = 34;
    public const TASK_MAIN = 35;
    public const TASK_BRANCH = 36;
    public const TASK_SEASON = 37;          //赛季战令第x周
    public const TASK_ACTIVE = 38;  //活跃度
    public const NOTICE = 39;   //通知
    public const STRANGER_BLACK = 40;  //陌生人黑名单
    public const COMMON_SEASON_WEEK = 41;   //赛季周
    public const SEASON = 42;               //赛季
    public const WAR_TOKEN = 43;    //战令
    public const FRIEND_LAST_GAME = 44;  //最近比赛记录
    public const CAR_EXTERIOR_REFIT = 53;
    public const LIKES = 54;    //比赛后点赞
    public const EVENT_CONDITION = 55;
    public const CLUB = 56; // 俱乐部
    public const RANK = 57;
    public const CLUB_STORE = 58; // 俱乐部商店
    public const SINGLE_PRACTICE = 60;
    public const TEAM_PRACTICE = 61;
    public const SINGLE_RANKING = 62;
    public const TEAM_RANKING = 63;
    public const RANKING = 64;
    public const SHOP_ITEM = 66;            //道具商城
    public const CAR_STATISTICS = 67;       //赛车统计信息
    public const COMMON_ACTIVITY = 68;      //全局活动
    public const ACTIVITY_MAP_CHALLENGE = 69;   //地图挑战赛活动
    public const ROOM_CUSTOMIZE = 70;           // 自定义房间
    public const ROOM_CUSTOMIZE_SINGLE = 71;    // 单人
    public const ROOM_CUSTOMIZE_TEAM = 72;      // 团队
    public const ROOM_CUSTOMIZE_PRACTICE = 73;  // 练图
    public const ROOM_SCUFFLE = 74;         //大乱斗房间
    public const SCUFFLE = 75;              //大乱斗
    public const TEAM_SCUFFLE = 76;         //大乱斗匹配 结算
    public const SHOP_SEASON = 77;          //赛季商城
    public const WELFARE = 78;              // 福利活动
    public const TASK_WELFARE_WEEK = 79;              // 福利活动
    public const TASK_DAILY_CHALLENGE = 80; //日常挑战任务
    public const SHOP_ZL = 81;          // 战令商城
    public const LAMP = 82;          // 跑马灯
    public const FRIEND_INTIMACY_MARK = 83;  //好友亲密度记录
    public const FRIEND_INTIMACY = 84;      //好友亲密关系
    public const FRIEND_INTIMACY_APPLY = 85;    //好友亲密关系申请
    public const TASK_FRIEND_INTIMACY_REWARD = 86;    //亲密关系奖励任务
    public const SHOP_BLIND_BOX = 87;   //抽奖商城
    public const LIMIT_TIME_ACTIVITY = 88;   // 限时活动
    public const SHOP_TASK_EXCHANGE = 89;    // 限时任务兑换商城
    public const TASK_EXCHANGE_LOGIN = 90;    // 限时任务登录
    public const TASK_FESTIVAL_REWARD = 91;   // 节日活动领取记录
    public const COMMON_SEASON_STATUS = 92;   //全局赛季状态
    public const SEASON_STATUS = 93;        //赛季状态
    public const TASK_LIMIT_ACTIVITY = 94;        // 限时活动

    //全局的Model,不需要玩家登录检查
    public const MODEL_MAP_COMMON = array(
        self::COMMON => 'Framework\Model\CommonModel',
        self::COMMON_MAIL => 'Framework\Model\CommonMailModel',
        self::COMMON_TIMER => 'Framework\Model\CommonTimerModel',
        self::COMMON_DATA => 'Framework\Model\CommonDataModel',
        self::COMMON_SEASON => 'Framework\Model\CommonSeasonModel',
        self::COMMON_FRIEND => 'Game\Model\Friend\FriendRandomModel',
        self::COMMON_SEASON_WEEK => 'Framework\Model\CommonSeasonWeekModel',
        self::COMMON_ACTIVITY => 'Framework\Model\CommonActivityModel',
        self::COMMON_SEASON_STATUS => 'Framework\Model\CommonSeasonStatusModel',
    );

    public const MODEL_MAP1 = array(
        self::ACCOUNT => 'Game\Model\AccountModel',
        self::ITEM => 'Game\Model\ItemModel',
        self::MONEY => 'Game\Model\MoneyModel',
        self::PAIWEI_LEVEL => 'Game\Model\PaiweiLevelModel',
        self::TIMER => 'Framework\Model\TimerModel',
        self::PACKET_CACHE => 'Framework\Model\PacketCacheModel',
        self::PVP_BASE => 'Game\Model\Pvp\PvpBaseModel',
        self::MAIL => 'Game\Model\MailModel',
        self::PVE => 'Game\Model\PVE\PveModel',
        self::SYNC => 'Game\Model\SyncModel',
        self::CAR => 'Game\Model\Car\CarModel',
        self::SEASON_STATISTICS => 'Game\Model\Season\SeasonStatisticsModel',
        self::MAP_STATISTICS => 'Game\Model\MapStatisticsModel',
        self::PROFICIENCY_TOTAL => 'Game\Model\ProficiencyModel',
        self::RECORD => 'Game\Model\RecordModel',
        self::FRIEND => 'Game\Model\Friend\FriendModel',
        self::FRIEND_REQUEST => 'Game\Model\Friend\FriendRequestModel',
        self::FRIEND_BLACK => 'Game\Model\Friend\FriendBlackModel',
        self::ON_LINE => 'Framework\Model\OnLineModel',
        self::ROOM => 'Game\Model\RoomModel',
        self::ROOM_CUSTOMIZE => 'Game\Model\RoomCustomizeModel',
        self::EVENT => 'Game\Model\EventModel',
    );

    public const MODEL_MAP2 = array(
        self::TASK_BASE => 'Game\Model\Task\Manager\TaskMangerModelBase',
        self::TASK_DAILY => 'Game\Model\Task\Manager\DailyTaskManager',
        self::TASK_MAIN => 'Game\Model\Task\Manager\MainTaskManager',
        self::TASK_BRANCH => 'Game\Model\Task\Manager\BranchTaskManager',
        self::TASK_SEASON => 'Game\Model\Task\Manager\SeasonTaskManager',
        self::TASK_ACTIVE => 'Game\Model\Task\ActiveModel',
        self::NOTICE => 'Game\Model\NoticeModel',
        self::STRANGER_BLACK => 'Game\Model\Friend\StrangerBlackModel',
        self::FRIEND_LAST_GAME => 'Game\Model\Friend\FriendLastGameModel',
        self::SEASON => 'Game\Model\Season\SeasonModel',
        self::WAR_TOKEN => 'Game\Model\Task\WarTokenModel',
        self::SINGLE_PRACTICE => 'Game\Model\Pvp\Mode\SinglePracticeModel',
        self::TEAM_PRACTICE => 'Game\Model\Pvp\Mode\TeamPracticeModel',
        self::SINGLE_RANKING => 'Game\Model\Pvp\Mode\SingleRankingModel',
        self::TEAM_RANKING => 'Game\Model\Pvp\Mode\TeamRankingModel',
        self::CAR_EXTERIOR_REFIT => 'Game\Model\Car\CarExteriorRefitModel',
        self::LIKES => 'Game\Model\LikesModel',
        self::EVENT_CONDITION => 'Game\Model\EventConditionModel',
        self::CLUB => 'Game\Model\Club\ClubModel',
        self::CLUB_STORE => 'Game\Model\Club\ClubStoreModel',
        self::RANK => 'Framework\Model\RankModel',
        self::RANKING => 'Game\Model\Rank\RankModel',
    );

    public const MODEL_MAP3 = array(
        self::SHOP_ITEM => 'Game\Model\Shop\ShopItemModel',
        self::CAR_STATISTICS => 'Game\Model\Car\CarStatisticModel',
        self::ACTIVITY_MAP_CHALLENGE => 'Game\Model\Activity\MapChallengeModel',
        self::ROOM_CUSTOMIZE_SINGLE => 'Game\Model\Pvp\Mode\SingleModel',
        self::ROOM_CUSTOMIZE_TEAM => 'Game\Model\Pvp\Mode\TeamModel',
        self::ROOM_CUSTOMIZE_PRACTICE => 'Game\Model\Pvp\Mode\PracticeModel',
        self::ROOM_SCUFFLE => 'Game\Model\Room\ScuffleRoomModel',
        self::SCUFFLE => 'Game\Model\Activity\ScuffleModel',
        self::TEAM_SCUFFLE => 'Game\Model\Pvp\Mode\TeamScuffleModel',
        self::SHOP_SEASON => 'Game\Model\Shop\ShopSeasonModel',
        self::WELFARE => 'Game\Model\Activity\WelfareModel',
        self::TASK_WELFARE_WEEK => 'Game\Model\Task\Manager\WeekTaskManager',
        self::TASK_DAILY_CHALLENGE => 'Game\Model\Task\Manager\DailyChallengeTaskManager',
        self::SHOP_ZL => 'Game\Model\Shop\ShopZLModel',
        self::LAMP => 'Game\Model\LampModel',
        self::FRIEND_INTIMACY_MARK => 'Game\Model\Friend\FriendIntimacyMarkModel',
        self::FRIEND_INTIMACY => 'Game\Model\Friend\FriendIntimacyModel',
        self::FRIEND_INTIMACY_APPLY => 'Game\Model\Friend\FriendIntimacyApplyModel',
        self::TASK_FRIEND_INTIMACY_REWARD => 'Game\Model\Task\Manager\FriendIntimacyTaskManager',
        self::SHOP_BLIND_BOX => 'Game\Model\Shop\ShopBlindBoxModel',
        self::LIMIT_TIME_ACTIVITY => 'Game\Model\Activity\LimitTimeModel',
        self::SHOP_TASK_EXCHANGE => 'Game\Model\Shop\ShopTaskExchangeModel',
        self::TASK_EXCHANGE_LOGIN => 'Game\Model\Activity\TaskExchangeLoginModel',
        self::TASK_FESTIVAL_REWARD => 'Game\Model\Activity\FestivalRewardModel',
        self::SEASON_STATUS => 'Game\Model\Season\SeasonStatusModel',
        self::TASK_LIMIT_ACTIVITY => 'Game\Model\Task\Manager\LimitActivityTaskManager',

    );

    public const MODE_MAP = [
        GameConstantDefine::MATCH_MODE_SINGLE_PRACTISE => self::SINGLE_PRACTICE,
        GameConstantDefine::MATCH_MODE_TEAM_PRACTISE => self::TEAM_PRACTICE,
        GameConstantDefine::MATCH_MODE_SINGLE_PAI_WEI => self::SINGLE_RANKING,
        GameConstantDefine::MATCH_MODE_TEAM_PAI_WEI => self::TEAM_RANKING,
        GameConstantDefine::MATCH_MODE_SINGLE => self::ROOM_CUSTOMIZE_SINGLE,
        GameConstantDefine::MATCH_MODE_TEAM => self::ROOM_CUSTOMIZE_TEAM,
        GameConstantDefine::MATCH_MODE_PRACTICE => self::ROOM_CUSTOMIZE_PRACTICE,
        GameConstantDefine::MATCH_MODE_SCUFFLE => self::TEAM_SCUFFLE,
    ];

    public function getModelName(int $id): string
    {
        $modelList = Utils::arrMerge(
            self::MODEL_MAP_COMMON,
            self::MODEL_MAP1,
            self::MODEL_MAP2,
            self::MODEL_MAP3
        );
        if (!array_key_exists($id, $modelList)) {
            return "";
        }
        return $modelList[$id];
    }

}
