<?php

/**
 * 游戏内错误码
 */

namespace Game\Constant;

class GameErrorCode
{

    /**
     * pvp packet 格式错误
     */
    public const PVP_PACKET_ERROR = 1;

    public const TEMPLATE_ID_NOT_FOUND = 2;

    public const MAIL_STATUS_ERROR = 3; //邮件状态错误
    public const MAIL_ADD_ENCLOSURE_ERROR = 4;  //邮件添加附件错误
    public const MAIL_NOT_EXIST = 5;    //邮件不存在
    public const MAIL_TPL_NOT_EXIST = 6; //邮件模板不存在
    public const COMMON_MAIL_UPDATE_INDEX_ERROR = 7;    //系统邮件 更新索引失败
    public const COMMON_MAIL_CREATE_NEW_MAIL_ERROR = 8; //创建系统邮件失败
    public const COMMON_MAIL_SEARCH_ERROR = 9;      //系统邮件 查询失败
    public const COMMON_MAIL_DEL_ERROR = 10;      //系统邮件 查询失败
    public const COMMON_DATA_UPDATE_ERROR = 11;  //更新系统模块索引失败
    public const COMMON_DATA_GET_ERROR = 12;  //获取系统模块索引失败
    public const COMMON_TIMER_ADD_ERROR = 13;   //系统定时 添加失败
    public const COMMON_TIMER_DEL_ERROR = 14;   //系统定时 删除失败
    public const COMMON_TIMER_SEARCH_ERROR = 15;    //系统定时 查询失败
    public const COMMON_TIMER_DATA_ERROR = 16;    //系统定时 数据错误

    public const TIMER_EXPIRE_DATA_ERROR = 20;  //过期时间 数据格式错误
    public const COMMON_TIMER_EXPIRE_DATA_ERROR = 21;  //系统过期时间 数据格式错误
    public const COMMON_SEASON_ADD_DATA_ERROR = 22;     //更新赛季 保存数据错误
    public const COMMON_SEASON_TIME_ERROR = 23;     //赛季时间错误
    public const COMMON_SEASON_NOT_FOUND_NEXT_SEASON = 24;  //未找到下个赛季
    public const COMMON_SEASON_WEEK_ERROR = 19;     //赛季周错误

    public const CONFIG_ERROR = 17; //配置错误
    public const SHM_CACHE_ERROR =  4;    //共享内存错误

    //shop
    public const SHOP_CONFIG_NOT_FOUND = 18;        //商城配置未找到
    public const SHOP_NOT_FOUND_MODEL = 25;         //未找到对应model
    public const SHOP_TITLE_KEY_ERROR = 26;         //商城过期时间key错误
    public const SHOP_OPEN_TIME_CONFIG_ERROR = 27;  //商城开启时间表错误
    public const SHOP_OPEN_TIME_ITEMS_NOT_FOUND = 28;   //商城开启时间表对应商城道具id不存在
    public const SHOP_BLIND_BOX_LOTTERY_ERROR = 43; //抽奖错误,没有抽到道具
    //活动
    public const ACTIVITY_CONFIG_NOT_FOUND = 29;    //活动配置不存在
    public const ACTIVITY_SCUFFLE_ROLL_CAR_ERROR = 30;  //大乱斗随机车错误

    public const MATCH_SETTLEMENT_ERROR = 40;    //比赛结算错误
    public const MATCH_TEAM_RANK_SAME_ERROR = 41;           //组队比赛 有人排名相同

    public const PAI_WEI_DATA_ERROR = 60;    //排位信息错误
    public const SEASON_ID_NOT_FOUND = 61;      //赛季id未找到

    public const RANK_SYNC_RANK_FULL_GET_SEASON_FAILED = 70;  // 全服排位 更新获取赛季失败

    public const ROLE_MODEL_NOT_FOUND = 30;
    /**
     * 角色创建错误
     */
    public const CREATE_ROLE_ERROR = 31;

    public const SEARCH_ROLE_ERROR = 32;

    public const UPDATE_ROLE_ERROR = 33;
    /**
     * 在线
     */
    public const UPDATE_ON_LINE_ERROR = 34;
    public const SEARCH_ON_LINE_ERROR = 35;

    //好友
    public const FRIEND_INTIMACY_APPLY_DATA_ERROR = 50; //好友申请数据错误

    public const SEARCH_CONFIG_INFO_FAILED = 200;

    public const DATA_CREATE_ERROR = 201;
    public const DATA_UPDATE_ERROR = 202;
    public const DATA_DELETE_ERROR = 203;
    public const DATA_SEARCH_ERROR = 204;
    public const DATA_NOTICE_SERVICE_ERROR = 205;  // 通知消息服存储失败


    public const ITEM_SUB_FAILED   = 300;
    public const ITEM_SAVE_FAILED  = 301;
    public const ITEM_SEARCH_INFO_FAILED  = 302;
    public const ITEM_VERIFY_CHECK_FAILED = 303;

    public const SKILL_SEARCH_INFO = 350;

    public const BUFF_SAVE_FAILED = 400;
    public const BUFF_SEARCH_INFO_FAILED = 401;
    public const BUFF_VERIFY_CHECK_FAILED = 402;

    public const CAR_DATA_GET_FAILED = 450;


    public const ROOM_MODE_TYPE_NOT_OPEN = 600;
    public const ROOM_SEARCH_OFFLINE_ERROR = 601;

    //任务
    public const TASK_ID_NOT_FOUND = 500;   //任务id不存在
    public const TASK_NOT_FOUND_LOGIC = 501;  //任务条件未找到处理model
    public const TASK_NOT_FOUND_IN_DB = 502;  //任务不不存
    public const TASK_NOT_FOUND_EVENT = 503;    //任务找不到对应的事件
    public const TASK_DAILY_NOT_FOUND = 504;    //日常任务不存在
    public const TASK_DAILY_CREATE_ERROR = 505; //日常任务创建失败
    public const TASK_DEL_ERROR = 506;  //删除任务错误
    public const TASK_RESET_ERROR = 507;  //重置任务错误
    public const TASK_STATUS_ERROR = 508;   //任务状态错误
    public const TASK_MAIN_CREATE_ERROR = 509;  //主线任务创建失败
    public const TASK_MAIN_GET_ERROR = 510;     //查询主线任务错误
    public const TASK_BRANCH_CREATE_ERROR = 511;    //支线人创建失败
    public const TASK_BRANCH_CAR_NOT_FOUND = 512;   //没有对应车的支线任务
    public const TASK_SEASON_CREATE_ERROR = 513;    //战令任务创建失败
    public const TASK_SEASON_NOT_FOUND = 514;       //战令任务不存在
    public const TASK_WELFARE_WEEK_NOT_FOUND = 515;       //福利周任务不存在
    public const TASK_WELFARE_WEEK_CREATE_ERROR = 515;       //福利周任务创建失败
    public const TASK_DAILY_CHALLENGE_REFRESH_FAIL = 516;   //日常挑战任务刷新失败
    public const TASK_CONFIG_NOT_FOUND = 517;       //任务配置不存在
    public const TASK_CREATE_ERROR = 518;   //任务创建失败

    //事件
    public const EVENT_TRIGGER_MODEL_NOT_FOUND = 550;   //事件触发对应model不存在

    public const CREATE_CAR_BUG_NOT_OPEN = 600;
}
