<?php

/**
 * 游戏内定义的常量
 */

namespace Game\Constant;

class GameConstantDefine
{
    public const DBPacketAnalyseKey_1 = "@";
    public const DBPacketAnalyseKey_2 = "|";
    public const DBPacketAnalyseKey_3 = "#";
    public const DBPacketAnalyseKey_4 = "^";
    public const DBPacketAnalyseKey_5 = "*";

    //PVP Packet TypeId
    public const MatchingResultToPlayer = 2;   // 匹配结果
    public const RaceResultToPlayer = 3;       // 比赛结果
    public const CancelMatch = 5;       // 比赛结果

    public const DBKEY_COMPETE_SERVER_MATCH = "JoinPvp";
//    public const DBKEY_CANCEL_MATCH = "CancelMatch";
    public const DBKEY_COMPETE_SERVER_PROXY = "MatchRet";


    //创建Role的Step标记
    public const initRole = 0;         // 初始化
    public const roleSelectModel = 1;  // 选择形象
    public const roleInputName = 3;    // 输入昵称
    public const roleSelectCar = 4;    // 选车

    // 注册流程完毕
    public const STEP_COMPLETE = 9;

    //玩家状态
    public const PLAYER_STATUS_OFFLINE = 0; //离线
    public const PLAYER_STATUS_ONLINE = 1;  //在线
    public const PLAYER_STATUS_GAMING = 2;  //比赛中
    public const PLAYER_STATUS_MATCH = 3;   //匹配中
    public const PLAYER_STATUS_ROOM = 4;    //房间内

    //生成AI最大数量
    public const AI_PLAYER_MAX_ID = 1000;
    //打点日志 CLI记录间隔
    public const POINT_LOG_GAP_TIME = 60;

    //心跳检查状态更新时间间隔
    public const SYNC_CHECK_TIME = 60;

    //比赛模式 对应CompetitionMode表
    public const MATCH_MODE_SINGLE_PRACTISE = 1; // 单人练习
    public const MATCH_MODE_TEAM_PRACTISE = 2;   // 组队练习
    public const MATCH_MODE_SINGLE_PAI_WEI = 3;  // 单人排位
    public const MATCH_MODE_TEAM_PAI_WEI = 4;    // 组队排位
    public const MATCH_MODE_MPA_CHALLENGE = 5;   // 地图挑战
    // 自定义房间
    public const MATCH_MODE_SINGLE = 8;          // 个人模式
    public const MATCH_MODE_TEAM = 9;            // 团队模式
    public const MATCH_MODE_PRACTICE = 10;       // 练图模式
    //大乱斗
    public const MATCH_MODE_SCUFFLE = 11;

    // 需要统计的赛季记录包含比赛模式
    public const SEASON_STATISTICS_MAP = [
        self::MATCH_MODE_SINGLE_PRACTISE,
        self::MATCH_MODE_TEAM_PRACTISE,
        self::MATCH_MODE_SINGLE_PAI_WEI,
        self::MATCH_MODE_TEAM_PAI_WEI,
    ];

    //组队模式的比赛
    public const TEAM_MATCH_TYPE = array(
        self::MATCH_MODE_TEAM_PRACTISE,
        self::MATCH_MODE_TEAM_PAI_WEI,
        self::MATCH_MODE_TEAM,
        self::MATCH_MODE_SCUFFLE,
    );

    //比赛结算破记录的模式
    public const BREAKING_RECORD_MATCH_TYPE  =array(
        self::MATCH_MODE_SINGLE_PRACTISE,
        self::MATCH_MODE_TEAM_PRACTISE,
        self::MATCH_MODE_SINGLE_PAI_WEI,
        self::MATCH_MODE_TEAM_PAI_WEI,
    );

    // 聊天查询的房间类型map
    public const IM_FIND_ROOM_TYPE_MAP = [
        self::MATCH_MODE_SINGLE_PRACTISE,
        self::MATCH_MODE_TEAM_PRACTISE,
        self::MATCH_MODE_SINGLE_PAI_WEI,
        self::MATCH_MODE_TEAM_PAI_WEI,
        self::MATCH_MODE_SCUFFLE,
    ];

    //赛车改装件params替换key
    public const CAR_EXTERIOR_REFIT_REPLACE_KEY = "ParentID";
    //赛车改装件params格式
    public const CAR_EXTERIOR_REFIT_PARAMS = array(
        "ParentID" => "",   //替换为改装件Id(Appearance表Id)
        "Params" => "",     //下面全部参数不需要改动
        "Scale" => [],
        "Rotation" => [],
        "Position" => [],
        "CameraPosition" => [],
        "CameraRotation" => []
    );

    //获取亲密度途径
    public const INTIMACY_SOURCE_PLAY_GAME = 1; //组队比赛
    public const INTIMACY_SOURCE_LIKE = 2;      //点赞
    public const INTIMACY_SOURCE_SEND_GIFT = 3; //送礼
    public const INTIMACY_SOURCE_ZL_GIFT = 4;   //战令送礼

    //事件触发参数key
    public const EVENT_KEY_NUM = "Num";     //次数
    public const EVENT_KEY_CAR_ID = "CarId";    //车模板id
    public const EVENT_KEY_NEW_CAR = "NewCar";  //是否新车
    public const EVENT_KEY_TASK_ID = "TaskId";  //任务id
    public const EVENT_KEY_MATCH_OPERATION = "MatchOperation";  //比赛操作
    public const EVENT_KEY_PVP_OPERATION = "PVPTaleTarget";  //比赛操作
    public const EVENT_KEY_MATCH_RECORD = "MatchRecord";        //比赛记录
    public const EVENT_KEY_MATCH_TIME = "MatchTime";
    public const EVENT_KEY_MATCH_MAP = "MatchMap";
    public const EVENT_KEY_MATCH_TYPE = "MatchType";    //比赛模式
    public const EVENT_KEY_MATCH_RANK = "MatchRank";    //比赛名次
    public const EVENT_KEY_MATCH_WIN = "MatchWin";      //比赛胜负
    public const EVENT_KEY_MVP = "MVP";                 // mvp
    public const EVENT_KEY_RACE_ICON = "RaceIcon";      //战术(竞速)徽章
    public const EVENT_KEY_JAM_ICON = "JamIcon";        //进攻(干扰)徽章
    public const EVENT_KEY_HELP_ICON = "HelpIcon";      //辅助徽章
    public const EVENT_KEY_CAR_REFIT_SYS_ID = "CarRefitSysId";     //赛车改造/外观改装类型Id
    public const EVENT_KEY_LIKE_FROM = "LikeFrom";      //点赞来源
    public const EVENT_VALUE_LIKE_FRIEND = "FromFriend";    //好友点赞
    public const EVENT_VALUE_LIKE_MATCH = "FromMatch";    //对局点赞
    public const EVENT_VALUE_LIKE_PLAYER_ID = "TargetId";   //点赞对方Id
    public const EVENT_KEY_SEND_GIFT_FROM = "GiftFrom";      //送礼来源
    public const EVENT_VALUE_SEND_GIFT_FRIEND = "FromFriend";    //好友送礼
    public const EVENT_VALUE_SEND_GIFT_MATCH = "FromMatch";    //对局送礼
    public const EVENT_KEY_INVITED_PLAYER = "InvitedPlayer";    //邀请比赛的玩家
    public const EVENT_KEY_COMP_TASK_TYPE = "CompTaskType";     //完成任务类型 [类型=>数量]
    public const EVENT_KEY_ITEM_ID = "ItemId";          //道具id
    public const EVENT_KEY_FRIEND_IDS = "FriendIds";    //好友Id
    public const EVENT_KEY_PVE_LEVEL_ID = "LevelId";    //pve关卡Id
    public const EVENT_KEY_PAI_WEI_LEVEL = "PaiWeiLevel";   //段位
    public const EVENT_KEY_PLAYER_LEVEL = "PlayerLevel";    //玩家等级
    public const EVENT_KEY_MONEY = "Money"; //货币Id

    //PVPTips表Id对应徽章
    public const PVP_TIPS_2_ICON = array(
        5 => self::EVENT_KEY_RACE_ICON,  //战术金牌
        9 => self::EVENT_KEY_JAM_ICON, //进攻金牌
        13 => self::EVENT_KEY_HELP_ICON, //辅助金牌
    );

    //CommonConst表key
    public const COMMON_KEY_SEASON_WEEK = "SeasonWeek"; //赛季第x周
    public const COMMON_KEY_SEASON_ID = "SeasonId";       //赛季
    public const COMMON_KEY_SEASON_STATUS = "SeasonStatus"; //赛季状态
    public const COMMON_KEY_ACTIVITY_MAP_CHALLENGE = "MapChallengeId";  //地图挑战赛活动id
    public const COMMON_KEY_ACTIVITY_MAP_CHALLENGE_MAP = "MapChallengeMap"; //地图挑战赛活动当前开启地图
    public const COMMON_KEY_ACTIVITY_MAP_CHALLENGE_STATUS = "MapChallengeStatus"; //地图挑战赛活动当前状态--ActivityDefine状态
    public const COMMON_KEY_ACTIVITY_MAP_CHALLENGE_START_TIME = "MapChallengeStartTime";
    public const COMMON_KEY_ACTIVITY_MAP_CHALLENGE_END_TIME = "MapChallengeEndTime";
    public const COMMON_KEY_ROLE_ID_VERSION = "LoadRolesVersion";   //生成roleId版本
    public const COMMON_KEY_ACTIVITY_SCUFFLE = "ScuffleId";     //大乱斗活动id
    public const COMMON_KEY_ACTIVITY_SCUFFLE_STATUS = "ScuffleStatus"; //大乱斗活动当前状态--ActivityDefine状态
    public const COMMON_KEY_ACTIVITY_SCUFFLE_START_TIME = "ScuffleStartTime";
    public const COMMON_KEY_ACTIVITY_SCUFFLE_END_TIME = "ScuffleEndTime";

    public const SEASON_STATUS_OPEN = 1;    //赛季开启中
    public const SEASON_STATUS_CLOSE = 2;    //赛季关闭

    //Protobuf TaleTarget 获取方法
    public const TALE_TARGET_TYPE_METHOD = array(
        //通用操作
        TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_1_NUM_COMMON => "getSpray1Num",    //小喷次数
        TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_2_NUM_COMMON => "getSpray2Num",    //双喷次数
        TaskLogicDefine::TASK_CONDITION_MATCH_N2_NUM_COMMON => "getN2Num",        //氮气次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_NUM_COMMON => "getDriftNum",     //漂移次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_RANGE_COMMON => "getDriftRange",   //漂移距离
        TaskLogicDefine::TASK_CONDITION_MATCH_OVER_TAKE_NUM_COMMON => "getOverTakeNum",  //超车次数
        TaskLogicDefine::TASK_CONDITION_MATCH_SKILL_NUM_COMMON => "getSkillNum",     //技能次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIVING_RANGE_COMMON => "getDrivingRange", //行驶距离
        TaskLogicDefine::TASK_CONDITION_MATCH_JAM_SKILL_NUM_COMMON => "getJamSkillNum",  //干扰技能次数
        TaskLogicDefine::TASK_CONDITION_MATCH_HELP_SKILL_NUM_COMMON => "getHelpSkillNum", //辅助技能次数
        //pve操作
        TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_TIME => "getCostTime",   //指定时间完成比赛
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_1_NUM => "getDrift1Num",    //刹车漂移次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_1_RANGE => "getDrift1Range",  //刹车漂移距离
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_2_NUM => "getDrift2Num",    //直线漂移次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_2_RANGE => "getDrift2Range",  //直线漂移距离
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_3_NUM => "getDrift3Num",    //惯性漂移次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_3_RANGE => "getDrift3Range",  //惯性漂移距离
        TaskLogicDefine::TASK_CONDITION_MATCH_QUICK_CURVE_NUM => "getQuickCornesNum", //快速出弯
        TaskLogicDefine::TASK_CONDITION_MATCH_AI_RANGE => "getAiRange",      //与指定AI距离,正数为超过AI,负数为落后AI
        TaskLogicDefine::TASK_CONDITION_MATCH_LAST_TIME => "getLastTime",   //剩余时间
        TaskLogicDefine::TASK_CONDITION_MATCH_DOUBLE_SPRAY_NUM => "getNitro1Num",   //叠喷次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_DOUBLE_SPRAY_NUM => "getDoubleJet1Num",   //小飘双喷次数
        TaskLogicDefine::TASK_CONDITION_MATCH_ADVANCE_DOUBLE_SPRAY_NUM => "getNitro4Num",   //进阶叠喷次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DOUBLE_SPRAY_LAST_NUM => "getNitro2Num",   //叠喷延续次数
        TaskLogicDefine::TASK_CONDITION_MATCH_ADVANCE_DOUBLE_SPRAY_LAST_NUM => "getNitro3Num",   //进阶叠喷延续次数
        TaskLogicDefine::TASK_CONDITION_MATCH_RESET_NUM => "getPassiveResetNum",   //被动重置次数
        TaskLogicDefine::TASK_CONDITION_MATCH_HIT_NUM => "getHitNum",    //碰撞次数
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_4_NUM => "getDrift4Num",    //反向漂移次数
        TaskLogicDefine::TASK_CONDITION_MATCH_AIR_JET_NUM => "getAirJetNum",    //空喷次数
        TaskLogicDefine::TASK_CONDITION_MATCH_GROUND_JET_NUM => "getGroundJetNum",    //落地喷次数
    );

    //替换邮件内容Key
    public const MAIL_KEY_OTHER_NAME = "OtherName";         //对方昵称
    public const MAIL_KEY_PLAYER_NAME = "PlayerName";       //自己昵称
    public const MAIL_KEY_INTIMACY_TYPE = "IntimacyType";   //亲密关系Id
    public const MAIL_KEY_ITEM_ID = "ItemID";               //道具Id
    public const MAIL_KEY_ACCOUNT = "Account";              // 账号
    public const MAIL_KEY_PASSWORD = "Password";            // 密码


    //生涯条件判断方法
    private const TALE_TARGET_FUNC_LESS_THEN = "taleTargetLessThen";
    private const TALE_TARGET_FUNC_GREATER_THEN = "taleTargetGreaterThen";
    private const TALE_TARGET_FUNC_AI_RANGE = "taleTargetAIRange";
    private const TALE_TARGET_FUNC_RANK_IN_3 = "taleTargetRankIn3";
    private const TALE_TARGET_FUNC_RANK_IN_2 = "taleTargetRankIn2";
    private const TALE_TARGET_FUNC_RANK_IN_1 = "taleTargetRankIn1";

    public const TALE_TARGET_DEAL_FUNC = array(
        TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_TIME => self::TALE_TARGET_FUNC_LESS_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_COMPLETE_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_3_COMMON => self::TALE_TARGET_FUNC_RANK_IN_3,
        TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_2_COMMON => self::TALE_TARGET_FUNC_RANK_IN_2,
        TaskLogicDefine::TASK_CONDITION_MATCH_RANK_TOP_1_COMMON => self::TALE_TARGET_FUNC_RANK_IN_1,
        TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_1_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_SPRAY_2_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_N2_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_RANGE_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_OVER_TAKE_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_SKILL_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIVING_RANGE_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_JAM_SKILL_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_HELP_SKILL_NUM_COMMON => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_1_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_1_RANGE => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_2_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_2_RANGE => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_3_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_3_RANGE => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_QUICK_CURVE_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_AI_RANGE => self::TALE_TARGET_FUNC_AI_RANGE,
        TaskLogicDefine::TASK_CONDITION_MATCH_LAST_TIME => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DOUBLE_SPRAY_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_DOUBLE_SPRAY_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_ADVANCE_DOUBLE_SPRAY_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DOUBLE_SPRAY_LAST_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_ADVANCE_DOUBLE_SPRAY_LAST_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_RESET_NUM => self::TALE_TARGET_FUNC_LESS_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_HIT_NUM => self::TALE_TARGET_FUNC_LESS_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_DRIFT_4_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_AIR_JET_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
        TaskLogicDefine::TASK_CONDITION_MATCH_GROUND_JET_NUM => self::TALE_TARGET_FUNC_GREATER_THEN,
    );

    //道具来源
    public const ITEM_ADD_SOURCE_GM = 1;    //GM
    public const ITEM_ADD_SOURCE_CONVERTED = 2; //道具折算
    public const ITEM_ADD_SOURCE_MAIL = 3;  //邮件
    public const ITEM_ADD_SOURCE_CLUB = 4; //俱乐部战令领取
    public const ITEM_ADD_SOURCE_CLUB_SHOP = 5; //俱乐部商店购买
    public const ITEM_ADD_SOURCE_CAR_SHOP = 6;  //赛车商店购买
    public const ITEM_ADD_SOURCE_ITEM_SHOP = 7; //道具商店购买
    public const ITEM_ADD_SOURCE_SEASON_SHOP = 8;   //赛季商店购买
    public const ITEM_ADD_SOURCE_ZL_SHOP = 9;   //战令商店购买
    public const ITEM_ADD_SOURCE_CAR_LV_UP_REWARD = 10; //升级赛车奖励
    public const ITEM_ADD_SOURCE_7_DAY_REWARD = 11; //7日奖励
    public const ITEM_ADD_SOURCE_LOGIN_REWARD = 12; //登录奖励
    public const ITEM_ADD_SOURCE_GUEST_BIND_REWARD = 13;    //游客账号绑定
    public const ITEM_ADD_SOURCE_OPEN_GIFT = 14;    //开礼包
    public const ITEM_ADD_SOURCE_CAR_PROFICIENCY_REWARD = 15;   //车熟练度奖励
    public const ITEM_ADD_SOURCE_ZL_REWARD = 16;    //战令奖励
    public const ITEM_ADD_SOURCE_MAP_CHALLENGE_REWARD = 17; //地图挑战赛奖励
    public const ITEM_ADD_SOURCE_CAREER_STAR_REWARD = 18;   //生涯星级奖励
    public const ITEM_ADD_SOURCE_CAR_LICENSE_REWARD = 19;  //驾照奖励
    public const ITEM_ADD_SOURCE_CAR_PERMIT_REWARD = 20;   //行驶证奖励
    public const ITEM_ADD_SOURCE_TEACH_SKILL_REWARD = 21;   //技巧教学奖励
    public const ITEM_ADD_SOURCE_CLOTH_SHOP = 22;   //服装商店购买道具
    public const ITEM_ADD_SOURCE_ACTIVE_REWARD = 23;    //活跃度奖励
    public const ITEM_ADD_SOURCE_TASK = 24; //任务奖励
    public const ITEM_ADD_SOURCE_FRIEND_INTIMACY_REWARD = 25;   //好友亲密度活动奖励
    public const ITEM_ADD_SOURCE_GROW_UP_REWARD = 26;   //成长任务奖励
    public const ITEM_ADD_SOURCE_SEASON_REWARD = 27;    //赛季奖励
    public const ITEM_ADD_SOURCE_PVP_SETTLEMENT = 28;   //pvp结算奖励
    public const ITEM_ADD_SOURCE_CAREER_LEVEL = 29; //生涯关卡奖励
    public const ITEM_ADD_SOURCE_EXCHANGE_TREASURE_TICKET = 30; //兑换10连抽券
    public const ITEM_ADD_SOURCE_SHOP_BLIND_BOX = 31;   //抽奖
    public const ITEM_ADD_SOURCE_SHOP_RECOMMEND = 31;   //推荐商店

    //道具消耗来源
    public const ITEM_CONSUME_SOURCE_BUY_ZL_LV = 1001; //购买战令等级
    public const ITEM_CONSUME_SOURCE_APPLY_INTIMACY = 1002;    //申请建立亲密关系
    public const ITEM_CONSUME_SOURCE_CAR_LV_UP = 1003; //升级赛车消耗
    public const ITEM_CONSUME_SOURCE_CAR_REFIT = 1004; //强化赛车消耗
    public const ITEM_CONSUME_SOURCE_USE_ITEM = 1005;  //使用道具
    public const ITEM_CONSUME_SOURCE_BUY_CLUB_SHOP = 1006;  //俱乐部商店购买
    public const ITEM_CONSUME_SOURCE_BUY_CAR_SHOP = 1007;//赛车商店购买
    public const ITEM_CONSUME_SOURCE_BUY_ITEM_SHOP = 1008;//道具商店购买
    public const ITEM_CONSUME_SOURCE_BUY_SEASON_SHOP = 1009;//赛季商店购买
    public const ITEM_CONSUME_SOURCE_BUY_ZL_SHOP = 1010;//战令商店购买
    public const ITEM_CONSUME_SOURCE_BUY_CLOTH_SHOP = 1011;//服装商店购买道具
    public const ITEM_CONSUME_SOURCE_CHANGE_NICKNAME = 1012;  //改名
    public const ITEM_CONSUME_SOURCE_PAI_WEI_GUARD = 1013;    //排位保护
    public const ITEM_CONSUME_SOURCE_CREATE_CLUB = 1014;    //创建俱乐部
    public const ITEM_CONSUME_SOURCE_EXCHANGE_TREASURE_TICKET = 1015; //兑换10连抽券
    public const ITEM_CONSUME_SOURCE_SHOP_BLIND_BOX = 1016;   //抽奖
    public const ITEM_CONSUME_SOURCE_SHOP_RECOMMEND = 1017;   //推荐商店


    //双倍金币的道具来源--比赛获得
    public const DOUBLE_GOLD_ADD_SOURCE = array(
        self::ITEM_ADD_SOURCE_CAR_LICENSE_REWARD,
        self::ITEM_ADD_SOURCE_CAR_PERMIT_REWARD,
        self::ITEM_ADD_SOURCE_TEACH_SKILL_REWARD,
        self::ITEM_ADD_SOURCE_PVP_SETTLEMENT,
        self::ITEM_ADD_SOURCE_CAREER_LEVEL,
    );
}
