<?php

namespace Game\Constant;

use Framework\Define\DBDefine;
use Framework\Define\RedisLinkDefine;
use Game\Config\GameConfig;

class DBTableDefine extends DBDefine
{
    public const TABLE_COMMON  = 1;
    public const TABLE_ACCOUNT = 2;
    public const TABLE_ITEM    = 3;
    public const TABLE_PAIWEI_LEVEL = 4;
    public const TABLE_TIMER = 5;
    public const TABLE_PACKET_CACHE = 7;
    public const TABLE_PVP = 8;
    public const TABLE_MAP_STATISTICS = 9;  //地图结算统计信息
    public const TABLE_ACTIVE = 10;     //活跃度
    public const TABLE_TASK_DAILY_CHALLENGE = 11;   //日常挑战任务
    public const TABLE_MAIL = 12;
    public const TABLE_RECORD_COLLECTION = 13;  //比赛记录收藏
    public const TABLE_CAR = 14;
    public const TABLE_COMMON_TIMER = 15;
    public const TABLE_COMMON_DATA = 16;
    public const TABLE_COMMON_MAIL = 17;
    public const TABLE_SEASON_STATISTICS = 18;  //玩家赛季信息统计
    public const TABLE_COMMON_ROLES_ID = 19;
    public const TABLE_RECORD = 20; //比赛记录
    public const TABLE_COMMON_CONST = 21; //服务器的常量字段表
    public const TABLE_FRIENDS = 22; //好友列表
    public const TABLE_COMMON_FRIENDS = 23; //随机好友公共数据
    public const TABLE_ONLINE = 24;  //玩家在线离线数据
    public const TABLE_NOTICE = 25; //玩家在线通知表
    public const TABLE_CAREER_CHAPTER = 26; //生涯章节
    public const TABLE_CAREER_LEVEL = 27;   //生涯关卡
    public const TABLE_EVENT = 30;
    public const TABLE_TASK_DAILY = 31;
    public const TABLE_TASK_MAIN = 32;
    public const TABLE_TASK_BRANCH = 33;
    public const TABLE_TASK_SEASON = 34;    //战令任务
    public const TABLE_ROOM = 35;               // 房间
    public const TABLE_CANCEL_MATCH = 37;       // 取消匹配
    public const TABLE_PVE_LEVEL = 38;  //pve关卡
    public const TABLE_PVE_EXAM = 39;   //pve驾照考试
    public const TABLE_ROOM_TIME = 40;  // 房间过期检测用表
    public const TABLE_EXTERIOR_REFIT = 42;       // 外观改装
    public const TABLE_LIKES = 43;   //点赞表
    public const TABLE_EVENT_POOLED = 44;   //事件条件汇总
    public const TABLE_CLUB = 45;   // 俱乐部
    public const TABLE_CLUB_NAME = 46;   // 俱乐部名称表 name => clubID
    public const TABLE_CLUB_SEARCH = 47;   // 俱乐部查询表 state{1,2} clubID
    public const TABLE_CLUB_PLAYER = 48;   // 玩家所在俱乐部的信息
    public const TABLE_RANK = 49;   // 排行表
    public const TABLE_FULL_SERVER_CONST = 50;   // 全服常量表
    public const TABLE_CLUB_CREATE_TIME_AND_ACTIVE = 51;  //俱乐部创建时间.活跃度表 {key:clubId score:createTime.active}
    public const TABLE_CLUB_BATTLE_PASS = 52;   // 俱乐部的战令表
    public const TABLE_CLUB_STORE_RECORD = 53;   // 俱乐部购买记录表
    public const TABLE_CLUB_BUY_STORE_LAST_TIME = 54;   // 俱乐部购买道具最后时间
    public const TABLE_DRIVING_PERMIT = 55;     //行驶证车辆关卡完成数
    public const TABLE_SERVICE_PACK = 56;   // 服务器通信取数据
    public const TABLE_SERVICE_REGISTER = 57;
    public const TABLE_RANKING        = 58; // 排行榜
    public const TABLE_RANKING_INFO   = 59; // 排行榜信息
    public const TABLE_RANK_SYNC_TIME = 60; // 玩家排行榜时间更新 (login time)
    public const TABLE_RANK_CACHE     = 61; // 排行榜缓存
    public const TABLE_RANK_LIKE      = 62; // 排行榜点赞
    public const TABLE_RANK_BE_LIKED  = 63; // 排行榜被点赞
    public const TABLE_AI_PLAYER = 64;
    public const TABLE_SHOP_ITEM = 66;      //道具商城
    public const TABLE_ACTIVITY_MAP_CHALLENGE = 67;   //地图挑战赛
    public const TABLE_ROOM_CUSTOMIZE = 68;   // 自定义房间
    public const TABLE_ROOM_CUSTOMIZE_TIME = 69;   // 自定义房间
    public const TABLE_ROOM_SCUFFLE = 70;   //大乱斗房间
    public const TABLE_ROOM_SCUFFLE_TIME = 71;  //大乱斗房间时间
    public const TABLE_SHOP_SEASON = 72;    //赛季商城
    public const TABLE_WELFARE = 73;    //赛季商城
    public const TABLE_TASK_WELFARE_WEEK = 74;
    public const TABLE_WAR_TOKEN = 75;  //战令
    public const TABLE_SHOP_ZL = 76;  // 战令商城
    public const TABLE_LAMP = 77;
    public const TABLE_FRIEND_INTIMACY_APPLY = 78;  //好友亲密关系申请
    public const TABLE_FRIEND_INTIMACY_APPLY_INDEX = 79;    //好友亲密关系申请索引
    public const TABLE_FRIEND_INTIMACY_TASK = 80;   //好友亲密任务
    public const TABLE_TEACHING_SKILL = 81;     //技巧教学章节
    public const TABLE_SHOP_BLIND_BOX = 82;     //抽奖商城
    public const TABLE_TASK_LIMIT_TIME      = 85;   // 限时
    public const TABLE_TASK_LIMIT_TIME_DAY  = 86;   // 限时天
    public const TABLE_TASK_LIMIT_TIME_WEEK = 87;   // 限时周
    public const TABLE_TASK_LIMIT_TIME_DATA = 88;   // 限时任务记录
    public const TABLE_TASK_EXCHANGE_SHOP = 89;     // 兑换商城
    public const TABLE_TASK_EXCHANGE_LOGIN = 90;     // 限时活动累签
    public const TABLE_TASK_FESTIVAL_REWARD = 91;    // 节日活动领取记录
    public const TABLE_PAI_WEI_GOLD = 92;    //排位赛金牌车手名单
    public const TABLE_PAI_WEI_GOLD_RANK = 93;  //排位赛金牌车手排名

    public const TABLE_LIST = array(
        self::TABLE_COMMON  => "Common",
        self::TABLE_ACCOUNT => "Account",
        self::TABLE_ITEM    => "Item",
        self::TABLE_PAIWEI_LEVEL => "PaiweiLevel",
        self::TABLE_TIMER => "Timer",
        self::TABLE_PACKET_CACHE => "PacketCache",
        self::TABLE_MAP_STATISTICS => "MapStatistics",
        self::TABLE_MAIL => "Mail",
        self::TABLE_RECORD_COLLECTION => "RecordCollection",
        self::TABLE_CAR  => "Car",
        self::TABLE_COMMON_MAIL => "CommonMail",
        self::TABLE_COMMON_TIMER => "CommonTimer",
        self::TABLE_COMMON_DATA => "CommonData",
        self::TABLE_SEASON_STATISTICS => "SeasonStatistics",
        self::TABLE_COMMON_ROLES_ID => "CommonRolesId",
        self::TABLE_RECORD => "Record",
        self::TABLE_COMMON_CONST => "CommonConst",
        self::TABLE_FRIENDS => "Friends",
        self::TABLE_COMMON_FRIENDS => "CommonFriends",
        self::TABLE_ONLINE => "OnLine",
        self::TABLE_NOTICE => "Notice",
        self::TABLE_EVENT => "Event",
        self::TABLE_TASK_DAILY => "TaskDaily",
        self::TABLE_TASK_MAIN => "TaskMain",
        self::TABLE_TASK_BRANCH => "TaskBranch",
        self::TABLE_TASK_SEASON => "TaskSeason",
        self::TABLE_ROOM => "Room",                            // 房间表
        self::TABLE_CANCEL_MATCH => "CancelMatch",
        self::TABLE_EXTERIOR_REFIT => "ExteriorRefit",
        self::TABLE_PVE_LEVEL => "PveLevel",
        self::TABLE_PVE_EXAM => "PveExam",
		self::TABLE_ROOM_TIME => "RoomTime",
        self::TABLE_LIKES => "Likes",
        self::TABLE_EVENT_POOLED => "EventPooled",
        self::TABLE_CLUB => "Club",
        self::TABLE_CLUB_NAME => "ClubName",
        self::TABLE_CLUB_SEARCH => "ClubSearch",
        self::TABLE_CLUB_PLAYER => "ClubPlayer",
        self::TABLE_RANK => "Rank",
        self::TABLE_FULL_SERVER_CONST => "FullServerConst",
        self::TABLE_CLUB_CREATE_TIME_AND_ACTIVE => "ClubTimeActive",
        self::TABLE_CLUB_BATTLE_PASS => "ClubBattlePass",
        self::TABLE_CLUB_STORE_RECORD => "ClubStoreRecord",
        self::TABLE_CLUB_BUY_STORE_LAST_TIME => "ClubStoreBuyLastTime",
        self::TABLE_SERVICE_PACK => "pack",
        self::TABLE_SERVICE_REGISTER => "info",
        self::TABLE_DRIVING_PERMIT => "DrivingPermit",
        self::TABLE_AI_PLAYER => "AIPlayer",
        self::TABLE_RANKING => "Ranking",
        self::TABLE_RANKING_INFO => "RankingInfo",
        self::TABLE_RANK_SYNC_TIME => "RankSyncTime",
        self::TABLE_RANK_CACHE => "RankCache",
        self::TABLE_RANK_LIKE => "RankLike",
        self::TABLE_RANK_BE_LIKED => "RankBeLiked",
        self::TABLE_SHOP_ITEM => "ShopItem",
        self::TABLE_ACTIVITY_MAP_CHALLENGE => "MapChallenge",
        self::TABLE_ROOM_CUSTOMIZE => "CustomizeRoom",
        self::TABLE_ROOM_CUSTOMIZE_TIME => "CustomizeRoomTime",
        self::TABLE_ROOM_SCUFFLE => "ScuffleRoom",
        self::TABLE_ROOM_SCUFFLE_TIME => "ScuffleRoomTime",
        self::TABLE_SHOP_SEASON => "ShopSeason",
        self::TABLE_WELFARE => "Welfare",
        self::TABLE_TASK_WELFARE_WEEK => "TaskWelfareWeek",
        self::TABLE_ACTIVE => "Active",
        self::TABLE_TASK_DAILY_CHALLENGE => "TaskDailyChallenge",
        self::TABLE_WAR_TOKEN => "WarToken",
        self::TABLE_SHOP_ZL => "ShopZL",
        self::TABLE_LAMP => "Lamp",
        self::TABLE_FRIEND_INTIMACY_APPLY => "FriendIntimacyApply",
        self::TABLE_FRIEND_INTIMACY_APPLY_INDEX => "FriendIntimacyApplyIndex",
        self::TABLE_FRIEND_INTIMACY_TASK => "TaskFriendIntimacy",
        self::TABLE_TEACHING_SKILL => "TeachingSkill",
        self::TABLE_CAREER_CHAPTER => "CareerChapter",
        self::TABLE_CAREER_LEVEL => "CareerLevel",
        self::TABLE_SHOP_BLIND_BOX => "ShopBlindBox",
        self::TABLE_TASK_LIMIT_TIME => "TaskLimitTime",
        self::TABLE_TASK_LIMIT_TIME_DAY => "TaskLimitTimeDay",
        self::TABLE_TASK_LIMIT_TIME_WEEK => "TaskLimitTimeWeek",
        self::TABLE_TASK_LIMIT_TIME_DATA => "TaskLimitTimeData",
        self::TABLE_TASK_EXCHANGE_SHOP => "TaskExchangeShop",
        self::TABLE_TASK_EXCHANGE_LOGIN => "TaskExchangeLogin",
        self::TABLE_TASK_FESTIVAL_REWARD => "FestivalReward",
        self::TABLE_PAI_WEI_GOLD => "PaiWeiGoldPlayer",
        self::TABLE_PAI_WEI_GOLD_RANK => "PaiWeiGoldRank",
    );

    public const DB_TYPE_PLAYER = 1;        //本服玩家
    public const DB_TYPE_SERVER = 2;        //本服
    public const DB_TYPE_MATCHING = 3;         // 对战匹配
    public const DB_TYPE_FULL_SERVER_CLUSTER = 4;      // 全部服务器cluster
    public const DB_TYPE_FULL_SERVER_SINGLE = 5; // 全部服务器单例
    public const DB_TYPE_SERVICE = 6; // 服务器通信

    public const DB_LOGIC_COMMON_CMD = "CommonCmd";
    public const DB_LOGIC_COMMON_CREATE_TERM = "CommonCreateTerm";
    public const DB_LOGIC_PLAYER_CREATE_TITLE = "PlayerCreateTitle";
    public const DB_LOGIC_PLAYER_SEARCH_TABLE = "PlayerSearchTable";
    public const DB_LOGIC_PLAYER_SEARCH_TITLE_MULTI= "PlayerSearchTitleMulti";
    public const DB_LOGIC_PLAYER_DELETE_TITLE = "PlayerDeleteTitle";
    public const DB_LOGIC_PIPE_PLAYER_CREATE_TITLE = "PipePlayerCreateTitle";

    public const DB_LOGIC_CREATE_ROOM = "CreateRoom";
    public const DB_LOGIC_JOIN_ROOM = "JoinRoom";
    public const DB_LOGIC_EXIT_ROOM = "ExitRoom";

    public const DB_LOGIC_CREATE_ROOM_CUSTOMIZE = "CreateRoomCustomize";
    public const DB_LOGIC_JOIN_ROOM_CUSTOMIZE = "JoinRoomCustomize";
    public const DB_LOGIC_EXIT_ROOM_CUSTOMIZE = "ExitRoomCustomize";

    public const DB_LOGIC_CREATE_CLUB = "CreateClub";
    public const DB_LOGIC_JOIN_CLUB = "JoinClub";
    public const DB_LOGIC_EXIT_CLUB = "ExitClub";

    public const DB_LOGIC_GUEST_BIND = "GuestBind";
    public const DB_LOGIC_REPLACE_NICKNAME = "ReplaceNickname";

    public const DB_LOGIC_CMD_STR_SET = "set";
    public const DB_LOGIC_CMD_STR_GET = "get";
    public const DB_LOGIC_CMD_HGET = "hGet";
    public const DB_LOGIC_CMD_HMSET = "hMSet";
    public const DB_LOGIC_CMD_HGETALL = "hGetAll";
    public const DB_LOGIC_CMD_HLEN = "hLen";
    public const DB_LOGIC_CMD_ZSCORE = "zScore";
    public const DB_LOGIC_CMD_ZRANGE = "zRange";
    public const DB_LOGIC_CMD_ZRANGE_BY_SCORE = "zRangeByScore";
    public const DB_LOGIC_CMD_Z_REV_RANGE = "zRevRange";
    public const DB_LOGIC_CMD_ZADD = "zAdd";
    public const DB_LOGIC_CMD_ZREM = "zRem";
    public const DB_LOGIC_CMD_Z_REM_RANGE_BY_SCORE = "zRemRangeByScore";
    public const DB_LOGIC_CMD_ZCARD = "zCard";
    public const DB_LOGIC_CMD_RPUSH = "rPush";
    public const DB_LOGIC_CMD_LRANGE = "lRange";
    public const DB_LOGIC_CMD_LTRIM = "lTrim";
    public const DB_LOGIC_CMD_LPOP = "lPop";
    public const DB_LOGIC_CMD_LREM = "lRem";
    public const DB_LOGIC_CMD_DEL = "del";
    public const DB_LOGIC_CMD_HMGET = "hMGet";
    public const DB_LOGIC_CMD_HINCRBY = "hIncrBy";
    public const DB_LOGIC_CMD_HDel = "hDel";
    public const DB_LOGIC_CMD_Z_REV_RANGE_BY_SCORE = "zRevRangeByScore";
    public const DB_LOGIC_CMD_HEXISTS = "hExists";
    public const DB_LOGIC_CMD_SREM = "sRem";
    public const DB_LOGIC_CMD_SET = "sAdd";
    public const DB_LOGIC_CMD_SRANDMEMBER = "sRandMember";
    public const DB_LOGIC_CMD_SCARD = "sCard";
    public const DB_LOGIC_CMD_SMEMBERS = "sMembers";
    public const DB_LOGIC_CMD_BR_POP = "BRPop";
    public const DB_LOGIC_CMD_BL_POP = "BLPop";
    public const DB_LOGIC_EXPIRE = "expire";
    public const DB_LOGIC_EXISTS = "exists";

    public const DB_LOGIC_LIST = array(
        self::DB_LOGIC_COMMON_CREATE_TERM => "Framework\DB\DBLogic\CommonCreateTerm",
        self::DB_LOGIC_PLAYER_CREATE_TITLE => "Framework\DB\DBLogic\PlayerCreateTitle",
        self::DB_LOGIC_COMMON_CMD => "Framework\DB\DBLogic\DBLogicRedisCommand",
        self::DB_LOGIC_PLAYER_DELETE_TITLE => "Framework\DB\DBLogic\PlayerDeleteTitle",
        self::DB_LOGIC_CREATE_ROOM => "Framework\DB\DBLogic\CreateRoom",
        self::DB_LOGIC_JOIN_ROOM => "Framework\DB\DBLogic\JoinRoom",
        self::DB_LOGIC_EXIT_ROOM => "Framework\DB\DBLogic\ExitRoom",
        self::DB_LOGIC_CREATE_CLUB => "Framework\DB\DBLogic\CreateClub",
        self::DB_LOGIC_JOIN_CLUB => "Framework\DB\DBLogic\JoinClub",
        self::DB_LOGIC_EXIT_CLUB => "Framework\DB\DBLogic\ExitClub",
        self::DB_LOGIC_CREATE_ROOM_CUSTOMIZE => "Framework\DB\DBLogic\CreateRoomCustomize",
        self::DB_LOGIC_JOIN_ROOM_CUSTOMIZE => "Framework\DB\DBLogic\JoinRoomCustomize",
        self::DB_LOGIC_EXIT_ROOM_CUSTOMIZE => "Framework\DB\DBLogic\ExitRoomCustomize",
        self::DB_LOGIC_GUEST_BIND => "Framework\DB\DBLogic\GuestBind",
        self::DB_LOGIC_REPLACE_NICKNAME => 'Framework\DB\DBLogic\ReplaceNickname',
        self::DB_LOGIC_PIPE_PLAYER_CREATE_TITLE =>"Framework\DB\DBLogic\PipePlayerCreateTitle",
        self::DB_LOGIC_PLAYER_SEARCH_TABLE =>"Framework\DB\DBLogic\PlayerSearchTable",
        self::DB_LOGIC_PLAYER_SEARCH_TITLE_MULTI =>"Framework\DB\DBLogic\PlayerSearchTitleMulti",
    );

    public const DB_TYPE_LIST = array(
        self::DB_TYPE_PLAYER,
        self::DB_TYPE_SERVER,
    );

    public const DB_TABLE_TYPE = array(
        self::TABLE_COMMON => self::DB_TYPE_SERVER,
        self::TABLE_ITEM => self::DB_TYPE_PLAYER,
        self::TABLE_ACCOUNT => self::DB_TYPE_PLAYER,
        self::TABLE_PAIWEI_LEVEL => self::DB_TYPE_PLAYER,
        self::TABLE_TIMER => self::DB_TYPE_PLAYER,
        self::TABLE_PACKET_CACHE => self::DB_TYPE_PLAYER,
        self::TABLE_PVP => self::DB_TYPE_MATCHING,
        self::TABLE_MAP_STATISTICS => self::DB_TYPE_PLAYER,
        self::TABLE_MAIL => self::DB_TYPE_PLAYER,
        self::TABLE_RECORD_COLLECTION => self::DB_TYPE_PLAYER,
        self::TABLE_CAR => self::DB_TYPE_PLAYER,
        self::TABLE_COMMON_MAIL => self::DB_TYPE_SERVER,
        self::TABLE_COMMON_TIMER => self::DB_TYPE_SERVER,
        self::TABLE_COMMON_DATA => self::DB_TYPE_SERVER,
        self::TABLE_SEASON_STATISTICS => self::DB_TYPE_PLAYER,
        self::TABLE_COMMON_ROLES_ID => self::DB_TYPE_SERVER,
        self::TABLE_RECORD => self::DB_TYPE_PLAYER,
        self::TABLE_COMMON_CONST => self::DB_TYPE_SERVER,
        self::TABLE_FRIENDS => self::DB_TYPE_PLAYER,
        self::TABLE_COMMON_FRIENDS => self::DB_TYPE_SERVER,
        self::TABLE_ONLINE => self::DB_TYPE_SERVER,
        self::TABLE_NOTICE => self::DB_TYPE_PLAYER,
        self::TABLE_EVENT => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_DAILY => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_MAIN => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_BRANCH => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_SEASON => self::DB_TYPE_PLAYER,
        self::TABLE_ROOM => self::DB_TYPE_PLAYER,
        self::TABLE_CANCEL_MATCH => self::DB_TYPE_MATCHING,
        self::TABLE_EXTERIOR_REFIT => self::DB_TYPE_PLAYER,
        self::TABLE_PVE_LEVEL => self::DB_TYPE_PLAYER,
        self::TABLE_PVE_EXAM => self::DB_TYPE_PLAYER,
		self::TABLE_ROOM_TIME => self::DB_TYPE_PLAYER,
        self::TABLE_LIKES => self::DB_TYPE_PLAYER,
        self::TABLE_EVENT_POOLED => self::DB_TYPE_PLAYER,
        self::TABLE_CLUB => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_CLUB_NAME => self::DB_TYPE_FULL_SERVER_SINGLE,
        self::TABLE_CLUB_SEARCH => self::DB_TYPE_FULL_SERVER_SINGLE,
        self::TABLE_CLUB_PLAYER => self::DB_TYPE_PLAYER,
        self::TABLE_RANK => self::DB_TYPE_FULL_SERVER_SINGLE,
        self::TABLE_FULL_SERVER_CONST => self::DB_TYPE_FULL_SERVER_SINGLE,
        self::TABLE_CLUB_CREATE_TIME_AND_ACTIVE => self::DB_TYPE_FULL_SERVER_SINGLE,
        self::TABLE_CLUB_BATTLE_PASS => self::DB_TYPE_PLAYER,
        self::TABLE_CLUB_STORE_RECORD => self::DB_TYPE_PLAYER,
        self::TABLE_CLUB_BUY_STORE_LAST_TIME => self::DB_TYPE_PLAYER,
        self::TABLE_SERVICE_PACK => self::DB_TYPE_SERVICE,
        self::TABLE_SERVICE_REGISTER => self::DB_TYPE_SERVICE,
        self::TABLE_DRIVING_PERMIT => self::DB_TYPE_PLAYER,
        self::TABLE_AI_PLAYER => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_RANKING => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_RANKING_INFO => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_RANK_SYNC_TIME => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_RANK_CACHE => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_RANK_LIKE => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_RANK_BE_LIKED => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_SHOP_ITEM => self::DB_TYPE_PLAYER,
        self::TABLE_ACTIVITY_MAP_CHALLENGE => self::DB_TYPE_PLAYER,
        self::TABLE_ROOM_CUSTOMIZE => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_ROOM_CUSTOMIZE_TIME => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_ROOM_SCUFFLE => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_ROOM_SCUFFLE_TIME => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_SHOP_SEASON => self::DB_TYPE_PLAYER,
        self::TABLE_WELFARE => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_WELFARE_WEEK => self::DB_TYPE_PLAYER,
        self::TABLE_ACTIVE => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_DAILY_CHALLENGE => self::DB_TYPE_PLAYER,
        self::TABLE_WAR_TOKEN => self::DB_TYPE_PLAYER,
        self::TABLE_SHOP_ZL => self::DB_TYPE_PLAYER,
        self::TABLE_LAMP => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_FRIEND_INTIMACY_APPLY => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_FRIEND_INTIMACY_APPLY_INDEX => self::DB_TYPE_FULL_SERVER_CLUSTER,
        self::TABLE_FRIEND_INTIMACY_TASK => self::DB_TYPE_PLAYER,
        self::TABLE_TEACHING_SKILL => self::DB_TYPE_PLAYER,
        self::TABLE_CAREER_CHAPTER => self::DB_TYPE_PLAYER,
        self::TABLE_CAREER_LEVEL => self::DB_TYPE_PLAYER,
        self::TABLE_SHOP_BLIND_BOX => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_LIMIT_TIME => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_LIMIT_TIME_DAY => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_LIMIT_TIME_WEEK => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_LIMIT_TIME_DATA => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_EXCHANGE_SHOP => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_EXCHANGE_LOGIN => self::DB_TYPE_PLAYER,
        self::TABLE_TASK_FESTIVAL_REWARD => self::DB_TYPE_PLAYER,
        self::TABLE_PAI_WEI_GOLD => self::DB_TYPE_SERVER,
        self::TABLE_PAI_WEI_GOLD_RANK => self::DB_TYPE_SERVER,
    );

    public function getRedisLinkInfo($id): ?RedisLinkDefine
    {
        switch ($id) {
            case self::DB_TYPE_PLAYER:
                return new RedisLinkDefine(self::MODEL_CLUSTER, "", 0, GameConfig::getInstance()->PLAYER_REDIS_NODE());
            case self::DB_TYPE_SERVER:
                return new RedisLinkDefine(self::MODEL_CLUSTER, "", 0, GameConfig::getInstance()->SERVER_REDIS_NODE());
            case self::DB_TYPE_MATCHING:
                return new RedisLinkDefine(self::MODEL_SINGLE,
                                           GameConfig::getInstance()->MATCHING_REDIS_IP(),
                                           GameConfig::getInstance()->MATCHING_REDIS_PORT(),
                                           array());
            case self::DB_TYPE_FULL_SERVER_CLUSTER:
                return new RedisLinkDefine(
                    self::MODEL_CLUSTER, "", 0, GameConfig::getInstance()->FULL_SERVER_REDIS_NODE()
                );
            case self::DB_TYPE_FULL_SERVER_SINGLE:
                return new RedisLinkDefine(
                    self::MODEL_SINGLE,
                    GameConfig::getInstance()->FULL_SERVER_IP(),
                    GameConfig::getInstance()->FULL_SERVER_PORT(),
                    array());
            case self::DB_TYPE_SERVICE:
                return new RedisLinkDefine(self::MODEL_SINGLE, GameConfig::getInstance()->SERVICE_SERVER_IP()
                    , GameConfig::getInstance()->SERVICE_SERVER_PORT(), []);
        }
        return null;
    }

    public function getTypeByTable(string $table): int
    {
        if (array_key_exists($table, self::DB_TABLE_TYPE)) {
            return self::DB_TABLE_TYPE[$table];
        }
        return 0;
    }

    public function getDBLogicName(string $logic): string
    {
        if (array_key_exists($logic, self::DB_LOGIC_LIST)) {
            return self::DB_LOGIC_LIST[$logic];
        }
        return "";
    }
}
