<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

/**
 * Class TemplateTask
 * @package Game\Constant\ConstTemplate
 * 任务
 */
class TemplateTask extends TemplateDefineBase
{
    public const Id = "Id";
    public const TaskType = "Type";
    public const GroupType = "GroupType";
    public const GroupId = "GroupId";
    public const ConditionType = "ConditionType";   //条件类型
    public const Condition = "Condition";           //特殊条件
    public const Target = "Number";                 //目标
    public const TargetHandle = "Manage";           //数值处理 0累加 1记录最小值 2 记录最大值
    public const Reward = "Reward";
    public const NumReward = "Award";   //特殊奖励 活跃度,战令经验
    public const NextTask = "OpenTask";
    public const EXP = "EXP";   //玩家经验

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::TaskType,
            self::GroupType,
            self::GroupId,
            self::ConditionType,
            self::Condition,
            self::Target,
            self::TargetHandle,
            self::Reward,
            self::NumReward,
            self::NextTask,
            self::EXP,
        );
    }

    //任务类型
    public const TASK_TYPE_DAILY = 1;       //日常
    public const TASK_TYPE_BRANCH = 2;      //支线
    public const TASK_TYPE_MAIN = 3;        //主线
    public const TASK_TYPE_SEASON_WEEK = 4; //战令周
    public const TASK_TYPE_SEASON = 5;      //战令高级
    public const TASK_TYPE_WELFARE_WEEK = 6;       // 福利周任务
    public const TASK_TYPE_DAILY_CHALLENGE = 7; //日常挑战任务
    public const TASK_TYPE_FRIEND_INTIMACY = 8; //好友亲密度任务

    public const TASK_TYPE_LIMIT_TIME = 12; // 限时任务
    public const TASK_TYPE_LIMIT_TIME_DAY = 13; // 限时任务 (天刷)
    public const TASK_TYPE_LIMIT_TIME_WEEK = 14; // 限时任务 （周刷）

    //任务数值处理 0累加 1记录最小值 2 记录最大值
    public const TASK_TARGET_HANDLE_ADD = 0;
    public const TASK_TARGET_HANDLE_MIN = 1;
    public const TASK_TARGET_HANDLE_MAX = 2;

    //支线任务主任务
    public const TASK_BRANCH_MAIN_CONDITION_TYPE = 30000;
}
