<?php

/**
 * 剧情和驾照考试
 */

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

class TemplateTale extends TemplateDefineBase
{
    public const Id = "Id";
    public const Type = "Type";
    public const Chapters = "Chapters";             //章节
    public const GatedType = "GatedType";           //关卡类型
    public const Car = "Car";       //指定车辆
    public const Rank = "Rank";     //指定车辆等级
    public const VitalTargetType = "VitalTargetType";               //主要目标类型
    public const VitalTargetCondition = "VitalTargetCondition";     //主要目标数值
    public const TargetType1 = "TargetType1";                       //次要目标1
    public const TargetCondition1 = "TargetCondition1";
    public const TargetType2 = "TargetType2";                       //次要目标2
    public const TargetCondition2 = "TargetCondition2";
    public const Unlock1 = "Deblocking1";           //解锁条件1 主线id
    public const Unlock2 = "Deblocking2";           //解锁条件2 星星数量
    public const Reward = "Reward";
    public const EXP = "EXP";
    public const SkillTeachId = "SkillTeachId"; //技巧教学关卡校验条件

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::Type,
            self::Chapters,
            self::GatedType,
            self::Car,
            self::Rank,
            self::VitalTargetType,
            self::VitalTargetCondition,
            self::TargetType1,
            self::TargetCondition1,
            self::TargetType2,
            self::TargetCondition2,
            self::Unlock1,
            self::Unlock2,
            self::Reward,
            self::EXP,
            self::SkillTeachId,
        );
    }

    //类型
    public const TYPE_MAIN = 1;        //主线
    public const TYPE_BRANCH = 2;      //支线
    public const TYPE_DRIVING_LICENSE_EXAM = 3; //驾照考试
    public const TYPE_DRIVING_PERMIT = 4;      //行驶证关卡
    public const TYPE_TEACHING_SKILL = 5;  //技巧教学

    //驾照等级
    public const DRIVING_LICENSE_LEVEL_C = 1;
    public const DRIVING_LICENSE_LEVEL_B = 2;
    public const DRIVING_LICENSE_LEVEL_A = 3;
    public const DRIVING_LICENSE_LEVEL_S = 4;
    public const DRIVING_LICENSE_LEVEL_S_1 = 5; //S级1星
    public const DRIVING_LICENSE_LEVEL_S_2 = 6; //S级2星
    public const DRIVING_LICENSE_LEVEL_S_3 = 7; //S级3星

    public const DRIVING_LICENSE_LEVEL_MAX = self::DRIVING_LICENSE_LEVEL_S_3; //配置最大等级
}
