<?php

/**
 * 赛车商城
 */

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

class TemplateShopCar extends TemplateDefineBase
{
    public const Id = "Id";
    public const UseType = "UseType";   //页签分类
    public const ItemId = "ItemId";
    public const Num = "Numb";
    public const ConvertedType = "ConvertedType";   //货币类型
    public const Price = "Price";   //价格
    public const ShowType = "ShowType";   //显示类型(热销等标签)
    public const Discount = "Discount";   //折扣 0为不打折
    public const SDate = "StartDate";
    public const STime = "Starttime";
    public const EDate = "EndDate";
    public const ETime = "EndTime";

    //增加字段
    public const RealPrice = "RealPrice";   //折后价=(价格*折扣)
    public const StartTime = "StartTime";   //上架时间-时间戳
    public const EndTime = "EndTime";       //下架时间-时间戳
    public const CheckItemId = "CheckItemId";   //实际对应的车或改装件id,购买时检查用

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::UseType,
            self::ItemId,
            self::Num,
            self::ConvertedType,
            self::Price,
            self::ShowType,
            self::Discount,
            self::SDate,
            self::STime,
            self::EDate,
            self::ETime,
        );
    }

    //useType分类
    public const USE_TYPE_CAR = 1;      //赛车

    //显示类型
    public const SHOW_TYPE_NONE = 9;    //不显示
    public const SHOW_TYPE_NEW = 0;     //新品(跳转)--在商城不可购买,对应活动购买
    public const SHOW_TYPE_HOT = 1;     //热销
    public const SHOW_TYPE_DISCOUNT = 2;     //折扣

    //新手引导 送车Id
    public const NEW_PLAYER_GUIDE_ID = 1;
}
