<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

/***
 * Class TemplateMail
 * @package Game\Constant\ConstTemplate
 * 邮件
 */
class TemplateMail extends TemplateDefineBase
{
    public const Id = "Mailbox_id";
    public const Enclosure = "Enclosure_con";
    public const Type = "Type";
    public const MailType = "MailType";
    public const ReplaceString = "ReplaceString";

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::Enclosure,
            self::Type,
            self::MailType,
            self::ReplaceString,
        );
    }

    public const MAIL_TYPE_DEFAULT = 1; //默认邮件 奖励在表里
    public const MAIL_TYPE_WITH_REWARD = 2; //奖励随邮件发送

    public const MAIL_ZL_PUSH_MAP = [2, 3, 4];  // 一键领取后置处理的数组

    public const MAIL_GIVE_ZL_TPL_ID = 10;  // 一键领取赠送邮件

    //替换内容Key
    public const REPLACE_KEY_OTHER_NAME = "OtherName";  //对方昵称
    public const REPLACE_KEY_PLAYER_NAME = "PlayerName"; //自己昵称
    public const REPLACE_KEY_INTIMACY_TYPE = "IntimacyType"; //好友亲密关系Id
    public const REPLACE_KEY_ITEM_ID = "ItemID";    //道具Id
    public const REPLACE_KEY_ACCOUNT = "Account";   // 游客账号
    public const REPLACE_KEY_PASSWORD = "Password"; // 游客密码
}
