<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

/***
 * Class TemplateLevel
 * @package Game\Constant\ConstTemplate
 * 排位赛段位模板
 */
class TemplateLevel extends TemplateDefineBase
{
    public const LevelId = "Level_id";
    public const BpMin = "Bp_min";
    public const BpMax = "Bp_max";
    public const LevelGrade = "Level_grade";
    public const ResetLevel = "ResetLevel"; //重置后段位
    public const Num = "Num"; //段位分 匹配用
    public const Weight = "Weight";

    public function getTermList(): array
    {
        return array(
            self::LevelId,
            self::BpMin,
            self::BpMax,
            self::LevelGrade,
            self::ResetLevel,
            self::Num,
            self::Weight,
        );
    }

    //段位分布--好友查询筛选用
    //客户端与服务器定义解析协议
    public const LEVEL_MAP = array(
        0 => [0, 63], //客户端[无限] => Level_id
        1 => [1, 8], //客户端[青铜-白银] => Level_id
        2 => [9, 16], //客户端[黄金-铂金] => Level_id
        3 => [17, 24], //客户端[钻石-大师]
        4 => [27, 27], //客户端[荣耀]
    );
}
