<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;
use Game\Data\AccountData;

class TemplateItem extends TemplateDefineBase
{
    public const ItemId = "ItemId";
    public const ItemType = "ItemType";
    public const UseType = "UseType";
    public const UseId = "UseId";
    public const TimeLimitType = "TimeLimitType";
    public const TimeLimit = "TimeLimit";
    public const IsStackabble = "IfStackable";
    public const ConvertedId = "ConvertedId";
    public const ConvertedCount = "ConvertedCount";
    public const MaxNumb = "MaxNumb";
    public const ClothList = "ClothList";   //套装包含的服装id
    public const ShowType = "ShowType";
    public const ScoreNum = "ScoreNum";

    public function getTermList(): array
    {
        return array(
            self::ItemId,
            self::ItemType,
            self::UseType,
            self::UseId,
            self::TimeLimitType,
            self::TimeLimit,
            self::IsStackabble,
            self::ConvertedId,
            self::ConvertedCount,
            self::MaxNumb,
            self::ClothList,
            self::ShowType,
            self::ScoreNum,
        );
    }

    //使用道具
    public const useFuncName = array(
        self::USE_TYPE_OPEN_GIFT => 'useItemOpenGift',         // 打开礼包
        self::USE_TYPE_ACTIVATION_ITEM => 'useItemExchange',         // 普通道具
        self::USE_TYPE_ACTIVATION_CLOTH=> 'useItemClothing',         // 衣服道具
        self::USE_TYPE_ACTIVATION_CAR_2_BAG => 'useItemCarCard',          // 获取车辆道具激活卡
        self::USE_TYPE_ACTIVATION_CAR_2_GARAGE => 'useItemActiveCar',        // 直接获得车辆
        self::USE_TYPE_UPDATE_VALUE => 'useItemUpdateValue',    //使用道具改变数值
    );

    //ItemType
    public const gainFuncName = [
        self::ITEM_TYPE_CAR  => 'itemAddCar',            // 直接获得赛车
        self::ITEM_TYPE_CLOTH => 'itemAddClothing',      // 直接获得衣服
//        self::ITEM_TYPE_CAR_REFIT_UNIVERSAL => 'itemAddCarRefitUniversal',       // 万能改装件
    ];

    //服装Id,男性服装Id为女性服装Id+10000
    public const MALE_CLOTH_ID_ADD = 10000;

    //道具Id
    public const ITEM_ID_JIN_LAN_TIE = 200006;  //金兰贴
    public const ITEM_ID_PAI_WEI_GUARD_CARD = 200007;   //排位保护卡
    public const ITEM_ID_CHANGE_NICKNAME_CARD = 200010; //改名卡
    public const ITEM_ID_TREASURE_TICKET = 200011;  //寻宝券--10连抽用
    public const ITEM_ID_HORN = 200012; //大喇叭

    //道具类型--Item表ItemType
    public const ITEM_TYPE_MONEY = 1;   //货币
    public const ITEM_TYPE_ITEM = 2;    //通常道具
    public const ITEM_TYPE_GIFT = 3;    //礼包
    public const ITEM_TYPE_CAR = 4;     //车辆
    public const ITEM_TYPE_CAR_MATERIAL = 5;    //养成材料
    public const ITEM_TYPE_CAR_REFIT = 6;   //改装件
    public const ITEM_TYPE_CLOTH = 7;         //服饰道具
    public const ITEM_TYPE_CAR_REFIT_UNIVERSAL = 9;  // 万能改装道具

    //显示类型--Item表ShowType
    public const SHOW_TYPE_CLOTHING_SUIT = 1;   //1.套装（服饰）
    public const SHOW_TYPE_CLOTHING_HAIR = 2;   //2.头部（服饰）
    public const SHOW_TYPE_CLOTHING_FACE = 3;   //3.面部（服饰）
    public const SHOW_TYPE_CLOTHING_UP_CLOTH = 4;   //4.上身（服饰）
    public const SHOW_TYPE_CLOTHING_DOWN_CLOTH = 5;   //5.下身（服饰）
    public const SHOW_TYPE_CLOTHING_SHOES = 6;   //6.鞋子（服饰）
    public const SHOW_TYPE_CLOTHING_ACTION = 7;   //7.动作（服饰）
    public const SHOW_TYPE_ITEM = 8;   //8.道具
    public const SHOW_TYPE_GIFT = 9;   //9.礼物
    public const SHOW_TYPE_EXPERIENCE_CARD = 10;   //10.体验卡
    public const SHOW_TYPE_CAR_MATERIAL = 11;   //11.车辆养成
    public const SHOW_TYPE_CAR = 12;   //12.车辆
    public const SHOW_TYPE_MONEY = 13;   //13.货币

    //使用类型--Item表UseType
    public const USE_TYPE_NONE = 0; //0-不可直接使用
    public const USE_TYPE_JUMP_INTERFACE = 1;   //1-使用后跳转到指定途径
    public const USE_TYPE_OPEN_GIFT = 2; //2-使用后打开礼包并获得道具
    public const USE_TYPE_ACTIVATION_ITEM = 3; //3-使用后激活指定道具
    public const USE_TYPE_ACTIVATION_CLOTH = 4; //4-使用后激活指定服装
    public const USE_TYPE_ACTIVATION_CAR_2_BAG = 5; //5-使用后激活指定车辆（作为道具进入背包）
    public const USE_TYPE_ACTIVATION_CAR_2_GARAGE = 6; //6-获得后直接激活车辆（不进入背包，直接进车库）
    public const USE_TYPE_UPDATE_VALUE = 7; //7-使用后改变对应数值
    public const USE_TYPE_2_CAR_EXTERIOR = 8; //8-使用后进入外观定制界面
    public const USE_TYPE_USE_OPEN_SCENE = 9;   //使用后打开界面

    //使用期限类型--Item表TimeLimitType
    public const TIME_LIMIT_TYPE_NONE = 0;  //无限制
    public const TIME_LIMIT_TYPE_TIME_ADD = 1;  //获得后开始计时
    public const TIME_LIMIT_TYPE_ACTIVITY_END = 2;  //随指定活动过期

    //Item表增益字段对应AccountData字段
    public const ITEM_BUFF_2_ACCOUNT_DATA = array(
        "gold" => AccountData::DB_BUFF_DOUBLE_GOLD,
        "proficiency" => AccountData::DB_BUFF_DOUBLE_PROFICIENCY,
        "exp" => AccountData::DB_BUFF_DOUBLE_EXP,
    );

    public const TYPE_CAR = 1;
    public const TYPE_CAR_REFIT = 2;
    public const TYPE_CLOTH = 3;
}
