<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

/***
 * Class TemplateLevel
 * @package Game\Constant\ConstTemplate
 * 比赛积分模板(比赛积分,保护分)
 */
class TemplateIntegral extends TemplateDefineBase
{
    public const Id = "BP_item_id";
    public const BpType = "BP_type";
    public const BpNum = "BP_num";
    public const LvMin = "LvMin";       //生效段位范围
    public const LvMax = "LvMax";
    public const MatchNum = "MatchNum"; //生效场次

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::BpType,
            self::BpNum,
            self::LvMin,
            self::LvMax,
            self::MatchNum,
        );
    }

    //编号id
    //积分--组队
    public const TEAM_WIN = 1;              //组队胜利
    public const TEAM_FAIL = 2;             //组队失败
    public const TEAM_NO1 = 3;              //组队第一名
    public const TEAM_MVP = 4;
    public const TEAM_WAN_SHENG = 5;             //完胜
    public const TEAM_FRIEND_INTIMACY = 6;  //亲密关系
    //积分--个人
    public const SINGLE_RANK = array(7, 8, 9, 10, 11, 12);  //个人1-6名
    //积分--通用
    public const CHONG_XIAN = 13;           //冲线
    public const JIN_PAI_BIAO_XIAN = 14;    //金牌表现
    public const YI_LU_LING_XIAN = 15;  //一路领先(领跑占比>=70%)
    public const NEW_PLAYER_GUARD1 = 16;    //新手保护1 输的给,青铜到白银
    public const NEW_PLAYER_GUARD2 = 17;    //新手保护2 输的给,黄金到铂金
    public const DAILY_WIN = 18;    //每日首胜(3场)
    public const CONTINUOUS_FAIL_GUARD = 19;    //连败保护
    public const CONTINUOUS_WIN = 20;       //连胜

    //保护分--组队
    public const G_TEAM_WIN = 21;           //组队胜利
    public const G_TEAM_NO1 = 22;           //小组第一
    public const G_TEAM_NO2 = 23;           //小组第二
    public const G_WAN_SHENG = 24;          //完胜
    public const G_DUI_WEI_WIN = 25;        //对位胜利
    //保护分--个人
    public const G_SINGLE_RANK = array(26, 27, 28); //个人前三
    //保护分--通用
    public const G_CHONG_XIAN = 29;         //冲线
    public const G_JIN_PAI = 30;            //金牌
    public const G_LIAN_SHENG = 31;         //连胜
    public const G_YI_LU_LING_XIAN = 32;  //一路领先
}
