<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

/***
 * Class TemplateInitPlayer
 * @package Game\Constant\ConstTemplate
 * 玩家初始信息
 */
class TemplateInitPlayer extends TemplateDefineBase
{
    public const Id = "CharacterId";
    //任务
    public const DailyTaskList = "DailyTaskList";
    public const MainTaskId = "MainTaskId";
    public const BranchTaskList = "BranchTaskList";
    public const BranchMainTaskList = "BranchMainTaskList"; //支线任务的主任务
    public const SeasonTaskList = "SeasonTaskList";
    public const WelfareWeekTaskList = "WelfareWeekTaskList";
    public const DailyChallengeTaskList = "DailyChallengeTaskList";   //日常挑战任务
    public const FriendIntimacyTaskList = "FriendIntimacyTaskList";     //好友亲密关系任务

    //生涯关卡
    public const CareerLevel = "CareerLevel";   //章节=>[关卡Id,..]

    //驾照关卡
    public const DrivingLicenseLevel = "DrivingLicenseLevel";   //驾照等级=>[关卡id,..]
    //行驶证关卡
    public const DrivingPermitLevel = "DrivingPermitLevel"; //carId=>[关卡id,..]
    //行驶证关卡顺序
    public const DrivingPermitLevelOrder = "DrivingPermitLevelOrder"; //carId=>[0第一关->后续关卡id,]

    //技巧教学关卡
    public const TeachingSkillLevel = "TeachSkillLevel";   //章节=>[关卡id,..]

    //解锁功能对应玩家等级
    public const UnlockFunc2Level = "UnlockFunc2Level"; //解锁功能=>level

    public function getTermList(): array
    {
        return array(
            self::Id,
        );
    }

    public const DEFAULT_ID = 1;
}
