<?php

/**
 * 道具商城
 */

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

class TemplateGoodsShop extends TemplateDefineBase
{
    public const Id = "Id";
    public const UseType = "UseType";   //页签分类
    public const ItemId = "ItemId";
    public const Num = "Numb";
    public const ConvertedType = "ConvertedType";   //货币类型
    public const Price = "Price";   //价格
    public const ShowType = "ShowType";   //显示类型(热销等标签)
    public const MaxNum = "MaxNumb";   //限购数量
    public const Discount = "Discount";   //折扣 0为不打折
    public const SDate = "StartDate";
    public const STime = "Starttime";
    public const EDate = "EndDate";
    public const ETime = "EndTime";

    //增加字段
    public const RealPrice = "RealPrice";   //折后价=(价格*折扣)
    public const StartTime = "StartTime";   //上架时间-时间戳
    public const EndTime = "EndTime";       //下架时间-时间戳

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::UseType,
            self::ItemId,
            self::Num,
            self::ConvertedType,
            self::Price,
            self::ShowType,
            self::MaxNum,
            self::Discount,
            self::SDate,
            self::STime,
            self::EDate,
            self::ETime,
        );
    }

    //useType分类
    public const USE_TYPE_FUNC = 1; //功能
    public const USE_TYPE_GIFT = 2; //礼包
    public const USE_TYPE_SEASON_LIMIT = 3; //赛季限购
    public const USE_TYPE_MEMBER_LIMIT = 4; //会员限购

    //显示类型
    public const SHOW_TYPE_NEW = 1;     //新品
    public const SHOW_TYPE_HOT = 2;     //热销
    public const SHOW_TYPE_DISCOUNT = 3;     //折扣
    public const SHOW_TYPE_TIME_LIMIT = 4;     //限时
    public const SHOW_TYPE_SEASON_LIMIT = 5;     //赛季限购
    public const SHOW_TYPE_WEEK_LIMIT = 6;     //每周限购
    public const SHOW_TYPE_DAILY_LIMIT = 7;     //每日限购

    //限购商品类型
    public const BUY_LIMIT_TYPE = array(
        self::SHOW_TYPE_SEASON_LIMIT,
        self::SHOW_TYPE_WEEK_LIMIT,
        self::SHOW_TYPE_DAILY_LIMIT,
    );
}
