<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

/**
 * AI生成规则
 * Class TemplateGenerateAi
 * @package Game\Constant\ConstTemplate
 */
class TemplateGenerateAi extends TemplateDefineBase
{
    public const Id = "Id";
    public const Car = "Car";                   //随机车id
    public const CarLevel = "CarLevel";         //随机等级范围
    public const CarChange = "CarChange";       //随机外观改装范围--暂时没有
    public const Strengthen = "Strengthen";     //随机强化范围
    public const Motion = "Motion";             //人物动作--暂时没有
    public const Dress = "Dress";               //随机服装 [0女服装=>[位置:[服装,..]],1男服装]
    public const AIIds = "Data";                //随机AI

    public const CAR_POSITION = "CarPosition";  //position=[carId,..]

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::Car,
            self::CarLevel,
            self::CarChange,
            self::Strengthen,
            self::Motion,
            self::Dress,
            self::AIIds,
        );
    }

    public const AI_LEVEL_1 = 1;    //初级AI
    public const AI_LEVEL_2 = 2;    //中级AI
    public const AI_LEVEL_3 = 3;    //高级AI
}
