<?php

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

class TemplateConst extends TemplateDefineBase
{
    public const ConstId = "Const_id";
    public const ConstNum = "Const_num";

    public function getTermList(): array
    {
        return array(
            self::ConstId,
            self::ConstNum,
        );
    }

    //配置表Id常量--对应Const_form表
    public const Const_1_GuardScoreMax = 1;         //保护分上限
    public const Const_9_MaxLevel = 9;              //段位最高上限
    public const Const_10_GuardLevel = 10;          //新手保护等级
    public const Const_14_SkillEnergyMax = 14;      //技能能量上限
    public const Const_15_MailExpireTime = 15;      //邮件过期时间
    public const Const_16_MailMaxNum = 16;          //邮件数量上限
    //比赛结算
    public const Const_Prof_Base_Race = 17;         //熟练度定位基数（竞速）
    public const Const_Prof_Base_Jam = 18;         //熟练度定位基数（干扰）
    public const Const_Prof_Base_Help = 19;         //熟练度定位基数（辅助）
    public const Const_Prof_Rank = array(20, 21, 22, 23, 24, 25);   //熟练度排名分值（排名1-6）
    public const Const_Prof_Win = 26;               //熟练度胜败加成（胜利）
    public const Const_Prof_Fail = 27;              //熟练度胜败加成（失败）
    public const Const_MVP_Rank = array(28, 29, 30, 31, 32, 33);    //MVP排名基础分（排名1-6）
    public const Const_MVP_Comp = 34;               //MVP冲线得分
    public const Const_MVP_Arg1 = 35;               //MVP系数1
    public const Const_MVP_Arg2 = 36;               //MVP系数2
    public const Const_MVP_Base_Win = 37;           //MVP胜败基础分（胜利）
    public const Const_MVP_Base_Fail = 38;          //MVP胜败基础分（失败）
    public const Const_Car_Score_Arg1 = 39;         //车辆评分系数1
    public const Const_Car_Score_Arg2 = 40;         //车辆评分系数2
    public const Const_Nick_Name_Min_Length = 60;   //玩家昵称最小限制数
    public const Const_Nick_Name_Max_Length = 61;   //玩家昵称最大限制数
    //比赛结算奖励--蓝图和碎片
    public const Const_Match_Settlement_BluePrint_Rate = 68; //蓝图获得概率
    public const Const_Match_Settlement_BluePrint_Num = 66; //蓝图获得数量
    public const Const_Match_Settlement_Chip_Rate = 69; //碎片获得概率
    public const Const_Match_Settlement_Chip_Num = 67; //碎片获得数量
    //排位赛
    public const Const_Ranking_Season_Record_Min = 276;   //排位赛胜率参与计算场次
    public const Const_Ranking_Season_Record_Max = 277;   //排位赛胜率计算最大场次
    public const Const_Ranking_AI_Min_Level = 278;    //当玩家段位为青铜4（最低段位）时，匹配ai对手
    public const Const_Ranking_AI_1_Min_Level = 279;  //当玩家段位为青铜3-黄金1时，玩家三连败时，下一场匹配ai对手。
    public const Const_Ranking_AI_1_Max_Level = 280;
    public const Const_Ranking_AI_1_Lose_Num = 281;
    public const Const_Ranking_AI_2_Min_Level = 282;  //当玩家段位为铂金-钻石时，玩家5连败后，下一场匹配ai对手。
    public const Const_Ranking_AI_2_Max_Level = 283;
    public const Const_Ranking_AI_2_Lose_Num = 284;
    public const Const_Ranking_Room_Level_Gap = 285;  //房间内,玩家段位差距小段位
    public const Const_Ranking_Score_Avg_2_Max = 286; //2人排位,分数加权,最高分
    public const Const_Ranking_Score_Avg_2_Min = 287;
    public const Const_Ranking_Score_Avg_3_Max = 288; //3人排位,分数加权
    public const Const_Ranking_Score_Avg_3_Mid = 289;
    public const Const_Ranking_Score_Avg_3_Min = 290;
    public const Const_Ranking_Gold_Player_Min_Score = 304;    //金牌车手最低分数
    public const Const_Ranking_Gold_Player_Level = 305; //金牌车手LevelId

    public const Const_Car_Refit_Random_Rule_Conn = 46;  //改装随机属性负增长连续次数
    public const Const_Car_Refit_Random_Rule_Max = 47;  //改装属性词条最大负增长条数
    public const Const_Friend_Number = 48;   //好友列表最大容量
    public const Const_Friend_Good = 49;    //好友每日点赞次数
    public const Const_Friend_List_Number = 50;   //好友列表每次刷新列表玩家数量
    public const Const_Friend_Last_Game_Num = 51; //好友最近比赛数量
    public const Const_Friend_Online_Request_Time = 52; //好友在线邀请时间限制（s）
    public const Const_Friend_Online_Request_Num = 53;  //好友在线邀请数目限制

    public const Const_Exterior_Refit_Sticker_Max = 70;  // 外观改造车贴最大数量
    public const Const_Licence_Max = 71;  // 车牌号每日最大抽取数量

    //任务
    public const Const_Task_Daily_Reward_Mail_id = 379; //日常未领取奖励 发送邮件id
    public const Const_Task_Daily_Week_Active_Mail_id = 380;    //日常任务周活跃度未领奖励 邮件Id
    public const Const_Task_Season_Reward_Mail_id = 381;    //赛季未领奖励

    public const Const_Task_Daily_Mail_id = 57; //日常未领取奖励 发送邮件id
    public const Const_Task_ZL_Level_Exp = 56;  //战令升级需要经验
    public const Const_Task_Daily_Challenge_Refresh_Num = 194;  //日常挑战任务,刷新次数
    public const Const_Task_Daily_Challenge_Max_Num = 195;      //日常挑战任务,最大数量
    public const Const_Task_Daily_Challenge_Num = 196;          //日常挑战任务,每次刷新数量
    public const Const_Task_Online_Pre_Day_Minute = 378;          //每日在线天数任务(任务条件70012),在线时间
    //战令每日任务
    public const Const_War_Token_Daily_Win_Exp = 197;           //战令每日任务,胜利经验
    public const Const_War_Token_Daily_Fail_Exp = 198;          //战令每日任务,失败经验
    public const Const_War_Token_Week_Max_Exp = 199;            //战令每日任务,每周经验上限

    // 战令
    public const Const_ZL_Max_Exp = 200;  // 战令最大经验值
    public const Const_ZL_OutFlow_Exp = 201; // 战令超出部分 每多少领取宝箱
    public const Const_ZL_High_Add_Level = 202; // 高级战令提升的等级
    public const Const_ZL_OutFlow_Item = 203; // 战令超出部分发送道具id
    public const Const_ZL_Level_Limit = 204; // 战令赠送/索要等级限制
    public const Const_ZL_Intimacy_Limit = 205; // 战令赠送好友度等级
    public const Const_ZL_Buy_Level_Sub = 207;  // 战令一等级购买消耗钻石

    public const Const_ZL_My_Give_Mail_ID = 208;  // 战令我赠送邮件ID
    public const Const_ZL_To_My_Give_Mail_ID = 209;  // 战令赠送我邮件ID
    public const Const_ZL_Demand_Mail_ID = 210;  // 战令索要邮件ID
    public const Const_ZL_Refuse_Demand_Mail_ID = 211;  // 战令拒绝索要邮件ID

    public const Const_ZL_Primary_Item_ID = 212;  // 战令高级发送的道具ID
    public const Const_ZL_Expert_Item_ID = 213;  // 战令精英发送的道具ID

    public const Const_ZL_Primary_Change = 214;  // 战令高级兑换钻石
    public const Const_ZL_Expert_Change = 215;  // 战令精英兑换钻石
    public const Const_ZL_Demand_Send_Msg = 220;  // 战令向索要邮件
    public const Const_ZL_Open_Expert_Normal = 392; //解锁战令消耗钻石--普通
    public const Const_ZL_Open_Expert_Expert = 393; //解锁战令消耗钻石--精英

    //熟练度
    public const Const_Buy_Proficiency_Flag = 394; //开通熟练度高级需要的钻石

    // 房间最大人数
    public const Const_Room_Max_Num = 65;

    // 俱乐部
    public const Const_Admin_Num_Max = 79;  // 俱乐部管理员最大数量
    public const Const_Club_Num_Max = 80;  // 俱乐部最大成员数
    public const Const_Club_Join_Apply_Max = 81;  // 俱乐部最大申请数量
    public const Const_Club_Tag_Max = 82;  // 俱乐部标签数量上限制
    public const Const_Club_Exit_Not_Join_Time = 92;  // 退出俱乐部多长时间不可再次加入
    public const Const_Impeach_Max_Time = 93;  // 多长时间队长不上限 接受弹劾
    public const Const_Impeach_Wait_Max_Time = 94;  // 弹劾过了多久 转移队长
    public const Const_Club_Recommend_List_Time = 96;  // 俱乐部列表推荐时间上限 天
    public const Const_Club_Battle_Pass_Active = 97;    //俱乐部battle pass上限,活跃值转俱乐部代币需要的活跃值
    public const Const_Club_Battle_Pass_Money = 98;  //俱乐部battle pass上限,活跃值可以转的俱乐部代币

    public const Const_AI_PlayerID_Min = 106;
    public const Const_AI_PlayerID_Max = 107;

    // 排行榜
    public const Const_Rank_Full_Max               = 114; // 段位榜总榜
    public const Const_Rank_Season_Max             = 115; // 段位榜赛季榜
    public const Const_Rank_Map_Full_Max           = 116; // 地图榜总榜
    public const Const_Rank_Map_Season_Max         = 117; // 地图榜赛季榜
    public const Const_Rank_Racing_Full_Max        = 118; // 竞速榜总榜
    public const Const_Rank_Racing_Season_Max      = 119; // 竞速榜赛季榜
    public const Const_Rank_Disturbance_Full_Max   = 120; // 干扰榜总榜
    public const Const_Rank_Disturbance_Season_Max = 121; // 干扰榜赛季榜
    public const Const_Rank_Helper_Full_Max        = 122; // 辅助榜总榜
    public const Const_Rank_Helper_Season_Max      = 123; // 辅助榜赛季榜
    public const Const_Rank_Car_Performance_Max    = 124; // 车辆性能榜
    public const Const_Rank_Car_Refit_Max          = 125; // 车辆改装榜
    public const Const_Rank_Cloth_Max              = 126; // 服饰评分榜
    public const Const_Rank_Club_Rank_Max          = 127; // 俱乐部段位榜
    public const Const_Rank_Club_Active_Max        = 128; // 俱乐部活跃榜
    public const Const_Rank_Club_Performance_Max   = 129; // 俱乐部性能榜
    public const Const_Rank_Player_Time_Out_Max    = 130; // 移除排行榜时间（天）
    public const Const_Rank_Data_Cache_Time_Out    = 131; // 排行榜数据缓存时间（s）
    public const Const_Rank_Page_Max               = 135; // 排行榜单页数据

    public const Const_CRoom_Timeout1              = 143; // 自定义房间只有房主存在 解散时间
    public const Const_CRoom_Timeout2              = 144; // 自定义房间有玩家 解散时间
    public const Const_CRoom_Timeout3              = 167; // 自定义房间 解散房间提醒倒计时s

    public const Const_Map_Challenge_Mail_id = 147;     //地图挑战赛未领取奖励邮件Id

    //比赛记录
    public const Const_Record_Max = 161;        //比赛记录保存条数上限
    public const Const_Record_Collection_Max = 162; //比赛记录收藏条数上限
    public const Const_Record_Page = 163;       //比赛记录 每页条数

    //大乱斗 164 165
    public const Const_Scuffle_Roll_Pre_Point = 168;    //大乱斗每个骰子需要分数
    public const Const_Scuffle_Roll_Point_Settlement_Base_Score = 169;  //骰子结算--基础分
    public const Const_Scuffle_Roll_Point_Settlement_Win_Score = 170;   //骰子结算--胜利分
    public const Const_Scuffle_Roll_Point_Settlement_Fail_Score = 171;  //骰子结算--失败分
    public const Const_Scuffle_Roll_Point_Settlement_MVP_Score = 172;  //骰子结算--MVP分
    public const Const_Scuffle_Roll_Point_Max = 173;  //骰子最大数量
    public const Const_Scuffle_Public_Pool_CD = 174;    //公共车池CD时间
    public const Const_Scuffle_Score_Discount = 184;    //赛季积分折扣 千分比
    //大乱斗积分
    public const Const_Scuffle_Ready_Time = 185;                            //大乱斗准备时间
    public const Const_Scuffle_Replace_Player_Car_Wait_time = 186;          //大乱斗与玩家换车,等待时间
    public const Const_Scuffle_Replace_Player_Car_CD_time = 187;            //大乱斗与玩家换车,冷却时间

    // 赛季奖励
    public const Const_Season_Score_Max = 188;     // 赛季奖励最高积分
    public const Const_Season_Loop_Max_Exp = 217;  // 赛季征程循环奖励经验
    public const Const_Season_Loop_Item_ID = 218;  // 赛季征程循环奖励发送道具
    public const Const_Season_Loop_Item_Num = 219; // 赛季征程循环奖励道具数量
    public const Const_Season_Loop_Num_Max = 221;  // 赛季征程循环奖励上限

    // 周任务宝箱礼包
    public const Const_Week_Gift_1 = 190;  // 初级周签礼包
    public const Const_Week_Gift_2 = 191;  // 中级周签礼包
    public const Const_Week_Gift_3 = 192;  // 高级周签礼包
    public const Const_Week_Gift_MAIL_ID = 193;  // 周签礼包发送邮件ID

    //亲密度
    public const Const_Intimacy_Open_Limit = 222;   //亲密关系开启所需亲密度
    public const Const_Intimacy_Add_Point_Match = 223;    //亲密度提升——组队游戏
    public const Const_Intimacy_Add_Point_Like = 224;       //亲密度提升——点赞
    public const Const_Intimacy_Add_Point_Send_Gift1 = 225;       //亲密度提升——送礼1
    public const Const_Intimacy_Add_Point_Send_ZLGift = 228;       //亲密度提升——战令送礼
    public const Const_Intimacy_Week_Limit_Match_Like = 229;        //亲密度提升限制——组队游戏和点赞（每周）
    public const Const_Intimacy_Week_Limit_Send_Gift = 230;        //亲密度提升限制——送礼（每周）
    public const Const_Intimacy_First_Flame_Match_Num = 231;     //第1朵火花需求游戏数
    public const Const_Intimacy_Flame_To_Match_Num = 232;        //增减火花判定局数（每周）
    public const Const_Intimacy_Fire_Max_Num = 233;        //火花等级上限
    public const Const_Intimacy_Title_Max = 235;                //亲密关系限制——总和
    public const Const_Intimacy_Remove_Title_CD_Time = 236;     //解除关系冷静期（h）
    public const Const_Intimacy_Remove_Title_Invalid_Time = 237;     //解除关系失效时间（h）
    public const Const_Intimacy_Remove_Title_Cost_Point = 238;      //解除关系亲密度降低
    public const Const_Intimacy_Apply_Max = 239;        //亲密关系申请列表上限
    public const Const_Intimacy_Apply_Live_Time = 240;  //亲密关系申请列表信息存在时长（h）
    public const Const_Intimacy_Mail_Pass = 242;    //邮件Id亲密关系——通过
    public const Const_Intimacy_Mail_Refuse = 243;    //邮件Id亲密关系——拒绝
    public const Const_Intimacy_Mail_UnRead = 244;    //邮件Id亲密关系——未处理
    public const Const_Intimacy_Mail_Remove = 245;    //邮件Id亲密关系——解除

    public const Const_Guest_Account_MailID = 260;    // 游客账号密码邮件
    public const Const_Guest_Bind_Reward_ItemID = 261;    // 游客账号绑定奖励ID
    public const Const_IM_Room_Count_Max = 267;    // 聊天获取房间列表单页数量

    //盲盒商店
    public const Const_Exchange_Ticket_Need_Money_Num = 270;   //兑换抽奖券需要货币数量
    public const Const_Exchange_Ticket_Max_Num = 271;   //兑换抽奖券一次最多兑换数量

    public const Const_Change_Nickname_CD = 275;    //修改昵称冷却时间,天

    //大喇叭
    public const Const_Horn_Money_Id = 262;  //大喇叭道具替代货币Id
    public const Const_Horn_Money_Num = 263;  //大喇叭道具替代货币数量

    // 等级经验新计算公式
    public const Const_Exp_Base = 306;                              // 结算经验-基础经验
    public const Const_Exp_Add = 307;                               // 结算经验-增长系数
    public const Const_Exp_Win = 308;                               // 结算经验-胜利系数
    public const Const_Exp_Fail = 309;                              // 结算经验-失败系数

    public const Const_Car_Refit_Consume_Item = 42; //车辆深度改装消耗道具类型
    public const Const_Car_Refit_Money = 44;        //车辆深度改装货币消耗类型

    public const Const_Car_Refit_Consume_Num_B = 43;  //车辆深度改装消耗道具数量
    public const Const_Car_Refit_Money_Num_B = 45;    //车辆深度改装货币消耗数量
    public const Const_Car_Refit_Consume_Num_A = 312;
    public const Const_Car_Refit_Money_Num_A = 313;
    public const Const_Car_Refit_Consume_Num_S = 314;
    public const Const_Car_Refit_Money_Num_S = 315;

    //AI随机
    public const Const_AI_RANDOM_LEVEL_RANGE = 382; //AI随机等级范围
    public const Const_AI_RANDOM_DAN_RANGE = 383; //AI随机段位范围

    public const Const_Item_Max_Mail_ID = 384; // 邮件id

    public const Const_Save_Step_Limit = 387; // 保存步骤上限
    public const Const_Again_Task_Item_ID = 390; // 补签道具
    public const Const_Again_Task_Item_NUM = 391; // 补签道具数量
}
