<?php

/**
 * 战令商城
 */

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

class TemplateBPStore extends TemplateDefineBase
{
    public const Id = "Id";
    public const ItemId = "ItemId";
    public const Num = "ItemNum";
    public const Term = "Term";     //限购类型
    public const MaxNum = "Num";   //限购数量
    public const ConvertedType = "CurrencyType";   //货币类型
    public const Price = "Price";   //价格
    public const SeasonId = "Match";     //赛季

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::ItemId,
            self::Num,
            self::Term,
            self::ConvertedType,
            self::Price,
            self::MaxNum,
            self::SeasonId,
        );
    }

    //限购类型
    public const TERM_TYPE_WEEK = 1;    //每周限购
    public const TERM_TYPE_SEASON = 2;    //赛季限购
    public const TERM_TYPE_FOREVER = 3;    //永久(不刷新)    从对应赛季开始,一直存在
    public const TERM_TYPE_DAILY = 4;   //每日限购
}
