<?php

/**
 * 活动时间
 */

namespace Game\Constant\ConstTemplate;

use Game\Constant\TemplateDefineBase;

class TemplateActivityTime extends TemplateDefineBase
{
    public const Id = "ID";
    public const Activity = "Activity";         //对应活动->定义在ActivityDefine
    public const ActivityId = "ActivityId";     //对应活动表Id
    public const TimeType = "Type";             //时间类型
    public const TimeParameter = "Parameter";   //时间参数
    public const TimeGap = "Time";              //时间间隔 天

    public const StartTime = "StartTime";   //开始时间-时间戳
    public const EndTime = "EndTime";       //结束时间-时间戳

    public function getTermList(): array
    {
        return array(
            self::Id,
            self::Activity,
            self::ActivityId,
            self::TimeType,
            self::TimeParameter,
            self::TimeGap
        );
    }

    //时间类型
    public const TIME_TYPE_1 = 1;   //1=指定时间开启（年-月-日 时:分:秒）
    public const TIME_TYPE_2 = 2;   //2=指定周时间开启（1=周1；2=周2）
    public const TIME_TYPE_3 = 3;   //3=指定赛季开启（1=S1）
}
