<?php

/**
 * 返回客户端错误码,对应Language表Id
 */

namespace Game\Constant;

class ClientErrorCode
{
    // 客户端通用
    public const CLIENT_SUCCESS = 0;

    //货币不足
    public const MONEY_GOLD_NOT_ENOUGH = 100074;       //金币不足
    public const MONEY_TICKETS_NOT_ENOUGH = 100075;    //点券不足
    public const MONEY_DIAMOND_NOT_ENOUGH = 100076;    //钻石不足
    public const MONEY_CLUB_NOT_ENOUGH = 100077;    //俱乐部货币不足
    public const MONEY_SEASON_NOT_ENOUGH = 100078;     //赛季币货币不足

    public const NICKNAME_HAS_SHIELD_WORD = 100079;  //昵称有敏感词
    public const NICKNAME_HAS_USED = 100352;  //昵称被占用
    public const NICKNAME_CD = 100390;  //修改名字失败，每7天仅可修改一次。
    public const NICKNAME_LEN_LESS = 100012;    //昵称长度小于配置
    public const NICKNAME_LEN_OVER = 100013;    //昵称长度大于配置
    public const SEASON_CLOSE = 100409;     //赛季已结束

    //道具
    public const ITEM_NOT_FOUND = 100080;      //道具不存在
    public const ITEM_IS_INVALID = 100081;     //道具无效(配置不存在)
    public const ITEM_TIME_EXPIRE = 100082;    //道具过期
    public const ITEM_NOT_ENOUGH = 100083;     //道具数量不足
    public const ITEM_USE_FAIL = 100084;       //使用道具失败
    public const ITEM_TYPE_ERROR_NOT_CLOTH = 100085;   //道具类型错误,不是服装
    public const ITEM_NOT_EXPIRE = 100086;     //道具未过期 不能兑换

    //PVP 匹配
    public const PVP_MATCHING_JOIN_ID_ERROR = 100087;     //匹配--匹配数据不一致
    public const PVP_MATCHING_DATA_NOT_FOUND = 100088;    //匹配记录不存在
    public const PVP_JOIN_MATCH_ERROR = 100089;             //匹配失败
    public const PVP_DATA_ERROR = 100090;   //结算数据错误
    public const PVP_JOIN_MATCH_PLAYER_NOT_READY = 100091;
    public const PVP_RANKING_LEVEL_NOT_MATE = 100398;    //组队中，有玩家段位高于/低于房间要求
    public const PVP_RANKING_INVITED_FRIEND_LEVEL_OVER_MATE = 100399; //邀请的好友段位，高于房间要求
    public const PVP_RANKING_INVITED_FRIEND_LEVEL_LESS_MATE = 100410; //邀请的好友段位，低于房间要求

    //邮件
    public const MAIL_NOT_EXIT = 100092;    //邮件不存在
    public const MAIL_IS_EXPIRE = 100093;    //邮件已过期
    public const MAIL_HAS_GET = 100094;   //邮件已领取
    public const MAIL_NOT_HAVE_ENCLOSURE = 100095;   //邮件没有附件,不能领取
    public const MAIL_ENCLOSURE_NOT_GET = 100096;    //附件未领取,不能删除
    public const MAIL_OPTION_ERROR = 100097;         //邮件操作类型错误
    public const MAIL_EMPTY = 100098;      //没有邮件 不能操作

    // car
    public const CAR_IS_EXPIRE = 100099;       //车辆过期,不能使用
    public const CAR_TIME_EXPIRE = 100100;             //车辆过期,不能更换
    public const CAR_ERROR = 100101;                   //车辆错误
    public const ERROR_CAR_NOT_EXIST    = 100102;             // 车辆不存在
    public const ERROR_CAR_LEVEL_IS_MAX = 100103;             // 等级已经最高，不可升级
    public const ERROR_CAR_UPGRADE_ITEM_NOT_ENOUGH  = 100104; // 升级道具不足
    public const ERROR_CAR_UPGRADE_MONEY_NOT_ENOUGH = 100105; // 升级货币不足
    public const ERROR_CAR_UPGRADE_CONSUME_ITEM  = 100106;    // 升级消耗道具失败
    public const ERROR_CAR_UPGRADE_CONSUME_MONEY = 100107;    // 升级消耗货币失败
    public const ERROR_CAR_UPGRADE               = 100108;    // 升级车辆失败
    public const ERROR_CAR_UPGRADE_REWARD        = 100109;    // 升级获取奖励失败
    public const ERROR_CAR_UPGRADE_SKILL         = 100110;    // 更换技能失败
    public const ERROR_CAR_REFIT_PROP_NOT_ENOUGH = 100111;    // 深度改装道具不足
    public const ERROR_CAR_REFIT_MONEY_NOT_ENOUGH = 100112;   // 深度改装货币不足
    public const ERROR_CAT_SYS_NOT_EXIT = 100113;             // 改装系统不存在
    public const ERROR_CAT_REFIT_UPDATE_FAIL = 100114;        // 深度改装更新失败
    public const ERROR_CAT_REFIT_FULL_LEVEL = 100115;         // 当前级别下改装满级无法改装

    //好友
    public const ERROR_Other_FRIEND_LIST_MAX_ERROR = 100116;  // 对方好友列表已达上限
    public const ERROR_FRIEND_LIST_MAX_ERROR = 100117;        // 好友列表已达上限
    public const ERROR_FRIEND_DELETE_ERROR = 100118;          // 删除好友失败
    public const ERROR_FRIEND_REJECT_REQUEST_ERROR = 100119;  // 对方已关闭好友申请
    public const ERROR_FRIEND_ADD_ERROR = 100120;             // 添加好友失败
    public const ERROR_FRIEND_UPDATE_ERROR = 100121;          // 更新好友失败
    public const ERROR_FRIEND_STATUS_ERROR = 100122;          // 好友状态不匹配
    public const ERROR_FRIEND_EXISTS_ERROR = 100123;          // 已经是好友了

    public const ERROR_NOTICE_ONLINE_NUM_ERROR = 100124;      // 在线通知最大数量
    public const ERROR_FRIEND_ADD_BLACK_FAIL = 100125;        // 加入黑名单失败
    public const ERROR_NOTICE_PLAYER_EXISTS_ERROR = 100126;   // 在线通知玩家已存在
    public const ERROR_NOTICE_PLAYER_OFFLINE = 100127;        // 在线通知玩家已离线
    public const ERROR_FRIEND_LIKES_SAVE_ERROR = 100128;      // 好友点赞错误
    public const ERROR_FRIEND_ON_SHOW = 100129;               // 好友添加显示码
    public const ERROR_FRIEND_DEL_APPLY = 100130;             // 移除申请列表数据
    public const FRIEND_INTIMACY_ITEM_NOT_ENOUGH = 100326;   //金兰贴不足
    public const FRIEND_INTIMACY_TITLE_OVER_MAX = 100327;   //超过亲密关系数量上限
    public const FRIEND_INTIMACY_TITLE_OVER_LIMIT = 100328; //指定关系超上限
    public const FRIEND_INTIMACY_TITLE_TARGET_OVER_MAX = 100329;   //超过对方亲密关系数量上限
    public const FRIEND_HAS_INTIMACY_WITH_TARGET_PLAYER = 100330;   //已经和对方有了亲密关系
    public const FRIEND_HAS_APPLY_WAIT_DEAL = 100331;       //当前有申请等待对方处理
    public const FRIEND_INTIMACY_APPLY_NOT_FOUND = 100332;  //申请信息不存在
    public const FRIEND_INTIMACY_APPLY_OVER_TIME = 100333;  //申请信息超时
    public const FRIEND_INTIMACY_APPLY_OVER_MAX = 100334;   //超过最大申请数量
    public const FRIEND_NO_INTIMACY_TITLE_WITH_TARGET_PLAYER = 100335;   //和对方没有亲密关系
    public const FRIEND_INTIMACY_TITLE_IN_CD_TIME = 100336;     //处在冷静期,不能解除关系
    public const ERROR_TARGET_PLAYER_IS_NOT_FRIEND = 100337;   //对方不是好友
    public const FRIEND_INTIMACY_NOT_ENOUGH = 100338;   //亲密度不足
    public const FRIEND_INTIMACY_REWARD_NOT_OPEN = 100340;  //亲密活动未开启
    public const FRIEND_INTIMACY_REWARD_NOT_FOUND = 100341;  //亲密活动奖励不存在
    public const FRIEND_INTIMACY_REWARD_SCORE_NOT_ENOUGH = 100342;  //不能领取
    public const FRIEND_INTIMACY_REWARD_ALREADY_GET = 100343;   //已领取奖励
    public const FRIEND_REMARK_HAS_SHIELD_WORD = 100403;  //好友备注有敏感词
    public const FRIEND_REMARK_FAIL = 500029;   //修改好友备注失败

    public const ERROR_GAME_LEVEL_NOT_EXISTS = 100131;            // 游戏关卡不存在
    public const ERROR_GAME_LEVEL_STAR_REWARD_ID_NOT_FOUND = 100132;   // 游戏关卡星星奖励不存在
    public const ERROR_GAME_LEVEL_TARGET_REWARD_RECEIVED = 100133;  //游戏关卡目标奖励已领取
    public const ERROR_STAR_REWARD_LEVEL_ERROR = 100134;
    public const ERROR_GET_STAR_REWARD = 100135;  //星星数不够无法领取奖励
    public const ERROR_STAR_REWARD_RECEIVED = 100136;   //星星奖励已领取
    public const ERROR_GAME_LEVEL_NULL = 100137;   // 关卡ID未空
    public const ERROR_ADD_RANK_LIKES_ERROR = 100138;  //排位赛点赞失败
    public const ERROR_RANK_LIKES_EXISTS_ERROR = 100139;   //已点赞

    public const ERROR_EVENT_CONDITION_PARAM_NUM = 100140;  //任务条件参加异常
    public const ERROR_EVENT_CONDITION_TYPE = 100141;  //任务条件类型错误
    public const ERROR_EVENT_QUERY_FAIL = 100142;   //查询失败
    public const ERROR_EVENT_ADD_FAIL = 100143;    //更新失败
    public const ERROR_EVENT_RESET_TYPE = 100144;   //每次重置类型错误

    public const ERROR_RANK_PARAM = 100145;   //排行榜参数错误

    // room
    public const ERROR_ROOM_MAP_NOT_EXIST       = 100146;      // 地图未找到
    public const ERROR_ROOM_MODE_NOT_EXIST      = 100147;      // 模式不存在
    public const ERROR_ROOM_MODE_TYPE_NOT_OPEN  = 100148;      // 房间模式未开启
    public const ERROR_ROOM_IS_MAX_NOT_JOIN     = 100149;      // 房间已满 无法进入
    public const ERROR_ROOM_NOT_EXIST           = 100150;      // 房间未找到
    public const ERROR_ROOM_JOIN_ERROR          = 100151;      // 房间加入失败
    public const ERROR_ROOM_IS_PLAY             = 100152;      // 房间正在游戏中 | 匹配中 无法加入
    public const ERROR_ROOM_NOT_OWNER_IS_CHANGE = 100153;      // 不是房主不可修改
    public const ERROR_ROOM_NOT_REPEAT_CHANGE   = 100154;      // 数据未变动
    public const ERROR_ROOM_OPERATE_FAILED      = 100155;      // 失败
    public const ERROR_ROOM_JOIN_ROOM_FAILED    = 100156;      // 加入房间失败
    public const ERROR_ROOM_PLAYER_NOT_EXIST    = 100157;      // 房间内不存在此玩家
    public const ERROR_ROOM_PLAYER_IS_EXIST     = 100158;      // 房间内已存在此玩家
    public const ERROR_CREATE_ROOM_FAILED       = 100159;      // 创建房间失败
    public const ERROR_EXIT_OLD_ROOM_FAILED     = 100160;      // 退出之前的房间失败
    public const ERROR_NOT_PERMISSION           = 100161;      // 权限不足
    public const ERROR_ROOM_EXISTS              = 100162;      // 房间已存在

    public const ERROR_CUSTOMIZE_WATCH_MAX      = 100163;      // 观战人数已经到达上限制
    public const ERROR_SAVE_MAP_ERROR           = 100164;      // 取消保存地图失败
    public const ERROR_ROOM_STATE_IS_PRIVATE    = 100165;      // 房间状态为私密 不可加入
    public const ERROR_ROOM_INPUT_PASSWORD      = 100166;      // 房间需要输入密码
    public const ERROR_ROOM_PASSWORD_FAILED     = 100167;      // 房间密码不正确
    public const ERROR_ROOM_CHANGE_TEAM_FAILED  = 100168;      // 玩家切换位置，但是已经有人预选了

    // club
    public const ERROR_CLUB_EXISTS              = 100169;      // 俱乐部已存在
    public const ERROR_CREATE_CLUB              = 100170;      // 俱乐部创建失败
    public const ERROR_NAME_EXIST               = 100171;      // 名称重复
    public const ERROR_CLUB_CREATE_ERROR        = 100172;      // 创建俱乐部失败
    public const ERROR_CLUB_CHANGE_ERROR        = 100173;      // 修改俱乐部失败
    public const ERROR_SEARCH_CONDITION_EMPTY   = 100174;      // 条件不可为空
    public const ERROR_CLUB_NOT_EXIST           = 100175;      // 俱乐部不存在
    public const ERROR_EXEC_FAILED              = 100176;      // 操作失败
    public const ERROR_NOT_JOIN                 = 100177;      // 俱乐部状态为不可加入
    public const ERROR_CLUB_NUM_IS_MAX          = 100178;      // 俱乐部数量已满，不可加入
    public const ERROR_ADMIN_NUM_IS_MAX         = 100179;      // 俱乐部管理员数量已满
    public const ERROR_PLAYER_IN_CLUB           = 100180;      // 玩家已经拥有俱乐部
    public const ERROR_REJECT_JOIN              = 100181;      // 拒绝玩家加入俱乐部
    public const ERROR_MEMBER_NOT_EXIST         = 100182;      // 玩家不存在俱乐部中
    public const ERROR_REQUEST_AND_JOIN_SUCCESS = 100183;      // 玩家请求无需审核的俱乐部加入成功
    public const ERROR_JOIN_TIME_LIMIT          = 100184;      // 退出俱乐部后 配置时间内无法再加入俱乐部
    public const ERROR_CLUB_ACTIVE_DONATE       = 100185;      // 俱乐部积分捐献失败,积分不够
    public const ERROR_CLUB_BATTLE_PASS_ID      = 100186;      // 俱乐部战令Id,错误
    public const ERROR_CLUB_BATTLE_ACTIVE       = 100187;      // 俱乐部战令活跃点不足
    public const ERROR_CLUB_BATTLE_SAVE         = 100188;      // 俱乐部战令奖励领取失败
    public const ERROR_CLUB_BATTLE_ITEM         = 100189;      // 俱乐部战令道具领取失败
    public const ERROR_CLUB_STORE_BUY_MAX       = 100190;      // 俱乐部商城购买超出最大值
    public const ERROR_CLUB_NOT_BUY             = 100191;      // 未解锁 无法购买
    public const ERROR_CLUB_SCORE_NOT_ENOUGH    = 100192;      // 积分不够 不能加入
    public const ERROR_CLUB_BATTLE_RECEIVED     = 100193;      // 俱乐部战令道具已领取
    public const ERROR_CLUB_BATTLE_RESET        = 100194;      // 俱乐部战令重置失败
    public const ERROR_CLUB_STORE_BUY_MONEY     = 100195;      // 购买货币不够
    public const ERROR_CLUB_BATTLE_PASS_MONEY   = 100196;      // 俱乐部战令,活跃值转代币领取失败
    public const ERROR_CLUB_PLAYER_NOT_JOIN     = 100197;      // 玩家未加入俱乐部
    public const ERROR_CLUB_CARS_MAX            = 100198;      // 玩家俱乐部领取的车辆个数已到最大
    public const ERROR_CLUB_CARS_NOW_USE        = 100199;      // 俱乐部领取的车辆正在使用
    public const ERROR_CLUB_DAILY_DONATE_GET    = 100200;      //俱乐部每日捐献已完成

    //任务
    public const TASK_DAILY_OPTION_ERROR = 100201;     //日常任务操作请求错误
    public const TASK_DAILY_NO_TASK_CAN_SUBMIT = 100202;   //没有可提交的日常任务
    public const TASK_DAILY_NO_REWARD_CAN_GET = 100203;    //没有可领取的奖励
    public const TASK_DAILY_REWARD_ALL_GET = 100204;       //奖励已全部领取
    public const TASK_NOT_FOUND = 100205;          //任务不存在
    public const TASK_IS_DOING = 100206;           //任务未完成
    public const TASK_IS_OVER = 100207;            //任务已完成
    public const TASK_SEASON_WEEK_NOT_OPEN = 100208;   //周未开启
    public const TASK_SEASON_EXPERT_NOT_OPEN = 100209;   //战令未开启高级,不能提交任务
    public const TASK_DAILY_CHALLENGE_REFRESH_NUM_NOT_ENOUGH = 100306;  //日常挑战任务,刷新次数不足
    public const TASK_DAILY_CHALLENGE_REFRESH_FAIL = 100307;        //刷新失败
    public const TASK_DAILY_CHALLENGE_TYPE_ERROR = 100308;  //任务类型错误
    public const TASK_DAILY_CHALLENGE_CAN_NOT_REFRESH = 100300; //任务不能刷新

    //战令
    public const WAR_TOKEN_EXPERT_IS_OPEN = 100210;    //战令已开启高级,不能重复购买
    public const WAR_TOKEN_NO_REWARD_CAN_GET = 100211; //没有奖励可领取
    public const WAR_TOKEN_REWARD_NOT_FOUND = 100212;  //战令奖励不存在
    public const WAR_TOKEN_REWARD_ALREADY_GET = 100213;    //战令奖励已领取
    public const WAR_TOKEN_NOT_OPEN_EXPERT = 100214;   //战令未开启高级

    public const PVE_LEVEL_NOT_FOUND = 100215;     //关卡不存在
    public const PVE_LEVEL_TYPE_ERROR = 100216;    //关卡类型错误
    public const PVE_LEVEL_UNLOCK = 100217;        //关卡未解锁
    public const PVE_LEVEL_CAR_ERROR = 100218;     //关卡需要车与驾驶车不符
    public const PVE_LEVEL_NOT_FOUND_PLAYER = 100219;  //关卡结算,未找到玩家数据
    public const DRIVING_LICENSE_REWARD_CAN_NOT_GET = 100220;  //驾照关卡奖励不能领取
    public const DRIVING_LICENSE_REWARD_ALREADY_GET = 100221;  //驾照关卡奖励已领取
    public const DRIVING_LICENSE_CHAPTER_REWARD_CAN_NOT_GET = 100222;  //驾照章节奖励不能领取
    public const DRIVING_LICENSE_CHAPTER_REWARD_ALREADY_GET = 100223;  //驾照章节奖励已领取

    public const EXTERIOR_REFIT_STICKER_IS_MAX = 100224;   // 车贴已经达到上限
    public const EXTERIOR_LICENCE_IS_MAX = 100225;   // 当日抽车牌号次数已达上限
    public const EXTERIOR_EXTERIOR_REFIT_NOT_USE = 100226;   // 改装不可用

    public const ERROR_REFIT_ITEM_NUM_NOT_ENOUGH = 100404;   // 万能改装道具数量不足
    public const ERROR_REFIT_ITEM_NOT_EXCHANGE = 100405;     // 万能改装道具不能转化为此改装件
    public const ERROR_CAR_NOT_REFIT = 100406;     // 车不能使用此改装件
    public const ERROR_REFIT_ERROR = 100407;     // 万能改装件兑换改装件失败
    public const ERROR_REFIT_REPEATED = 100408;     // 已经拥有此改装

    // rank
    public const ERROR_UPDATE_RANK_SCORE_FAILED = 100227;  // 修改排位分数失败
    public const ERROR_RANK_LIKE_FAILED         = 100228;  // 点赞失败
    public const ERROR_RANK_LIKE_REPEATED       = 100229;  // 点赞失败， 一天重复点赞

    //熟练度奖励
    public const PROFICIENCY_TOTAL_REWARD_NOT_FOUND = 100230;    //总熟练度奖励不存在
    public const PROFICIENCY_TOTAL_REWARD_LEVEL_NOT_ENOUGH = 100231;   //总熟练度等级不足,不能领取
    public const PROFICIENCY_TOTAL_REWARD_ALREADY_GET = 100232;    //总熟练度奖励已领取
    public const PROFICIENCY_TOTAL_REWARD_NOT_OPEN_EXPERT = 100233;    //未开通高级,不能领取
    public const PROFICIENCY_REWARD_CAR_NOT_FOUND = 100234;    //赛车不存在
    public const PROFICIENCY_REWARD_CAR_LEVEL_NOT_ENOUGH = 100235;    //赛车等级不足,不能领取
    public const PROFICIENCY_REWARD_CAR_ALREADY_GET = 100236;    //已领取奖励
    public const PROFICIENCY_REWARD_CAR_REWARD_NOT_FOUND = 100237;    //赛车熟练度奖励不存在
    public const PROFICIENCY_REWARD_CAR_NOT_FOREVER = 100238;    //非永久赛车,不能领取奖励
    public const PROFICIENCY_TOTAL_ALREADY_OPEN_EXPERT = 100414;    //已开通高级熟练度

    //统计数据
    public const RECORD_NOT_FOUND = 100239;    //比赛记录不存在
    public const RECORD_HAS_COLLECTION = 100240;   //记录已经收藏
    public const RECORD_NONE_COLLECTION = 100241;  //记录未收藏,不能取消
    public const RECORD_COLLECTION_NUM_OVER_LIMIT = 100242;    //超过收藏上限
    public const RECORD_OPTION_FAIL = 100243;  //操作失败

    //商城
    //道具商城
    public const SHOP_BUY_NUM_ERROR = 100244;     //购买道具数量参数错误
    public const SHOP_ITEM_NOT_FOUND = 100245;   //商城道具不存在
    public const SHOP_BUY_NUM_OVER_LIMIT = 100246;   //购买道具数量超过上限
    public const SHOP_ITEM_NOT_IN_TIME = 100247;  //道具未到上架时间,不能购买
    public const SHOP_ITEM_OUT_TIME = 100248;  //道具已下架,不能购买
    //赛车商城
    public const SHOP_CAR_ITEM_NOT_FOUND = 100249;    //赛车商城道具不存在
    public const SHOP_CAR_ITEM_NOT_IN_TIME = 100250;  //道具未到上架时间,不能购买
    public const SHOP_CAR_ITEM_OUT_TIME = 100251;  //道具已下架,不能购买
    public const SHOP_CAR_ITEM_CAN_NOT_BUY = 100252;  //道具不能购买
    public const SHOP_CAR_HAS_CAR = 100253;       //已拥有此赛车,不能重复购买
    public const SHOP_CAR_HAS_EXTERIOR = 100254;  //已拥有此改装件,不能重复购买
    public const SHOP_CAR_BUY_FAIL = 100255;      //购买道具失败
    //服装商城
    public const SHOP_CLOTHING_ITEM_NOT_FOUND = 100256;   //服装商城道具不存在
    public const SHOP_CLOTHING_ITEM_CAN_NOT_BUY = 100257;  //道具不能购买
    public const SHOP_CLOTHING_ITEM_NOT_IN_TIME = 100258;  //道具未到上架时间,不能购买
    public const SHOP_CLOTHING_ITEM_OUT_TIME = 100259;  //道具已下架,不能购买
    public const SHOP_CLOTHING_HAS_CLOTHING = 100260;     //已拥有此服装,不能重复购买
    //赛季商城
    public const SHOP_SEASON_ITEM_NOT_FOUND = 100261;     //赛季商城道具不存在
    public const SHOP_SEASON_BUY_NUM_OVER_LIMIT = 100262;   //购买道具数量超过上限

    //战令商城
    public const SHOP_ZL_ITEM_NOT_FOUND = 100316;     //战令商城道具不存在
    public const SHOP_ZL_BUY_NUM_OVER_LIMIT = 100317;   //购买道具数量超过上限
    public const SHOP_ZL_MAIL_NOT_DEMAND = 100318;   // 邮件不是索要战令邮件 拒绝失败
    //抽奖商城
    public const SHOP_BLIND_BOX_TICKET_NOT_ENOUGH = 100357;  //抽奖券不足
    public const SHOP_BLIND_BOX_ID_NOT_FOUND = 100358;  //抽奖奖励不存在
    public const SHOP_BLIND_BOX_ITEM_NOT_IN_TIME = 100359;  //道具未到上架时间,不能购买
    public const SHOP_BLIND_BOX_ITEM_OUT_TIME = 100360;  //道具已下架,不能购买
    public const SHOP_BLIND_BOX_OVER_EXCHANGE_MAX = 100384; //超过最大兑换数量
    //推荐商城
    public const SHOP_RECOMMEND_NOT_FOUND = 100361;   //商城道具不存在
    public const SHOP_RECOMMEND_ITEM_NOT_IN_TIME = 100362;  //道具未到上架时间,不能购买
    public const SHOP_RECOMMEND_ITEM_OUT_TIME = 100363;  //道具已下架,不能购买
    public const SHOP_RECOMMEND_CAN_NOT_BUY = 100364;    //道具不可购买

    //活动
    //地图挑战赛
    public const MAP_CHALLENGE_NOT_OPEN = 100263;  //地图挑战活动未开启
    public const MAP_CHALLENGE_CLOSED = 100264;    //地图挑战活动已关闭
    public const MAP_CHALLENGE_MAP_NOT_OPEN = 100265;  //地图未开启
    public const MAP_CHALLENGE_REWARD_CAN_NOT_GET = 100266;    //大奖不能领取
    public const MAP_CHALLENGE_REWARD_ALREADY_GET = 100267;    //大奖已领取
    //大乱斗活动
    public const SCUFFLE_NOT_OPEN = 100268;        //活动未开启
    public const SCUFFLE_CLOSED = 100269;          //活动已关闭
    public const SCUFFLE_ROOM_NOT_FOUND = 100270;  //房间不存在
    public const SCUFFLE_ROLL_POINT_NOT_ENOUGH = 100271;   //骰子点数不足
    public const SCUFFLE_ROOM_PUBLIC_POOL_CAR_NOT_FOUND = 100272;  //公共车池车辆不存在
    public const SCUFFLE_ROOM_PUBLIC_POOL_CAR_CD = 100273;  //公共车池车辆冷却中
    public const SCUFFLE_ROOM_PUBLIC_POOL_INDEX_ERROR = 100274;    //公共车池索引错误
    public const SCUFFLE_ROOM_PUBLIC_POOL_DATA_ERROR = 100275;    //公共车池数据错误
    public const SCUFFLE_ROOM_PLAYER_NOT_FOUND = 100276;       //房间内玩家不存在
    public const SCUFFLE_ROOM_PLAYER_NOT_SAME_GROUP = 100277;       //房间内玩家不时同队
    public const SCUFFLE_ROOM_TARGET_PLAYER_ERROR = 100278;        //不能与自己交换车
    public const SCUFFLE_ROOM_OVER_READY_TIME = 100279;            //超过准备时间
    public const SCUFFLE_ROOM_REPLACE_CAR_REFUSE = 100280;         //对方上次已拒绝
    public const SCUFFLE_ROOM_REPLACE_CAR_WAIT = 100281;           //当前申请等待对方回复
    public const SCUFFLE_ROOM_REPLACE_CAR_CD = 100282;             //申请冷却
    public const SCUFFLE_ROOM_REPLACE_CAR_TARGET_WAIT = 100283;    //对方正在申请,清等待
    public const SCUFFLE_ROOM_REPLACE_CAR_WAITING = 100284;    //正在申请换车,不能进行其他操作

    // account
    public const ACCOUNT_CREATE_ERROR = 100285;    // 选形象失败
    public const ACCOUNT_CREATE_NAME_ERROR = 100286;    // 选昵称失败
    public const ACCOUNT_SELECT_CAR_ERROR = 100287;    // 选车失败

    // 赛季奖励领取
    public const SEASON_REWARD_NOT_SATE_ERROR = 100288;  // 积分不够领取此奖励
    public const SEASON_REWARD_REPEATED_ERROR = 100289;  // 重复领取
    public const SEASON_REWARD_ERROR          = 100290;  // 领取失败
    public const SEASON_REWARD_NOT_FOUND_ERROR = 100291; // 没有可领取奖励

    // 福利活动
    public const WELFARE_FIND_7NEW_ERROR = 100292;            // 7日登录数据获取失败
    public const WELFARE_7NEW_NOT_REPEATED_ERROR = 100293;    // 7日重复领取
    public const WELFARE_RECEIVE_TIMEOUT_ERROR = 100294;      // 7日领取超时
    public const WELFARE_FIND_LOGIN_REWARD_ERROR = 100295;    // 登录奖励数据获取失败
    public const WELFARE_FIND_LOGIN_RECEIVE_ERROR = 100296;   // 登录奖励领取数据获取失败
    public const WELFARE_LOGIN_RECEIVE_REPEATED_ERROR = 100297;     // 登录奖励重复领取
    public const WELFARE_LOGIN_RECEIVE_ERROR = 100298;              // 领取失败，因为日签未完成
    public const WELFARE_FIND_WEEK_DATA_ERROR = 100299;             // 周签数据获取失败
    public const WELFARE_PARAMS_FORMAT_ERROR = 100301;              // 周签重复完成
    public const WELFARE_WEEK_RECEIVE_ERROR = 100302;              // 周签领取失败，因为任务未完成
    public const WELFARE_WEEK_RECEIVE_REPEATED_ERROR = 100303;     // 周签奖励重复领取
    public const WELFARE_FIND_WEEK_REWARD_ERROR = 100304;          // 周签奖励道具领取失败
    public const WELFARE_AGAIN_WEEK_RECEIVE_ERROR = 100305;        // 周签领取失败，因为任务已完成

    public const ZL_DEMAND_REPEATED_ERROR = 100309;  // 索要 但是自己已经开启战令
    public const ZL_GIVE_REPEATED_ERROR = 100310;    // 赠送 但是对方已开启战令
    public const ZL_SEND_MAIL_ERROR = 100311;        // 战令发送邮件失败

    public const SERVER_STATE_SEARCH_NOT_FOUND_ERROR = 100345;   // 服务器状态未初始化
    public const LOGIN_PASSWORD_NOT_EQUAL_ERROR = 100346;        // 密码不一致
    public const GUEST_BIND_PARAMS_ERROR = 100347;               // 绑定参数错误
    public const GUEST_BIND_ACCOUNT_IS_EXIST_ERROR = 100348;     // 渠道账号已经绑定
    public const GUEST_BIND_CHANGE_ACCOUNT_TYPE_ERROR = 100349;  // 账号类型修改失败
    public const SAVE_GUIDE_STEP_ERROR = 100350;                 // 新手引导保存步骤失败
    public const LOGIN_REPEATED_DEVICE = 100351;                 // 设备重复登录
    public const TASK_LOGIN_REWARD_REPEATED_ERROR = 100385;      // 重复领取任务登录奖励
    public const TASK_ACTIVE_TIME_FAILED_ERROR = 100386;         // 活动已结束
    public const TASK_ACTIVE_EXCHANGE_OUT = 100387;              // 活动领取超出上限
    public const TASK_MONEY_IS_FAILED = 100388;                  // 商城兑换 货币不足
    public const TASK_NOT_LOGIN = 100389;                        // 没登录 不能领

    public const TASK_SUB_ITEM_NUM_FAILED_ERROR = 100395;        // 节日活动 领取活跃度不足
    public const TASK_REWARD_REPEATED_ERROR = 100396;            // 节日活动 重复领取
    public const TASK_REWARD_FAILED_ERROR = 100397;              // 节日活动 领取奖励失败

    public const ACTIVITY_WEEK_LOGIN_GET_INFO_ERROR = 100400;    // 周末登录活动 查询数据失败
    public const ACTIVITY_WEEK_LOGIN_REWARD_ERROR = 100401;      // 未完成不可领取
    public const ACTIVITY_WEEK_LOGIN_REWARD_ITEM_ERROR = 100402; // 周末登录奖励 领取失败
    public const LOGIN_STEP_NUM_ERROR = 100412;                  // 步骤保存失败
    public const ERROR_AGAIN_TASK_ITEM_NUM_NOT_ENOUGH = 100413;  // 补签道具不足


}
