<?php

/**
 * 外观改造配置
 */

namespace Game\Constant;


class CarExteriorRefitDefine
{
    public const BIND_CAR = 1;   // 和车绑定的 存储所有拥有 format  UID*getTime*1|UID*getTime ...
    public const NORMAL   = 2;   // 正常改装 存储id 修改直接替换
    public const SPECIAL  = 3;   // 特殊改装 带位置信息...

    public const SKIN          = 1;  // 皮肤
    public const PAINT         = 2;  // 车漆
    public const TAIL          = 3;  // 尾翼
    public const HOOD          = 4;  // 引擎盖
    public const STICKER       = 5;  // 贴纸
    public const LIGHT_STRIP   = 6;  // 灯带
    public const ORNAMENTS     = 7;  // 挂饰
    public const TIRE          = 8;  // 轮胎
    public const NITROGEN      = 9;  // 氮气
    public const HUB           = 10; // 轮毂
    public const LICENSE_IMAGE = 11; // 车牌背景图
    public const LICENCE       = 12; // 号牌

    public const DB_SKIN          = 'Skin';
    public const DB_PAINT         = 'Paint';
    public const DB_TAIL          = 'Tail';
    public const DB_HOOD          = 'Hood';
    public const DB_STICKER       = 'Sticker';
    public const DB_LIGHT_STRIP   = 'LightStrip';
    public const DB_ORNAMENTS     = 'Ornaments';
    public const DB_TIRE          = 'Tire';
    public const DB_NITROGEN      = 'Nitrogen';
    public const DB_HUB           = 'Hub';
    public const DB_LICENSE_IMAGE = 'LicenseImage';
    public const DB_LICENCE       = 'Licence';

    public const REFIT_MAP = array(
        self::SKIN          => self::BIND_CAR,
        self::PAINT         => self::BIND_CAR,
        self::TAIL          => self::NORMAL,
        self::HOOD          => self::NORMAL,
        self::STICKER       => self::SPECIAL,
        self::LIGHT_STRIP   => self::BIND_CAR,
        self::ORNAMENTS     => self::SPECIAL,
        self::TIRE          => self::NORMAL,
        self::NITROGEN      => self::NORMAL,
        self::HUB           => self::NORMAL,
        self::LICENSE_IMAGE => self::NORMAL,
        self::LICENCE       => self::NORMAL,
    );

    public const DB_REFIT_MAP = array(
        self::SKIN          => self::DB_SKIN,
        self::PAINT         => self::DB_PAINT,
        self::TAIL          => self::DB_TAIL,
        self::HOOD          => self::DB_HOOD,
        self::STICKER       => self::DB_STICKER,
        self::LIGHT_STRIP   => self::DB_LIGHT_STRIP,
        self::ORNAMENTS     => self::DB_ORNAMENTS,
        self::TIRE          => self::DB_TIRE,
        self::NITROGEN      => self::DB_NITROGEN,
        self::HUB           => self::DB_HUB,
        self::LICENSE_IMAGE => self::DB_LICENSE_IMAGE,
        self::LICENCE       => self::DB_LICENCE,
    );

    // 校验使用的map
    public const DB_REFIT_CHECK_MAP = array(
        self::SKIN          => 'Skin',
        self::PAINT         => 'CarPaint',
        self::TAIL          => 'Empennage',
        self::HOOD          => 'Hood',
        self::STICKER       => 'CarStickers',
        self::LIGHT_STRIP   => 'StripOfLights',
        self::ORNAMENTS     => 'HangOrnament',
        self::TIRE          => 'Wheel',
        self::HUB           => 'Hub',
        self::LICENSE_IMAGE => 'Plate',
    );
}
