<?php

/**
 * 活动配置
 */

namespace Game\Constant;

class ActivityDefine
{
    //活动名称
    public const ACTIVITY_NAME_MAP_CHALLENGE = 1;   //地图挑战赛
    public const ACTIVITY_NAME_SCUFFLE = 2;         //大乱斗

    //活动状态
    public const ACTIVITY_STATUS_UNOPENED = 0;  //未开启
    public const ACTIVITY_STATUS_DOING = 1;     //进行中
    public const ACTIVITY_STATUS_CLOSE = 2;     //关闭

    public const ACTIVITY_NAME_MAP = array(

    );

    /**
     * @param int $activityName     活动名称
     * @param int $status           活动状态
     * @param int $activityId       对应活动的表进行的Id
     * @return string
     */
    public static function makeActivityTitleKey(int $activityName, int $status, int $activityId): string
    {
        return $activityName. "#" . $status. "#" . $activityId;
    }

    public static function analysisActivityYTitleKey(string $str): array
    {
        return explode("#", $str);
    }
}
