<?php

namespace Game\Config;

use Library\Common\Singletons;
use Zone;
class GameConfig
{
    use Singletons;

    private ConfigBase $config;

    public function InitConfig($config)
    {
        $this->config = $config;
    }

    public function SERVER_ID(): int
    {
        return $this->config->ServerId;
    }

    public function CHANNEL_ID(): int
    {
        return $this->config->ChannelId;
    }

    public function ROLE_ID_VERSION():int
    {
        return $this->config->RoleIdVersion;
    }

    // 玩家身上绑定的
    public function GAME_SERVICE_ID(): int
    {
        return $this->config->GameServiceId;
    }

    public function NOTICE_SERVICE(): int
    {
        return $this->config->NoticeServiceId;
    }

    public function NOTICE_SERVER_IP(): string
    {
        return $this->config->NoticeServerIp;
    }

    public function NOTICE_SERVER_PORT(): int
    {
        return $this->config->NoticeServerPort;
    }

    public function OPEN_SERVER_TIME():string
    {
        return $this->config->OpenServerTime;
    }

    public function DATA_VERSION(): int
    {
        return $this->config->DataVersion;
    }

    public function PLAYER_REDIS_NODE(): array
    {
        return $this->config->PlayerRedisNode;
    }

    public function SERVER_REDIS_NODE(): array
    {
        return $this->config->ServerRedisNode;
    }

    public function FULL_SERVER_REDIS_NODE(): array
    {
        return $this->config->FullServerRedisNode;
    }

    //对战匹配 单例
    public function MATCHING_REDIS_IP(): string
    {
        return $this->config->MatchingRedisIp;
    }

    public function MATCHING_REDIS_PORT(): int
    {
        return $this->config->MatchingRedisPort;
    }

    // 全局单例
    public function FULL_SERVER_IP(): string
    {
        return $this->config->FullServerIp;
    }

    public function FULL_SERVER_PORT(): int
    {
        return $this->config->FullServerPort;
    }

    // Service db
    public function SERVICE_SERVER_IP(): string
    {
        return $this->config->ServiceServerIp;
    }

    public function SERVICE_SERVER_PORT(): int
    {
        return $this->config->ServiceServerPort;
    }

    public function LOG_PATH(): string
    {
        return $this->config->LogPath;
    }

    public function CLI_LOG_PATH(): string
    {
        return $this->config->CLILogPath;
    }

    public function SERVICE_LOG_PATH(): string
    {
        return $this->config->ServiceLogPath;
    }

    public function SERVICE_SAVE_DATA_TIMEOUT(): int
    {
        return $this->config->ServiceSaveDataTimeout;
    }

    public function CLI_SERVER_SLEEP(): int
    {
        return $this->config->CLIServerSleep;
    }

    public function RANK_SERVER_ID(): array
    {
        return $this->config->RankServerId;
    }
}
