<?php
/**
 * 全局排行管理模块
 * @date 2022/6/28/028
 * @author JZW
 **/

namespace Framework\Model;


use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\ClientErrorCode;
use Game\Constant\DBTableDefine;
use Game\Data\Club\ClubPlayerData;

class RankModel
{
    use CommonDBHandler;

    public const CLUB_POINTS = 1;  //俱乐部积分排行榜

    public int $index = 0;

    public int $rankId = 0;
    public int $rankScore = 0;

    public int $maxCount = 0;
    public int $code = 200;

    private function checkParam(): bool
    {
        return !($this->rankId <= 0 || $this->rankScore < 0);
    }

    public function updateRank(): bool
    {

        if (!$this->checkParam()){
            $this->code = ClientErrorCode::ERROR_RANK_PARAM;
            return false;
        }
        if (!$this->getMemberScore($this->rankId, $score)){
            $score = 0;
        }
        return $this->addCommonRank(DBTableDefine::TABLE_RANK, $this->index, $this->rankId, $score + (int)$this->rankScore);
    }

    //从小到大排序
    public function getRank($start, $stop, &$ret): bool
    {
        return $this->searchCommonRank(DBTableDefine::TABLE_RANK, $this->index, $start, $stop, $ret);
    }

    //从大到小排序
    public function getRevRank($start, $stop, &$ret): bool
    {
        return $this->searchRevRankByIndexCommon(DBTableDefine::TABLE_RANK, $this->index, $start, $stop, $ret);
    }

    //查询排行值
    public function getMemberScore($rankId, &$ret): bool
    {
        if (!$this->searchRankScoreByKeyCommon(DBTableDefine::TABLE_RANK, $this->index, $rankId, $ret)){
            return false;
        }
        if (is_null($ret)){
            $ret = 0;
        }
        if ($ret == ""){
            return 0;
        }
        return true;
    }
}