<?php

/**
 * 系统定时
 */

namespace Framework\Model;

use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class CommonTimerModel
{
    use CommonDBHandler;

    private const TITLE_ID = 1;

    public function addTimer($model, $titleId, $time): bool
    {
        $key = $model . "-" . $titleId;
        if (false == $this->addCommonRank(
            $this->getModelType(),
            self::TITLE_ID,
            $key,
            $time
        )) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_ADD_ERROR,
                "[CommonTimerModel] add timer error",
                array(
                    "model" => $model,
                    "titleId" => $titleId,
                    "time" => $time
                )
            );
            return false;
        }
        return true;
    }

    public function delTimer($model, $titleId): bool
    {
        $key = $model . "-" . $titleId;
        if (false == $this->delCommonRank(
            $this->getModelType(),
            self::TITLE_ID,
            $key
        )) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_DEL_ERROR,
                "[CommonTimerModel] del timer error",
                array(
                    "model" => $model,
                    "titleId" => $titleId
                )
            );
            return false;
        }
        return true;
    }

    /**
     * @param $time
     * @return array (model=>(titleId=>expireTime,..)
     */
    public function searchExpire($time): array
    {
        $expireData = array();
        $arr = array();
        if (false == $this->searchCommonRank(
            $this->getModelType(),
            self::TITLE_ID,
            0,
            $time,
            $arr
        )) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_SEARCH_ERROR,
                "[CommonTimerModel] search timer error",
                array(
                    "time" => $time,
                )
            );
            return array();
        }
        foreach ($arr as $key => $expireTime) {
            $tmp = explode("-", $key);
            if (!is_array($tmp) || count($tmp) != 2) {
                LogMark::getInstance()->markError(
                    GameErrorCode::COMMON_TIMER_DATA_ERROR,
                    "[CommonTimerModel] data error",
                    array(
                        "key" => $key,
                    )
                );
                continue;
            }
            $model = $tmp[0];
            $titleId = $tmp[1];
            if (!array_key_exists($model, $expireData)) {
                $expireData[$model] = array($titleId => $expireTime);
            } else {
                $expireData[$model][$titleId] = $expireTime;
            }
            $this->delTimer($model, $titleId);
        }
        return $expireData;
    }

    public function searchAllCommonTimer(): array
    {
        $arr = array();
        if (false == $this->searchCommonRank(
                $this->getModelType(),
                self::TITLE_ID,
                0,
                PHP_INT_MAX,
                $arr
            )) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_SEARCH_ERROR,
                "[CommonTimerModel] searchAllCommonTimer error",
            );
            return array();
        }
        return $arr;
    }

    private function getModelType(): int
    {
        return DBTableDefine::TABLE_COMMON_TIMER;
    }
}
