<?php

/**
 * 赛季
 */

namespace Framework\Model;

use Framework\Log\LogMark;
use Framework\Logic\CommonDataLogic;
use Framework\Logic\CommonTimerLogic;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ModelManager;
use Game\Constant\ConstTemplate\TemplateMatchTime;
use Game\Constant\GameConstantDefine;
use Game\Constant\GameErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Logic\CommonConstLogic;

class CommonSeasonModel
{
    use CommonDataLogic;
    use CommonTimerLogic;
    use TemplateHelp;
    use CommonConstLogic;

    //赛季信息
    public function setSeasonId(int $seasonId, int $expireTime): bool
    {
        LogMark::getInstance()->markInfo(
            "[CommonSeasonModel] set new SeasonId:". (string)$seasonId
        );
        //设置赛季id
        if (false == $this->addCommonData($this->getPlayerModel(), $seasonId)) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_SEASON_ADD_DATA_ERROR,
                "[CommonSeasonModel] Init Season addCommonData Fail",
                array(
                    "seasonId" => $seasonId
                )
            );
            return false;
        }
        //设置赛季id
        $this->setSeasonIdToCommonConst($seasonId);
        //添加过期时间
        $this->addCommonTimer($this->getExpireModel(), $seasonId, $expireTime);
        return true;
    }

    //删除过期 开启下一赛季
    public function commonTimerExpire(array $expireData): bool
    {
        if(empty($expireData)) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_EXPIRE_DATA_ERROR,
                '[CommonSeasonModel] timerExpire array empty!');
            return false;
        }
        if (count($expireData) != 1) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_EXPIRE_DATA_ERROR,
                '[CommonSeasonModel] timerExpire array error!',
                $expireData
            );
            return false;
        }
        $seasonId = (int)array_keys($expireData)[0];
        $this->getNextSeasonId($seasonId);
        return true;
    }

    //获取下一个赛季id
    private function getNextSeasonId(int $seasonId)
    {
        $nextSeasonId = $seasonId + 1;
        $seasonData = $this->getSeasonConfigData($nextSeasonId);
        if (is_null($seasonData)) {
            //未找到下个赛季 继续当前赛季
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_SEASON_NOT_FOUND_NEXT_SEASON,
                "[CommonSeasonModel] next season not found",
                array(
                    "nowSeasonId" => $seasonId
                )
            );
            $seasonData = $this->getSeasonConfigData($seasonId);
            $expireTime = $seasonData[TemplateMatchTime::EndTime];
            if (!is_int($expireTime)) {
                LogMark::getInstance()->markError(
                    GameErrorCode::COMMON_SEASON_TIME_ERROR,
                    "[CommonSeasonModel] Season time error",
                    $seasonData
                );
                return;
            }
            $this->setSeasonId($seasonId, $expireTime);
            return ;
        }
        //设置下个赛季
        $expireTime = $seasonData[TemplateMatchTime::EndTime];
        if (!is_int($expireTime)) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_SEASON_TIME_ERROR,
                "[CommonSeasonModel] Season time error",
                $seasonData
            );
            return;
        }
        $this->setSeasonId($nextSeasonId, $expireTime);
        //设置赛季状态
        /**
        * @var CommonSeasonStatusModel $commonSeasonStatus
        */
        $commonSeasonStatus = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_SEASON_STATUS);
        $commonSeasonStatus->setSeasonStatus($nextSeasonId);

        // TODO: 清除上个赛季共用排行榜信息  暂时不清除数据 防止后续有历史排行榜需求

    }

    private function getSeasonConfigData(int $seasonId): ?array
    {
        $seasonConfigData = $this->getTable(TemplateDefine::TYPE_MATCH_TIME);
        if (is_null($seasonConfigData)) {
            LogMark::getInstance()->markError(
                GameErrorCode::TEMPLATE_ID_NOT_FOUND,
                "[CommonSeasonModel] tpl table not found",
                array(
                    "TemplateTable" => TemplateDefine::TYPE_MATCH_TIME
                )
            );
            return null;
        }
        return $seasonConfigData[$seasonId] ?? null;
    }

    //玩家赛季model
    private function getPlayerModel(): int
    {
        return ModelTypeDefine::SEASON;
    }

    //过期时间添加
    private function getExpireModel(): int
    {
        return ModelTypeDefine::COMMON_SEASON;
    }

    //设置赛季id
    private function setSeasonIdToCommonConst(int $seasonId)
    {
        $data = array(
            GameConstantDefine::COMMON_KEY_SEASON_ID => $seasonId
        );
        $this->saveCommonConstData($data);
    }
}
