<?php

/**
 * CommonModel.php
 * 文件描述
 * Created On 2022/1/18
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\Model;

use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\ModelTypeDefine;

class CommonModel
{
    use CommonDBHandler;

    public const TYPE_PLAY_ACCOUNT_PLAYER = 1; // account
    public const TYPE_PLAY_NAME_PLAYER = 2;    // nickName
    public const TYPE_PLAY_ROLEID_PLAYER = 3;  // roleID
    public const TYPE_PLAY_DEVICE_ID = 5;      // 设备表（游客登录用）

    public function getDBTable(): string
    {
        return DBTableDefine::TABLE_COMMON;
    }

    public function getModelType(): int
    {
        return ModelTypeDefine::COMMON;
    }

    public function startAdd($type, $key, $val): bool
    {
        $val .= "*";
        return $this->createTerm($this->getDBTable(), $type, $key, $val);
    }

    public function finishAdd($type, $key, $val): bool
    {
        return $this->createTerm($this->getDBTable(), $type, $key, $val);
    }

    public function search($type, $key): string
    {
        $ret = "";
        if (false == $this->searchCommonTerm($ret, $this->getDBTable(), $type, $key)) {
            return "";
        }
        return $ret;
    }

    //替换昵称
    public function replaceNickname(string $oldNickname, string $newNickname, int $playerId): bool
    {
        $data = array(
            1 => $playerId,
            2 => $oldNickname,
            3 => $newNickname
        );
        return $this->replaceNicknameDB(
            $this->getDBTable(),
            self::TYPE_PLAY_NAME_PLAYER,
            $data
        );
    }
}
