<?php

/**
 * 系统模块更新索引
 */

namespace Framework\Model;

use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class CommonDataModel
{
    use CommonDBHandler;

    private const TITLE_ID = 1;

    public function addCommonData(int $model, int $index): bool
    {
        if (false == $this->updateCommonTitle(
            $this->getModelType(),
            self::TITLE_ID,
            array(
                $model => $index,
            )
        )) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_DATA_UPDATE_ERROR,
                "[CommonDataModel] update model error",
                array(
                    "model" => $model,
                    "index" => $index
                )
            );
            return false;
        }
        return true;
    }

    public function addCommonDataArr(array $data): bool
    {
        if (false == $this->updateCommonTitle(
                $this->getModelType(),
                self::TITLE_ID,
                $data
            )) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_DATA_UPDATE_ERROR,
                "[CommonDataModel] update model error",
                $data
            );
            return false;
        }
        return true;
    }

    public function getCommonData(&$result): bool
    {
        if(!$this->searchCommonTitle(
            $this->getModelType(),
            self::TITLE_ID,
            $result)
        ) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_DATA_GET_ERROR,
                "[CommonDataModel] get model error"
            );
            return false;
        }
        return true;
    }

    private function getModelType(): int
    {
        return DBTableDefine::TABLE_COMMON_DATA;
    }
}
