<?php

/**
 * 全局活动
 */

namespace Framework\Model;


use Framework\Log\LogMark;
use Framework\Logic\Activity\CommonMapChallengeLogic;
use Framework\Logic\Activity\CommonScuffleLogic;
use Game\Constant\ActivityDefine;
use Game\Constant\GameErrorCode;

class CommonActivityModel
{
    use CommonMapChallengeLogic;
    use CommonScuffleLogic;

    //活动过期检查处理
    public function commonTimerExpire(array $expireData)
    {
        if(empty($expireData)) {
            LogMark::getInstance()->markError(
                GameErrorCode::COMMON_TIMER_EXPIRE_DATA_ERROR,
                '[CommonActivityModel] timerExpire array empty!');
            return false;
        }
        $indexArr = array_keys($expireData);
        LogMark::getInstance()->markInfo(
            "[CommonActivityModel] activity expire",
            $indexArr);
        foreach ($indexArr as $title) {
            [$activityName, $status, $activityId] = ActivityDefine::analysisActivityYTitleKey($title);
            $this->dealExpireActiveManage($activityName, $status, $activityId);
        }
    }

    //处理过期活动
    private function dealExpireActiveManage(int $activityName, int $status, int $activityId)
    {
        switch ($activityName)
        {
            case ActivityDefine::ACTIVITY_NAME_MAP_CHALLENGE:
                $this->dealMapChallengeExipre($status, $activityId);
                break;
            case ActivityDefine::ACTIVITY_NAME_SCUFFLE:
                $this->dealScuffleExipre($status, $activityId);
        }
    }
}
