<?php

/**
 * TimerLogic.php
 * 文件描述
 * Created On 2022/1/25
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\Logic;

use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Model\TimerModel;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Data\EventConditionData;
use Game\Logic\CrossDayResetLogic;
use Game\Model\Activity\WelfareModel;
use Game\Model\EventConditionModel;
use Game\Model\SyncModel;

trait TimerLogic
{
    use CommonDataLogic;
    use CrossDayResetLogic;
    use OnLineLogic;

    public function addTimer($modelType, $titleId, $time, int $playerId = 0): bool
    {
        /**
         * @var TimerModel $timer
         */
        $timer = ModelManager::getInstance()->getModel(ModelTypeDefine::TIMER);
        return $timer->addTimer($modelType, $titleId, $time, $playerId);
    }

    public function delTimer($modelType, $titleId): bool
    {
        /**
         * @var TimerModel $timer
         */
        $timer = ModelManager::getInstance()->getModel(ModelTypeDefine::TIMER);
        return $timer->delTimer($modelType, $titleId);
    }

    public function timerHeartBeat($time)
    {
        /**
         * @var TimerModel $timer
         */
        $timer = ModelManager::getInstance()->getModel(ModelTypeDefine::TIMER);
        $arr = $timer->searchExpire($time);
        if (!is_null($arr)) {
            foreach ($arr as $modelType => $expireData) {
                $model = ModelManager::getInstance()->getModel($modelType);
                if (method_exists($model, "timerExpire")) {
                    $model->timerExpire($expireData);
                }
            }
        }
        // 福利活动检测
        /**
         * @var WelfareModel $welfareModel
         */
        $welfareModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WELFARE);
        $welfareModel->checkWelfareActivity();

        //同步系统模块索引
        /**
         * @var SyncModel $syncModel
         */
        $syncModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SYNC);
        $lastSyncTime = $syncModel->getLastSyncTime();
        //检查跨天重置
        $this->crossDayReset($lastSyncTime);
        $upSyncTimeFlag = false;
        //时间间隔小于0 调过时间 重新检查
        if ($time - $lastSyncTime < 0 || $time - $lastSyncTime >= GameConstantDefine::SYNC_CHECK_TIME) {
            $upSyncTimeFlag = true;
            $syncModel->syncSysModel();
            //更新在线时间
            $this->addOnlineTime($time - $lastSyncTime);
        }
        if ((Utils::checkIsCrossDay($lastSyncTime))) {
            $upSyncTimeFlag = true;
        }
        if ($upSyncTimeFlag) {
            //更新同步时间
            $syncModel->updateLastSyncTime();
            $syncModel->savePlayerModelIndex();
        }
    }

    //更新在线时间
    private function addOnlineTime(int $addTime)
    {
        if ($addTime <= 0 || $addTime > GameConstantDefine::SYNC_CHECK_TIME * 2) {
            return;
        }
        LogMark::getInstance()->markInfo("[addOnlineTime] {$addTime}");
        /**
         * @var EventConditionModel $condition
         */
        $condition = ModelManager::getInstance()->getModel(ModelTypeDefine::EVENT_CONDITION);
        $condition->addEventConditionValue(EventConditionData::EVENT_CONDITION_KEY_ONLINE_TIME, $addTime);
        // 触发任务 在线时间
        $param = array(
            GameConstantDefine::EVENT_KEY_NUM => $addTime,  //增加时间 秒
        );
        $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_ONLINE_TIME, $param);
    }
}
