<?php
/**
 * 排行榜
 * @date 2022/6/28/028
 * @author JZW
 **/

namespace Framework\Logic;


use Framework\MVC\ModelManager;
use Framework\Model\RankModel;
use Game\Constant\ModelTypeDefine;
use Game\Data\Club\ClubPlayerData;
use Game\Model\Club\ClubModel;

trait RankLogic
{
    /**
     * 俱乐部积分排行榜
     * @param int $score 数值
     * @param bool $init 是否初始化
     * @return bool
     */
    public function addClubPointsRank(int $score, bool $init=false): bool
    {
        if($score <= 0 && !$init){
            return true;
        }
        $clubPlayer = new ClubPlayerData(0, 0);
        /**
         * @var ClubModel $clubModel
         */
        $clubModel = ModelManager::getInstance()->getModel(ModelTypeDefine::CLUB);
        $clubModel->searchClubPlayerData($clubPlayer);

        $clubId = $clubPlayer->clubID;
        if ($clubId == 0){
            return true;
        }
        /**
         * @var RankModel $rank
         */
        $rank = ModelManager::getInstance()->getModel(ModelTypeDefine::RANK);
        $rank->index = RankModel::CLUB_POINTS;
        $rank->rankId = $clubId;
        $rank->rankScore = $score;
        return $rank->updateRank();
    }

    //查询俱乐部积分排行榜
    public function getClubPointsRank(&$ret, $page = 1): int
    {
        $number = 20;
        $start = 0;
        if ($page > 1){
            $start += $page * $number;
        }
        $end = $start + $number - 1;
        /**
         * @var RankModel $rank
         */
        $rank = ModelManager::getInstance()->getModel(ModelTypeDefine::RANK);
        $rank->index = RankModel::CLUB_POINTS;
        $rank->getRevRank($start, $end, $ret);
        return $rank->code;
    }
}