<?php

/**
 * PacketCacheLogic.php
 * 文件描述
 * Created On 2022/2/16
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Framework\Logic;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Model\PacketCacheModel;
use Game\Constant\ModelTypeDefine;
use Google\Protobuf\Internal\Message;

trait PacketCacheLogic
{
    public function addPacket(int $packetId, Message $packet, int $playerID = 0): bool
    {
        /**
         * @var PacketCacheModel $packetCache
         */
        $packetCache = ModelManager::getInstance()->getModel(ModelTypeDefine::PACKET_CACHE);
        LogMark::getInstance()->setPlayerId($packetCache->playerId);
        LogMark::getInstance()->markInfo(
            "[PacketCacheLogic] add packet",
            array(
                "packetId" => $packetId,
                "message" => $packet->serializeToJsonString(),
                "toPlayerId" => $playerID
            )
        );
        return $packetCache->addPacket($packetId, $packet, $playerID);
    }
}
