<?php
/**
 *
 * @date {ct}
 * @author JZW
 **/


namespace Framework\Logic;


use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Model\OnLineModel;
use Game\Constant\ModelTypeDefine;

trait OnLineLogic
{
    //更新在线时间
    public function updateTimeById($playerId, $time): bool
    {
        /**
         * @var OnLineModel $onLine
         */
        $onLine = ModelManager::getInstance()->getModel(ModelTypeDefine::ON_LINE);
        return $onLine->updateOnLine($playerId, $time);
    }

    public function searchTimeById($playerId, &$ret): bool
    {
        /**
         * @var OnLineModel $onLine
         */
        $onLine = ModelManager::getInstance()->getModel(ModelTypeDefine::ON_LINE);
        return $onLine->getOnLineTime($playerId, $ret);
    }

    /**
     * 判断单个玩家是否在线  true 在线 false 离线
     * @param int $playerId
     * @param int $time
     * @return bool
     */
    public function checkOnePlayerOnLine(int $playerId, int $time): bool
    {
        $now = Utils::getServerTimestamp();
        $minTime = $now - OnLineModel::Interval;
        $maxTime = $now + OnLineModel::Interval;
        {
            if ($playerId == 0) {
                return true;
            }
            if ($time == 0){
                return false;
            }
            if ($time >= $minTime && $time <= $maxTime){
                return true;
            }
            LogMark::getInstance()->markInfo(
                '[OnLineLogic] checkOnePlayerOnLine, offline player time is :',
                [
                    'playerID' => $playerId,
                    'minTime' => $minTime,
                    'time' => $time,
                    'maxTime' => $maxTime
                ]
            );
        }
        return false;
    }

    /**
     * 获取当前在线的玩家
     * @param $ret
     * @return bool
     */
    public function getOnLinePlayerId(&$ret): bool
    {
        /**
         * @var OnLineModel $onLine
         */
        $onLine = ModelManager::getInstance()->getModel(ModelTypeDefine::ON_LINE);
        return $onLine->getOnLineBySore($ret);
    }

    /**
     * 获取所有离线玩家但未处理的玩家
     * @param $ret
     * @return bool
     */
    public function getOffLinePlayerId(&$ret): bool
    {
        /**
         * @var OnLineModel $onLine
         */
        $onLine = ModelManager::getInstance()->getModel(ModelTypeDefine::ON_LINE);
        return $onLine->getOffLineBySore($ret);
    }
}