<?php

/**
 * 系统定时
 */

namespace Framework\Logic;

use Framework\Log\LogMark;
use Framework\MVC\ModelManager;
use Framework\Model\CommonTimerModel;
use Game\Constant\ModelTypeDefine;

trait CommonTimerLogic
{
    public function addCommonTimer(int $modelType, string $titleId, int $time): bool
    {
        /**
         * @var CommonTimerModel $commonTimer
         */
        $commonTimer = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_TIMER);
        LogMark::getInstance()->markInfo(
            "[CommonTimerLogic] add timer",
            array(
                "model" => $modelType,
                "titleId" => $titleId,
                "time" => $time,
            )
        );
        return $commonTimer->addTimer($modelType, $titleId, $time);
    }

    public function delCommonTimer(int $modelType, string $titleId): bool
    {
        /**
         * @var CommonTimerModel $commonTimer
         */
        $commonTimer = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_TIMER);
        LogMark::getInstance()->markInfo(
            "[CommonTimerLogic] del timer",
            array(
                "model" => $modelType,
                "titleId" => $titleId,
            )
        );
        return $commonTimer->delTimer($modelType, $titleId);
    }

    public function commonTimerHeartBeat($time)
    {
        /**
         * @var CommonTimerModel $commonTimer
         */
        $commonTimer = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_TIMER);
        $ret = $commonTimer->searchExpire($time);
        foreach ($ret as $modelType => $expireData) {
            $model = ModelManager::getInstance()->getModel($modelType);
            if (method_exists($model, "commonTimerExpire")) {
                $model->commonTimerExpire($expireData);
            }
        }
    }

    //获取当前全部的定时任务
    public function getAllCommonTimer(): array
    {
        /**
         * @var CommonTimerModel $commonTimer
         */
        $commonTimer = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON_TIMER);
        return $commonTimer->searchAllCommonTimer();
    }
}
